/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.meta.PolygonalShape;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PTTriangle
extends PolygonalShape
implements MoveBase {
    public static final String TYPE_LABEL = "Triangle";
    private static final long serialVersionUID = 5793183274737251118L;
    private Point secondNode;
    private Point thirdNode;

    public PTTriangle() {
        this(4, 2, 0, 0, 0, 0);
    }

    public PTTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this(new Point(x1, y1), new Point(x2, y2), new Point(x3, y3));
    }

    public PTTriangle(Point first, Point second, Point third) {
        this.initializeWithDefaults(this.getType());
        this.setFirstNode(first);
        this.setSecondNode(second);
        this.setThirdNode(third);
    }

    public int getFileVersion() {
        return 1;
    }

    public int getNodeCount() {
        if (this.firstNode == null) {
            return 0;
        }
        return 3;
    }

    public Point getSecondNode() {
        if (this.secondNode == null) {
            this.secondNode = new Point(this.getFirstNode().x + 10, this.getFirstNode().y + 10);
        }
        return this.secondNode;
    }

    public Point getThirdNode() {
        if (this.thirdNode == null) {
            this.thirdNode = new Point(this.getSecondNode().x + 10, this.getSecondNode().y + 10);
        }
        return this.thirdNode;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setSecondNode(int x, int y) {
        if (this.secondNode == null) {
            this.secondNode = new Point(x, y);
        } else {
            this.secondNode.x = x;
            this.secondNode.y = y;
        }
    }

    public void setSecondNode(Point node) {
        if (node == null) {
            this.setSecondNode(0, 0);
        } else {
            this.setSecondNode(node.x, node.y);
        }
    }

    public void setThirdNode(int x, int y) {
        if (this.thirdNode == null) {
            this.thirdNode = new Point(x, y);
        } else {
            this.thirdNode.x = x;
            this.thirdNode.y = y;
        }
    }

    public void setThirdNode(Point node) {
        if (node == null) {
            this.setThirdNode(0, 0);
        } else {
            this.setThirdNode(node.x, node.y);
        }
    }

    public void setNode(int pos, int x, int y) {
        switch (pos) {
            case 0: {
                this.setFirstNode(x, y);
                break;
            }
            case 1: {
                this.setSecondNode(x, y);
                break;
            }
            case 2: {
                this.setThirdNode(x, y);
                break;
            }
            default: {
                MessageDisplay.errorMsg("Cannot set node # " + pos + " for a triangle, only [0, 2]", 4);
            }
        }
    }

    public void setNode(int pos, Point node) {
        switch (pos) {
            case 0: {
                this.setFirstNode(node);
                break;
            }
            case 1: {
                this.setSecondNode(node);
                break;
            }
            case 2: {
                this.setThirdNode(node);
                break;
            }
            default: {
                MessageDisplay.errorMsg("Cannot set node # " + pos + " for a triangle, only [0, 2]", 4);
            }
        }
    }

    public void scale(double scaleX, double scaleY) {
        if (this.getFirstNode() != null) {
            this.firstNode.x = (int)((double)this.firstNode.x * scaleX);
            this.firstNode.y = (int)((double)this.firstNode.y * scaleY);
        }
        if (this.getSecondNode() != null) {
            this.secondNode.x = (int)((double)this.secondNode.x * scaleX);
            this.secondNode.y = (int)((double)this.secondNode.y * scaleY);
        }
        if (this.getThirdNode() != null) {
            this.thirdNode.x = (int)((double)this.thirdNode.x * scaleX);
            this.thirdNode.y = (int)((double)this.thirdNode.y * scaleY);
        }
    }

    public int getDifferentNodesCount() {
        return this.getNodeCount();
    }

    public void translate(int deltaX, int deltaY) {
        this.getFirstNode().translate(deltaX, deltaY);
        this.getSecondNode().translate(deltaX, deltaY);
        this.getThirdNode().translate(deltaX, deltaY);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTTriangle ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append(this.nodeToString(this.getFirstNode()));
        result.append(this.nodeToString(this.getSecondNode()));
        result.append(this.nodeToString(this.getThirdNode()));
        return result.toString();
    }

    public Polygon toPolygon() {
        if (this.getFirstNode() == null) {
            return new Polygon(new int[]{4, 2, 6}, new int[]{2, 4, 4}, 3);
        }
        Point node = this.getFirstNode();
        int[] xpoints = new int[]{node.x, this.getSecondNode().x, this.getThirdNode().x};
        int[] ypoints = new int[]{node.y, this.getSecondNode().y, this.getThirdNode().y};
        return new Polygon(xpoints, ypoints, 3);
    }

    public void paint(Graphics g) {
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillPolygon(this.toPolygon());
        }
        g.setColor(this.color);
        g.drawPolygon(this.toPolygon());
    }

    public Object clone() {
        PTTriangle triangle = new PTTriangle();
        this.cloneCommonFeaturesInto(triangle);
        return triangle;
    }

    protected void cloneCommonFeaturesInto(PTTriangle targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setSecondNode(this.getSecondNode().x, this.getSecondNode().y);
    }

    public int getLength() {
        int result = MSMath.dist(this.getFirstNode(), this.getSecondNode());
        result += MSMath.dist(this.getSecondNode(), this.getThirdNode());
        return result += MSMath.dist(this.getThirdNode(), this.getFirstNode());
    }

    public Point getPointAtLength(int length) {
        int remainingLength = length;
        int nrSide = 0;
        int size = this.getLength();
        while (remainingLength > size) {
            remainingLength -= size;
            ++nrSide;
        }
        Point node = this.getFirstNode();
        switch (nrSide %= 4) {
            case 1: {
                return new Point(node.x + size, node.y + remainingLength);
            }
            case 2: {
                return new Point(node.x + size - remainingLength, node.y);
            }
            case 3: {
                return new Point(node.x, node.y + size - remainingLength);
            }
        }
        return new Point(node.x + remainingLength, node.y);
    }

    public void useAsMoveBase() {
    }

    public Rectangle getBoundingBox() {
        Polygon poly = this.toPolygon();
        return poly.getBounds();
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".node2", this.getSecondNode());
        defaultProperties.put(String.valueOf(this.getType()) + ".node3", this.getThirdNode());
    }

    public void discard() {
        super.discard();
    }
}

