/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.meta.ArrowablePrimitive;
import animal.graphics.meta.OpenLineBasedShape;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PTLine
extends OpenLineBasedShape
implements MoveBase,
ArrowablePrimitive {
    public static final String TYPE_LABEL = "Line";
    private static final long serialVersionUID = 5293164474737251118L;
    private Point startNode = new Point(0, 0);
    private Point endNode = new Point(0, 0);

    public PTLine() {
        this.initializeWithDefaults(this.getType());
    }

    public PTLine(int x1, int y1, int x2, int y2) {
        this.initializeWithDefaults(this.getType());
        this.setStartNode(x1, y1);
        this.setEndNode(x2, y2);
    }

    public PTLine(Point nodeA, Point nodeB) {
        this(nodeA.x, nodeA.y, nodeB.x, nodeB.y);
    }

    public Point getEndNode() {
        return this.endNode;
    }

    public Point getNode(boolean isStartNode) {
        if (isStartNode) {
            return this.getStartNode();
        }
        return this.getEndNode();
    }

    public Point getStartNode() {
        return this.startNode;
    }

    public int getNodeCount() {
        int count = 0;
        if (this.startNode != null) {
            ++count;
        }
        if (this.endNode != null) {
            ++count;
        }
        return count;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setEndNode(Point p) {
        if (p != null) {
            this.setEndNode(p.x, p.y);
        }
    }

    public void setEndNode(int x, int y) {
        if (this.endNode == null) {
            this.endNode = new Point(x, y);
        } else {
            this.endNode.x = x;
            this.endNode.y = y;
        }
    }

    public void setNode(int nodeNr, Point p) {
        if (p != null) {
            if (nodeNr == 0) {
                this.setStartNode(p.x, p.y);
            } else {
                this.setEndNode(p.x, p.y);
            }
        }
    }

    public void setStartNode(Point p) {
        if (p != null) {
            this.setStartNode(p.x, p.y);
        }
    }

    public void setStartNode(int x, int y) {
        if (this.startNode == null) {
            this.startNode = new Point(x, y);
        } else {
            this.startNode.x = x;
            this.startNode.y = y;
        }
    }

    public void rotate(double angle) {
        PTPoint start = new PTPoint(this.startNode);
        start.rotate(angle);
        this.setStartNode(start.toPoint());
        PTPoint end = new PTPoint(this.endNode);
        end.rotate(angle);
        this.setEndNode(end.toPoint());
    }

    public void rotate(double angle, PTPoint center) {
        PTPoint start = new PTPoint(this.startNode);
        start.rotate(angle, center);
        this.setStartNode(start.toPoint());
        PTPoint end = new PTPoint(this.endNode);
        end.rotate(angle, center);
        this.setEndNode(end.toPoint());
    }

    public void scale(double scaleX, double scaleY) {
        PTPoint start = new PTPoint(this.startNode);
        start.scale(scaleX, scaleY);
        this.setStartNode(start.toPoint());
        PTPoint end = new PTPoint(this.endNode);
        end.scale(scaleX, scaleY);
        this.setEndNode(end.toPoint());
    }

    public void shear(double shearX, double shearY) {
        PTPoint start = new PTPoint(this.startNode);
        start.shear(shearX, shearY);
        this.setStartNode(start.toPoint());
        PTPoint end = new PTPoint(this.endNode);
        end.shear(shearX, shearY);
        this.setEndNode(end.toPoint());
    }

    public void translate(int deltaX, int deltaY) {
        this.startNode.translate(deltaX, deltaY);
        this.endNode.translate(deltaX, deltaY);
    }

    public void translate(boolean isStartNode, int deltaX, int deltaY) {
        if (isStartNode) {
            this.startNode.translate(deltaX, deltaY);
        } else {
            this.endNode.translate(deltaX, deltaY);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTLine ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append("(").append(this.startNode.x).append(", ");
        result.append(this.startNode.y).append("), (").append(this.endNode.x);
        result.append(", ").append(this.endNode.y).append(")");
        return result.toString();
    }

    public Polygon toPolygon() {
        if (this.startNode == null || this.endNode == null) {
            return new Polygon(new int[2], new int[2], 2);
        }
        return new Polygon(new int[]{this.startNode.x, this.endNode.x}, new int[]{this.startNode.y, this.endNode.y}, 2);
    }

    public void paint(Graphics g) {
        Polygon poly = this.toPolygon();
        g.setColor(this.getColor());
        g.drawPolyline(poly.xpoints, poly.ypoints, 2);
        if (this.hasBWArrow()) {
            this.drawArrow(g, false);
        }
        if (this.hasFWArrow()) {
            this.drawArrow(g, true);
        }
    }

    private void drawArrow(Graphics g, boolean forward) {
        if (forward) {
            PTLine.drawArrow(g, this.startNode, this.endNode);
        } else {
            PTLine.drawArrow(g, this.endNode, this.startNode);
        }
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".start", this.getStartNode());
        defaultProperties.put(String.valueOf(this.getType()) + ".end", this.getEndNode());
    }

    public Object clone() {
        PTLine targetShape = new PTLine();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTLine targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setStartNode(this.getStartNode().x, this.getStartNode().y);
        targetShape.setEndNode(this.getEndNode().x, this.getEndNode().y);
    }

    public int getLength() {
        return MSMath.dist(this.startNode, this.endNode);
    }

    public Point getPointAtLength(int length) {
        float percent = 1.0f * (float)length / (float)this.getLength();
        return new Point((int)((float)this.startNode.x + (float)(this.endNode.x - this.startNode.x) * percent), (int)((float)this.startNode.y + (float)(this.endNode.y - this.startNode.y) * percent));
    }

    public void useAsMoveBase() {
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    public Rectangle getBoundingBox() {
        int dy;
        int minY;
        int dx;
        int minX;
        if (this.startNode == null || this.endNode == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (this.startNode.x < this.endNode.x) {
            minX = this.startNode.x;
            dx = this.endNode.x - minX;
        } else {
            minX = this.endNode.x;
            dx = this.startNode.x - minX;
        }
        if (this.startNode.y < this.endNode.y) {
            minY = this.startNode.y;
            dy = this.endNode.y - minY;
        } else {
            minY = this.endNode.y;
            dy = this.startNode.y - minY;
        }
        return new Rectangle(minX, minY, dx, dy);
    }

    public int getFileVersion() {
        return 1;
    }

    public void discard() {
        this.startNode = null;
        this.endNode = null;
        super.discard();
    }
}

