/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.graphics.meta.TextContainer;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class PTGraph
extends PTGraphicObject
implements TextContainer {
    public static final String TYPE_LABEL = "Graph";
    public static final String UNDEFINED_EDGE = "^";
    public static final String UNDEFINED_EDGE_WEIGHT = "%";
    protected PTText[] nodeText;
    protected PTArc[] nodes;
    protected PTText[][] edgeText;
    protected PTPolyline[][] edges;
    protected PTArc[] edgeLoop;
    protected boolean directed;
    protected boolean weighted;
    protected boolean showIndices;
    protected Point origin;
    public int length;
    protected Font nodeFont;
    protected Font edgeFont;
    protected FontMetrics nodeFm;
    protected FontMetrics edgeFm;
    protected Color backgroundColor;
    protected Color edgeFontColor;
    protected Color elemHighlightColor;
    protected Color highlightColor;
    protected Color outlineColor;
    protected final byte DEACTIVATED = 0;
    protected final byte ACTIVATED = 1;
    protected final byte HIGHLIGHTED = (byte)2;
    protected final byte ELEM_HIGHLIGHTED = (byte)4;
    protected final byte VISIBLE = (byte)8;
    protected byte[] nodeStates;
    protected byte[][] edgeStates;
    protected byte[][] edgeWeightStates;

    public PTGraph() {
        this(AnimalConfiguration.getDefaultConfiguration().getDefaultIntValue(TYPE_LABEL, "graphSize", 10));
    }

    public PTGraph(int size) {
        this.initializeWithDefaults(this.getType());
        this.init();
    }

    public void initializeWithDefaults(String primitiveName) {
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.backgroundColor = config.getDefaultColor(primitiveName, "bgColor", Color.WHITE);
        this.directed = config.getDefaultBooleanValue(primitiveName, "directed", false);
        this.edgeFont = config.getDefaultFontValue(primitiveName, "edgeFont", new Font("SansSerif", 0, 12));
        this.edgeFm = Animal.getConcreteFontMetrics(this.edgeFont);
        this.nodeFont = config.getDefaultFontValue(primitiveName, "nodeFont", new Font("SansSerif", 0, 12));
        this.nodeFm = Animal.getConcreteFontMetrics(this.nodeFont);
        this.length = config.getDefaultIntValue(primitiveName, "graphSize", 10);
        this.edgeFontColor = config.getDefaultColor(primitiveName, "edgeFontColor", Color.BLACK);
        this.elemHighlightColor = config.getDefaultColor(primitiveName, "elemHighlightColor", Color.RED);
        this.highlightColor = config.getDefaultColor(primitiveName, "highkightColor", Color.BLUE);
        this.outlineColor = config.getDefaultColor(primitiveName, "outlineColor", Color.BLACK);
        this.showIndices = config.getDefaultBooleanValue(primitiveName, "showIndices", false);
        this.weighted = config.getDefaultBooleanValue(primitiveName, "weighted", true);
        this.origin = new Point(10, 10);
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public PTText getPTTextNode(int i) {
        return this.nodeText[i];
    }

    public PTText getPTTextEdge(int i, int j) {
        return this.edgeText[i][j];
    }

    public PTArc getNode(int i) {
        return this.nodes[i];
    }

    public PTPolyline getEdge(int i, int j) {
        return this.edges[i][j];
    }

    public PTArc getEdgeLoop(int i) {
        return this.edgeLoop[i];
    }

    public void enterValueNode(int index, String val) {
        if (index >= 0 && index < this.length) {
            this.nodeText[index].setText(val);
            this.resizeNode(index);
        }
    }

    public String getValueNode(int index) {
        if (index >= 0 && index < this.length) {
            return this.nodeText[index].getText();
        }
        return null;
    }

    public void enterValueEdge(int index1, int index2, String val) {
        if (index1 >= 0 && index2 >= 0 && index1 < this.length && index2 < this.length) {
            this.edgeText[index1][index2].setText(val);
            this.setEdge(index1, index2);
            this.setEdge(index2, index1);
        }
    }

    public String getValueEdge(int index1, int index2) {
        if (index1 >= 0 && index1 < this.length && index2 >= 0 && index2 < this.length) {
            return this.edgeText[index1][index2].getText();
        }
        return null;
    }

    public void setDepth(int newDepth) {
        newDepth = newDepth < 2 ? 2 : newDepth;
        super.setDepth(newDepth);
        int i = 0;
        while (i < this.length) {
            this.nodeText[i].setDepth(newDepth - 2);
            this.nodes[i].setDepth(newDepth);
            this.edgeLoop[i].setDepth(newDepth);
            ++i;
        }
        int j = 0;
        while (j < this.length) {
            int k = 0;
            while (k < this.length) {
                this.edgeText[j][k].setDepth(newDepth - 2);
                this.edges[j][k].setDepth(newDepth);
                ++k;
            }
            ++j;
        }
    }

    public void setActivatedNode(int i, boolean newState) {
        if (i >= 0 && i < this.length) {
            if (newState) {
                this.nodeStates[i] = (byte)(this.nodeStates[i] | 1);
                this.nodes[i].setFillColor(this.isHighlightedNode(i) ? this.getHighlightColor() : this.getBGColor());
                this.nodeText[i].setColor(this.isElemHighlightedNode(i) ? this.getElemHighlightColor() : this.getNodeFontColor());
            } else {
                this.nodeStates[i] = (byte)(this.nodeStates[i] & 0xFFFFFFFE);
                this.nodes[i].setFillColor(Color.GRAY);
                this.nodeText[i].setColor(Color.DARK_GRAY);
            }
        }
    }

    public void setActivatedEdge(int i, int j, boolean newState) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            if (newState) {
                this.edgeStates[i][j] = (byte)(this.edgeStates[i][j] | 1);
                this.edgeWeightStates[i][j] = (byte)(this.edgeWeightStates[i][j] | 1);
                this.edgeText[i][j].setColor(this.isElemHighlightedEdge(i, j) ? this.getElemHighlightColor() : this.getEdgeFontColor());
                if (i != j) {
                    this.edges[i][j].setColor(this.isHighlightedEdge(i, j) ? this.getHighlightColor() : this.getOutlineColor());
                } else {
                    this.edgeLoop[i].setColor(this.isHighlightedEdge(i, j) ? this.getHighlightColor() : this.getOutlineColor());
                }
            } else {
                this.edgeStates[i][j] = (byte)(this.edgeStates[i][j] & 0xFFFFFFFE);
                this.edgeWeightStates[i][j] = (byte)(this.edgeWeightStates[i][j] & 0xFFFFFFFE);
                this.edgeText[i][j].setColor(Color.DARK_GRAY);
                if (i != j) {
                    this.edges[i][j].setColor(Color.GRAY);
                } else {
                    this.edgeLoop[i].setColor(Color.GRAY);
                }
            }
        }
    }

    public boolean isActivatedNode(int i) {
        if (i >= 0 && i < this.length) {
            return (this.nodeStates[i] & 1) == 1;
        }
        return false;
    }

    public boolean isActivatedEdge(int i, int j) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            return (this.edgeStates[i][j] & 1) == 1;
        }
        return false;
    }

    public void setHighlightedNode(int i, boolean highlight) {
        if (i >= 0 && i < this.length) {
            byte by = this.nodeStates[i] = highlight ? (byte)(this.nodeStates[i] | 2) : (byte)(this.nodeStates[i] & 0xFFFFFFFD);
            if (this.isActivatedNode(i)) {
                this.nodes[i].setFillColor(this.isHighlightedNode(i) ? this.getHighlightColor() : this.getBGColor());
            }
        }
    }

    public void setHighlightedEdge(int i, int j, boolean highlight) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            byte by = this.edgeStates[i][j] = highlight ? (byte)(this.edgeStates[i][j] | 2) : (byte)(this.edgeStates[i][j] & 0xFFFFFFFD);
            if (this.isActivatedEdge(i, j)) {
                if (i != j) {
                    this.edges[i][j].setColor(this.isHighlightedEdge(i, j) ? this.getHighlightColor() : this.getOutlineColor());
                } else {
                    this.edgeLoop[i].setColor(this.isHighlightedEdge(i, j) ? this.getHighlightColor() : this.getOutlineColor());
                }
            }
        }
    }

    public boolean isHighlightedNode(int i) {
        if (i >= 0 && i < this.length) {
            return (this.nodeStates[i] & 2) == 2;
        }
        return false;
    }

    public boolean isHighlightedEdge(int i, int j) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            return (this.edgeStates[i][j] & 2) == 2;
        }
        return false;
    }

    public void setVisibleNode(int i, boolean visible) {
        if (i >= 0 && i < this.length) {
            this.nodeStates[i] = visible ? (byte)(this.nodeStates[i] | 8) : (byte)(this.nodeStates[i] & 0xFFFFFFF7);
        }
    }

    public void setVisibleEdge(int i, int j, boolean visible) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            this.edgeStates[i][j] = visible ? (byte)(this.edgeStates[i][j] | 8) : (byte)(this.edgeStates[i][j] & 0xFFFFFFF7);
        }
    }

    public void setEdgeWeightVisibility(int i, int j, boolean visible) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            this.edgeWeightStates[i][j] = visible ? (byte)(this.edgeWeightStates[i][j] | 8) : (byte)(this.edgeWeightStates[i][j] & 0xFFFFFFF7);
        }
    }

    public boolean isVisibleNode(int i) {
        if (i >= 0 && i < this.length) {
            return (this.nodeStates[i] & 8) == 8;
        }
        return false;
    }

    public boolean isVisibleEdge(int i, int j) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            return (this.edgeStates[i][j] & 8) == 8;
        }
        return false;
    }

    public void setElemHighlightedNode(int i, boolean highlight) {
        if (i >= 0 && i < this.length) {
            byte by = this.nodeStates[i] = highlight ? (byte)(this.nodeStates[i] | 4) : (byte)(this.nodeStates[i] & 0xFFFFFFFB);
            if (this.isActivatedNode(i)) {
                this.nodeText[i].setColor(highlight ? this.getElemHighlightColor() : this.getNodeFontColor());
            }
        }
    }

    public void setElemHighlightedEdge(int i, int j, boolean highlight) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            byte by = this.edgeStates[i][j] = highlight ? (byte)(this.edgeStates[i][j] | 4) : (byte)(this.edgeStates[i][j] & 0xFFFFFFFB);
            if (this.isActivatedEdge(i, j)) {
                this.edgeText[i][j].setColor(highlight ? this.getElemHighlightColor() : this.getEdgeFontColor());
            }
        }
    }

    public boolean isElemHighlightedNode(int i) {
        if (i >= 0 && i < this.length) {
            return (this.nodeStates[i] & 4) == 4;
        }
        return false;
    }

    public boolean isElemHighlightedEdge(int i, int j) {
        if (i >= 0 && i < this.length && j >= 0 && j < this.length) {
            return (this.edgeStates[i][j] & 4) == 4;
        }
        return false;
    }

    public void setSize(int m) {
        this.length = m;
        this.init();
    }

    public int getSize() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setBGColor(Color c) {
        this.backgroundColor = c;
        int i = 0;
        while (i < this.length) {
            if (this.isActivatedNode(i)) {
                this.nodes[i].setFillColor(this.isHighlightedNode(i) ? this.getHighlightColor() : c);
            }
            ++i;
        }
    }

    public Color getBGColor() {
        return this.backgroundColor;
    }

    public void setNodeFont(Font f) {
        this.nodeFont = f;
        this.nodeFm = Animal.getConcreteFontMetrics(f);
        int i = 0;
        while (i < this.length) {
            this.nodeText[i].setFont(f);
            ++i;
        }
    }

    public void setEdgeFont(Font f) {
        this.edgeFont = f;
        this.edgeFm = Animal.getConcreteFontMetrics(f);
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                this.edgeText[i][j].setFont(f);
                ++j;
            }
            ++i;
        }
    }

    public Font getNodeFont() {
        return this.nodeFont;
    }

    public Font getEdgeFont() {
        return this.edgeFont;
    }

    public void setNodeFontColor(Color c) {
        this.setColor(c);
        int i = 0;
        while (i < this.length) {
            this.nodeText[i].setColor(c);
            ++i;
        }
    }

    public void setEdgeFontColor(Color c) {
        this.edgeFontColor = c;
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                this.edgeText[i][j].setColor(c);
                ++j;
            }
            ++i;
        }
    }

    public Color getNodeFontColor() {
        return this.getColor();
    }

    public Color getEdgeFontColor() {
        return this.edgeFontColor;
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
        int i = 0;
        while (i < this.length) {
            if (this.isActivatedNode(i)) {
                this.nodes[i].setFillColor(this.isHighlightedNode(i) ? c : this.getBGColor());
            }
            ++i;
        }
        i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                if (this.isActivatedEdge(i, j)) {
                    if (i != j) {
                        this.edges[i][j].setColor(this.isHighlightedEdge(i, j) ? c : this.getOutlineColor());
                    } else {
                        this.edgeLoop[i].setColor(this.isHighlightedEdge(i, j) ? c : this.getOutlineColor());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setElemHighlightColor(Color c) {
        this.elemHighlightColor = c;
        int i = 0;
        while (i < this.length) {
            if (this.isActivatedNode(i)) {
                this.nodeText[i].setColor(this.isElemHighlightedNode(i) ? c : this.getNodeFontColor());
            }
            ++i;
        }
        i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                if (this.isActivatedEdge(i, j)) {
                    this.edgeText[i][j].setColor(this.isElemHighlightedEdge(i, j) ? c : this.getEdgeFontColor());
                }
                ++j;
            }
            ++i;
        }
    }

    public Color getElemHighlightColor() {
        return this.elemHighlightColor;
    }

    public void setOutlineColor(Color c) {
        this.outlineColor = c;
        int i = 0;
        while (i < this.length) {
            this.nodes[i].setColor(c);
            ++i;
        }
        i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                if (i != j) {
                    this.edges[i][j].setColor(c);
                } else {
                    this.edgeLoop[i].setColor(c);
                }
                ++j;
            }
            ++i;
        }
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public int getXNode(int index) {
        return this.nodeText[index].getLocation().x;
    }

    public int getYNode(int index) {
        return this.nodeText[index].getLocation().y;
    }

    public void setLocation(Point p) {
        this.setOrigin(p);
    }

    public void setOrigin(Point p) {
        this.setOrigin(p.x, p.y);
    }

    public void setOrigin(int xpos, int ypos) {
        this.translate(xpos - this.origin.x, ypos - this.origin.y);
    }

    public Point getOrigin() {
        return this.origin;
    }

    public Rectangle getBoundingBox() {
        Rectangle r = this.nodes[0].getBoundingBox();
        Rectangle r1 = new Rectangle();
        int i = 0;
        while (i < this.length) {
            r1 = this.nodes[i].getBoundingBox();
            r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
            r1 = this.nodeText[i].getBoundingBox();
            r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
            if (!this.edgeText[i][i].getText().equalsIgnoreCase(UNDEFINED_EDGE)) {
                r1 = this.edgeLoop[i].getBoundingBox();
                r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
                r1 = this.edgeText[i][i].getBoundingBox();
                r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
            }
            ++i;
        }
        int j = 0;
        while (j < this.length) {
            int k = 0;
            while (k < this.length) {
                if (j != k && !this.edgeText[j][k].getText().equalsIgnoreCase(UNDEFINED_EDGE)) {
                    r1 = this.edges[j][k].getBoundingBox();
                    r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
                    r1 = this.edgeText[j][k].getBoundingBox();
                    r = SwingUtilities.computeUnion(r1.x, r1.y, r1.width, r1.height, r);
                }
                ++k;
            }
            ++j;
        }
        return r;
    }

    public Rectangle getBoundingBox(int i) {
        Rectangle[] temp = this.getBoundingBoxes();
        return temp[i];
    }

    public Rectangle[] getBoundingBoxes() {
        int k;
        Rectangle[] temp = new Rectangle[this.length * (2 * this.length + 3)];
        int i = 0;
        while (i < this.length) {
            temp[i] = this.nodes[i].getBoundingBox();
            ++i;
        }
        i = 0;
        while (i < this.length) {
            temp[i + this.length] = this.nodeText[i].getBoundingBox();
            ++i;
        }
        i = 0;
        while (i < this.length) {
            temp[i + 2 * this.length] = this.edgeLoop[i].getBoundingBox();
            ++i;
        }
        int j = 0;
        while (j < this.length) {
            k = 0;
            while (k < this.length) {
                temp[(j + 3) * this.length + k] = this.edges[j][k].getBoundingBox();
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < this.length) {
            k = 0;
            while (k < this.length) {
                temp[(j + 3 + this.length) * this.length + k] = this.edgeText[j][k].getBoundingBox();
                ++k;
            }
            ++j;
        }
        return temp;
    }

    public void setPositionNode(int i, int x, int y) {
        this.nodeText[i].setLocation(new Point(x, y));
        Rectangle temp = this.nodeText[i].getBoundingBox();
        this.nodes[i].setCenter(new Point(temp.x + temp.width / 2, temp.y + temp.height / 2));
        this.setNodeEdges(i);
    }

    public void setPositionNode(int i, Point p) {
        this.setPositionNode(i, p.x, p.y);
    }

    public void resizeNode(int i) {
        Rectangle r = this.nodeText[i].getBoundingBox();
        int rad = (r.width + 20) / 2;
        this.nodes[i].setCenter(new Point(r.x + r.width / 2, r.y + r.height / 2));
        this.nodes[i].setRadius(rad);
        this.setNodeEdges(i);
    }

    public void setEdge(int i, int j) {
        if (i != j) {
            double x0 = this.nodes[i].getCenter().x;
            double y0 = this.nodes[i].getCenter().y;
            double x1 = this.nodes[j].getCenter().x;
            double y1 = this.nodes[j].getCenter().y;
            double r0 = this.nodes[i].getRadius();
            double r1 = this.nodes[j].getRadius();
            if (x0 != x1 || y0 != y1) {
                int Y1;
                int X1;
                int Y0;
                int X0;
                double l = Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
                if (!this.directed) {
                    X0 = (int)Math.round(x0 + r0 * ((x1 - x0) / l));
                    Y0 = (int)Math.round(y0 + r0 * ((y1 - y0) / l));
                    X1 = (int)Math.round(x1 + r1 * ((x0 - x1) / l));
                    Y1 = (int)Math.round(y1 + r1 * ((y0 - y1) / l));
                    this.edges[i][j].setNode(0, new PTPoint(X0, Y0));
                    this.edges[i][j].setNode(1, new PTPoint(X1, Y1));
                    this.edges[i][j].setFWArrow(false);
                } else {
                    double beta = 10.0;
                    double alpha = 0.0;
                    if (y1 > y0) {
                        alpha = Math.toDegrees(Math.acos((x1 - x0) / l));
                    } else if (y1 < y0) {
                        alpha = -Math.toDegrees(Math.acos((x1 - x0) / l));
                    } else if (x1 < x0) {
                        alpha = 180.0;
                    }
                    if (this.edgeText[j][i].getText().equalsIgnoreCase(UNDEFINED_EDGE)) {
                        X0 = (int)Math.round(x0 + r0 * ((x1 - x0) / l));
                        Y0 = (int)Math.round(y0 + r0 * ((y1 - y0) / l));
                        X1 = (int)Math.round(x1 + r1 * ((x0 - x1) / l));
                        Y1 = (int)Math.round(y1 + r1 * ((y0 - y1) / l));
                    } else {
                        X0 = (int)Math.round(x0 + r0 * Math.cos(Math.toRadians(alpha + beta)));
                        Y0 = (int)Math.round(y0 + r0 * Math.sin(Math.toRadians(alpha + beta)));
                        X1 = (int)Math.round(x1 + r1 * Math.cos(Math.toRadians(alpha + 180.0 - beta)));
                        Y1 = (int)Math.round(y1 + r1 * Math.sin(Math.toRadians(alpha + 180.0 - beta)));
                    }
                    this.edges[i][j].setNode(0, new PTPoint(X0, Y0));
                    this.edges[i][j].setNode(1, new PTPoint(X1, Y1));
                    this.edges[i][j].setFWArrow(true);
                }
                if (x1 > x0) {
                    if (y1 > y0) {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2 - this.edgeFm.stringWidth(this.edgeText[i][j].getText()), Y0 + (Y1 - Y0) / 2 + this.edgeFm.getHeight()));
                    } else if (y1 < y0) {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2, Y0 + (Y1 - Y0) / 2 + this.edgeFm.getHeight()));
                    } else {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2, Y0 + (Y1 - Y0) / 2 + this.edgeFm.getHeight()));
                    }
                } else if (x1 < x0) {
                    if (y1 > y0) {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2 - this.edgeFm.stringWidth(this.edgeText[i][j].getText()), Y0 + (Y1 - Y0) / 2 - this.edgeFm.getDescent()));
                    } else if (y1 < y0) {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2, Y0 + (Y1 - Y0) / 2 - this.edgeFm.getDescent()));
                    } else {
                        this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2, Y0 + (Y1 - Y0) / 2 - this.edgeFm.getDescent()));
                    }
                } else if (y1 > y0) {
                    this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2 - this.edgeFm.stringWidth(this.edgeText[i][j].getText()) - 5, Y0 + (Y1 - Y0) / 2));
                } else if (y1 < y0) {
                    this.edgeText[i][j].setLocation(new Point(X0 + (X1 - X0) / 2 + 5, Y0 + (Y1 - Y0) / 2));
                }
            }
        } else {
            int x0 = this.nodes[i].getCenter().x;
            int y0 = this.nodes[i].getCenter().y;
            int r0 = this.nodes[i].getRadius();
            int r = 15;
            int alpha = (int)Math.round(Math.toDegrees(Math.acos((double)r0 / Math.sqrt(Math.pow(r0, 2.0) + Math.pow(r, 2.0)))));
            int y = (int)Math.round((double)y0 - Math.sqrt(Math.pow(r0, 2.0) + Math.pow(r, 2.0)));
            this.edgeLoop[i].setCenter(new Point(x0, y));
            this.edgeLoop[i].setArcAngle(180 + 2 * alpha);
            this.edgeLoop[i].setRadius(r);
            this.edgeLoop[i].setStartAngle(-alpha);
            this.edgeText[i][i].setLocation(new Point(x0 - this.edgeFm.stringWidth(this.edgeText[i][i].getText()) / 2, y - r - this.edgeFm.getDescent()));
            if (!this.directed) {
                this.edgeLoop[i].setFWArrow(false);
            } else {
                this.edgeLoop[i].setFWArrow(true);
            }
        }
    }

    public void setNodeEdges(int index) {
        int i = 0;
        while (i < this.length) {
            this.setEdge(index, i);
            this.setEdge(i, index);
            ++i;
        }
    }

    public void setEdges() {
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                this.setEdge(i, j);
                ++j;
            }
            ++i;
        }
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public void translate(int dx, int dy) {
        int i = 0;
        while (i < this.length) {
            this.nodeText[i].translate(dx, dy);
            this.nodes[i].translate(dx, dy);
            this.edgeLoop[i].translate(dx, dy);
            ++i;
        }
        int j = 0;
        while (j < this.length) {
            int k = 0;
            while (k < this.length) {
                this.edgeText[j][k].translate(dx, dy);
                this.edges[j][k].translate(dx, dy);
                ++k;
            }
            ++j;
        }
    }

    public void translateNode(int index, int dx, int dy) {
        this.nodeText[index].translate(dx, dy);
        this.nodes[index].translate(dx, dy);
        this.setNodeEdges(index);
    }

    public void translateNodes(boolean[] moveTheseOnly, int deltaX, int deltaY) {
        int maxIndex = this.getLength();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (moveTheseOnly[nodeNr]) {
                this.translateNode(nodeNr, deltaX, deltaY);
            }
            ++nodeNr;
        }
    }

    public Object clone() {
        PTGraph graph = new PTGraph();
        graph.setDepth(this.getDepth());
        graph.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        graph.backgroundColor = this.createColor(this.backgroundColor);
        graph.elemHighlightColor = this.createColor(this.elemHighlightColor);
        graph.highlightColor = this.createColor(this.highlightColor);
        graph.outlineColor = this.createColor(this.outlineColor);
        graph.showIndices = this.showIndices;
        graph.clonePropertiesFrom(this.getProperties(), true);
        graph.nodeFont = new Font(this.nodeFont.getName(), this.nodeFont.getStyle(), this.nodeFont.getSize());
        graph.edgeFont = new Font(this.edgeFont.getName(), this.edgeFont.getStyle(), this.edgeFont.getSize());
        graph.nodeFm = Animal.getConcreteFontMetrics(this.nodeFm.getFont());
        graph.edgeFm = Animal.getConcreteFontMetrics(this.edgeFm.getFont());
        graph.nodeText = new PTText[this.length];
        graph.nodes = new PTArc[this.length];
        graph.edgeText = new PTText[this.length][this.length];
        graph.edges = new PTPolyline[this.length][this.length];
        graph.edgeLoop = new PTArc[this.length];
        graph.nodeStates = new byte[this.length];
        graph.edgeStates = new byte[this.length][this.length];
        graph.edgeWeightStates = new byte[this.length][this.length];
        graph.origin = (Point)this.origin.clone();
        int i = 0;
        while (i < this.length) {
            graph.nodes[i] = (PTArc)this.nodes[i].clone();
            graph.nodeText[i] = (PTText)this.nodeText[i].clone();
            graph.edgeLoop[i] = (PTArc)this.edgeLoop[i].clone();
            graph.nodeStates[i] = this.nodeStates[i];
            ++i;
        }
        i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.length) {
                graph.edges[i][j] = (PTPolyline)this.edges[i][j].clone();
                graph.edgeText[i][j] = (PTText)this.edgeText[i][j].clone();
                graph.edgeStates[i][j] = this.edgeStates[i][j];
                graph.edgeWeightStates[i][j] = this.edgeWeightStates[i][j];
                ++j;
            }
            ++i;
        }
        graph.directed = this.directed;
        graph.weighted = this.weighted;
        graph.length = this.length;
        graph.showIndices = this.showIndices;
        return graph;
    }

    public String toString() {
        String toString = new String();
        toString = this.getType();
        if (this.getObjectName() != null) {
            toString.concat(" '" + this.getObjectName() + "'");
        }
        toString.concat(" with " + this.length + " nodes");
        return toString;
    }

    public void setWeight(boolean state) {
        this.weighted = state;
    }

    public boolean hasWeight() {
        return this.weighted;
    }

    public void setDirection(boolean state) {
        this.directed = state;
        this.setEdges();
    }

    public boolean hasDirection() {
        return this.directed;
    }

    public void setIndices(boolean state) {
        this.showIndices = state;
    }

    public boolean indicesShown() {
        return this.showIndices;
    }

    public boolean operationRequiresSpecialSelector(String methodName) {
        return methodName != null && methodName.indexOf("Nodes") != -1;
    }

    public boolean enableMultiSelectionFor(String methodName) {
        return methodName != null && methodName.indexOf("Nodes") != -1;
    }

    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Nodes") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Nodes") != -1;
    }

    public int getFileVersion() {
        return 1;
    }

    protected void init() {
        this.nodeText = new PTText[this.length];
        this.nodes = new PTArc[this.length];
        this.edgeText = new PTText[this.length][this.length];
        this.edges = new PTPolyline[this.length][this.length];
        this.edgeLoop = new PTArc[this.length];
        this.nodeStates = new byte[this.length];
        this.edgeStates = new byte[this.length][this.length];
        this.edgeWeightStates = new byte[this.length][this.length];
        this.directed = true;
        this.weighted = true;
        this.showIndices = false;
        int index = 0;
        while (index < this.length) {
            this.nodeText[index] = new PTText(Character.toString(Character.forDigit(10 + index % 26, 36)), this.nodeFont);
            this.nodeText[index].setLocation(new Point(this.origin.x + 50 * (index + 1), this.origin.y + 50));
            this.nodeText[index].setColor(this.getNodeFontColor());
            this.nodeText[index].setDepth(this.getDepth() - 2);
            PTArc node = new PTArc();
            node.setFWArrow(false);
            node.setBWArrow(false);
            node.setArcAngle(720);
            Rectangle temp = this.nodeText[index].getBoundingBox();
            node.setCenter(new Point(temp.x + temp.width / 2, temp.y + temp.height / 2));
            node.setCircle(true);
            node.setClockwise(true);
            node.setRadius(this.getWidth(index) / 2);
            node.setDepth(this.getDepth());
            node.setClosed(true);
            node.setFilled(true);
            node.setColor(this.getOutlineColor());
            node.setFillColor(this.getBGColor());
            node.setStartAngle(0);
            this.nodes[index] = node;
            this.nodeStates[index] = 1;
            this.nodeStates[index] = (byte)(this.nodeStates[index] | 8);
            PTArc edge = new PTArc();
            edge.setFWArrow(true);
            edge.setBWArrow(false);
            edge.setArcAngle(300);
            edge.setCenter(new Point(this.origin.x, this.origin.y));
            edge.setCircle(true);
            edge.setClockwise(false);
            edge.setRadius(0);
            edge.setDepth(this.getDepth());
            edge.setClosed(false);
            edge.setFilled(false);
            edge.setColor(this.getOutlineColor());
            edge.setFillColor(this.getBGColor());
            edge.setStartAngle(0);
            this.edgeLoop[index] = edge;
            ++index;
        }
        int index1 = 0;
        while (index1 < this.length) {
            int index2 = 0;
            while (index2 < this.length) {
                this.edgeText[index1][index2] = new PTText(UNDEFINED_EDGE, this.edgeFont);
                this.edgeText[index1][index2].setLocation(new Point(this.origin.x, this.origin.y));
                this.edgeText[index1][index2].setColor(this.getEdgeFontColor());
                this.edgeText[index1][index2].setDepth(this.getDepth() - 2);
                PTPolyline edge = new PTPolyline();
                edge.setFWArrow(true);
                edge.setBWArrow(false);
                edge.setDepth(this.getDepth());
                edge.setColor(this.getOutlineColor());
                this.edges[index1][index2] = edge;
                this.edgeStates[index1][index2] = 1;
                this.edgeStates[index1][index2] = (byte)(this.edgeStates[index1][index2] | 8);
                this.edgeWeightStates[index1][index2] = 9;
                ++index2;
            }
            ++index1;
        }
        this.setDepth(this.getDepth() < 2 ? 2 : this.getDepth());
        this.setEdges();
    }

    protected int getWidth(int i) {
        if (this.nodeText[i] != null) {
            return this.nodeText[i].getBoundingBox().width + 20;
        }
        return 20;
    }

    public void paint(Graphics g) {
        int j;
        int i;
        int index = 0;
        while (index < this.length) {
            if (this.isVisibleNode(index)) {
                this.nodes[index].paint(g);
                this.nodeText[index].paint(g);
            }
            ++index;
        }
        if (!this.directed) {
            i = 0;
            while (i < this.length) {
                j = i;
                while (j < this.length) {
                    if (this.isVisibleEdge(i, j) && !this.edgeText[i][j].getText().equalsIgnoreCase(UNDEFINED_EDGE)) {
                        if (i != j) {
                            this.edges[i][j].paint(g);
                            if (this.weighted && (this.edgeWeightStates[i][j] & 8) == 8) {
                                this.edgeText[i][j].paint(g);
                            }
                        } else {
                            this.edgeLoop[i].paint(g);
                            if (this.weighted && (this.edgeWeightStates[i][j] & 8) == 8) {
                                this.edgeText[i][i].paint(g);
                            }
                        }
                    } else if (!this.edgeText[j][i].getText().equalsIgnoreCase(UNDEFINED_EDGE) && i != j && this.isVisibleEdge(j, i)) {
                        this.edges[j][i].paint(g);
                        if (this.weighted && (this.edgeWeightStates[i][j] & 8) == 8) {
                            this.edgeText[j][i].paint(g);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.length) {
                j = 0;
                while (j < this.length) {
                    if (this.isVisibleEdge(i, j) && !this.edgeText[i][j].getText().equalsIgnoreCase(UNDEFINED_EDGE)) {
                        if (i != j) {
                            this.edges[i][j].paint(g);
                            if (this.weighted && (this.edgeWeightStates[i][j] & 8) == 8) {
                                this.edgeText[i][j].paint(g);
                            }
                        } else {
                            this.edgeLoop[i].paint(g);
                            if (this.weighted && (this.edgeWeightStates[i][j] & 8) == 8) {
                                this.edgeText[i][i].paint(g);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        float[] hsb = Color.RGBtoHSB(this.getBGColor().getRed(), this.getBGColor().getGreen(), this.getBGColor().getBlue(), null);
        int index2 = 0;
        while (index2 < this.length) {
            if (this.showIndices && this.isVisibleNode(index2)) {
                PTText idx = new PTText(String.valueOf(index2), this.nodeFont);
                idx.setLocation(new Point(this.nodeText[index2].getLocation().x + this.nodeFm.stringWidth(this.nodeText[index2].getText()), this.nodeText[index2].getLocation().y + this.nodeFm.getDescent()));
                idx.setDepth(this.getDepth() - 1);
                if ((double)hsb[2] > 0.5) {
                    if ((double)hsb[1] > 0.5) {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).darker());
                    } else {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).darker());
                    }
                } else if ((double)hsb[1] > 0.5) {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).brighter());
                } else {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).brighter());
                }
                idx.paint(g);
            }
            ++index2;
        }
    }

    public void hideEdge(int startNode, int endNode) {
        this.setVisibleEdge(startNode, endNode, false);
    }

    public void showEdge(int startNode, int endNode) {
        this.setVisibleEdge(startNode, endNode, true);
    }

    public void hideNode(int index) {
        this.setVisibleNode(index, false);
        int i = 0;
        while (i < this.length) {
            this.setVisibleEdge(i, index, false);
            this.setVisibleEdge(index, i, false);
            ++i;
        }
    }

    public void showNode(int index) {
        this.setVisibleNode(index, true);
        int i = 0;
        while (i < this.length) {
            if (this.isVisibleNode(i)) {
                this.setVisibleEdge(i, index, true);
                this.setVisibleEdge(index, i, true);
            }
            ++i;
        }
    }

    protected void setEdgeVisibility(int startNode, int endNode, int newStatus) {
        this.edgeStates[startNode][endNode] = (byte)newStatus;
    }

    public Font getFont() {
        return this.getNodeFont();
    }

    public void setFont(Font targetFont) {
        this.setNodeFont(targetFont);
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".bgColor", this.backgroundColor);
        defaultProperties.put(String.valueOf(this.getType()) + ".directed", this.directed);
        Font f = this.getEdgeFont();
        defaultProperties.put(String.valueOf(this.getType()) + ".edgeFont", f);
        defaultProperties.put(String.valueOf(this.getType()) + ".edgeFontName", f.getFamily());
        defaultProperties.put(String.valueOf(this.getType()) + ".edgeFontSize", f.getSize());
        defaultProperties.put(String.valueOf(this.getType()) + ".edgeFontStyle", f.getStyle());
        defaultProperties.put(String.valueOf(this.getType()) + ".elemHighlightColor", this.getElemHighlightColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".graphSize", this.length);
        defaultProperties.put(String.valueOf(this.getType()) + ".highlightColor", this.highlightColor);
        f = this.getNodeFont();
        defaultProperties.put(String.valueOf(this.getType()) + ".nodeFont", f);
        defaultProperties.put(String.valueOf(this.getType()) + ".nodeFontName", f.getFamily());
        defaultProperties.put(String.valueOf(this.getType()) + ".nodeFontSize", f.getSize());
        defaultProperties.put(String.valueOf(this.getType()) + ".nodeFontStyle", f.getStyle());
        defaultProperties.put(String.valueOf(this.getType()) + ".outlineColor", this.outlineColor);
        defaultProperties.put(String.valueOf(this.getType()) + ".showIndices", this.showIndices);
        defaultProperties.put(String.valueOf(this.getType()) + ".weighted", this.weighted);
    }
}

