/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTClosedCircleSegment
extends ClosedArcBasedShape
implements MoveBase,
Cloneable {
    public static final String TYPE_LABEL = "ClosedCircleSegment";
    private static final long serialVersionUID = 4711724437159551057L;
    private boolean isClockwise = false;
    private int radius;
    private int startAngle = 0;
    private int totalAngle = 45;

    public PTClosedCircleSegment() {
        this.initializeWithDefaults(this.getType());
    }

    public void paint(Graphics g) {
        if (this.center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, this.startAngle, this.totalAngle);
        }
        g.setColor(this.color);
        g.drawArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, this.startAngle, this.totalAngle);
        if (this.totalAngle % 360 != 0) {
            Point a = this.getPointAtLength(this.startAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
            a = this.getPointAtLength(this.startAngle + this.totalAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
    }

    public int getAngle(Point p) {
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        if (this.radius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / this.radius, this.center.y + ydist * 100 / this.radius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2);
    }

    public int getFileVersion() {
        return 1;
    }

    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.radius * Math.cos(x)), (int)((double)this.center.y - (double)this.radius * Math.sin(x)));
    }

    public int getRadius() {
        return this.radius;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getTotalAngle() {
        return this.totalAngle;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isClockwise = config.getDefaultBooleanValue(this.getType(), "clockwise", false);
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public void setClockwise(boolean isOrientationClockwise) {
        if (this.isClockwise != isOrientationClockwise) {
            if (isOrientationClockwise) {
                this.setTotalAngle((this.getTotalAngle() - 360) % 360);
            } else {
                this.setTotalAngle((360 + this.getTotalAngle()) % 360);
            }
        }
        this.isClockwise = isOrientationClockwise;
    }

    public void setRadius(int r) {
        this.radius = Math.abs(r);
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public void setTotalAngle(int angle) {
        this.totalAngle = angle;
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getTotalAngle());
    }

    public Object clone() {
        PTClosedCircleSegment targetShape = new PTClosedCircleSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTClosedCircleSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
        targetShape.setClockwise(this.isClockwise);
        targetShape.setRadius(this.getRadius());
        targetShape.setStartAngle(this.getStartAngle());
        targetShape.setTotalAngle(this.totalAngle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTClosedCircleSegment ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius=");
        sb.append(this.getRadius()).append(", starts at ").append(this.getStartAngle());
        sb.append(", angle=").append(this.getTotalAngle());
        if (this.isClockwise) {
            sb.append(" clockwise");
        }
        return sb.toString();
    }
}

