/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTText;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTTextImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        PTText shape = new PTText();
        try {
            if (version > shape.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(shape.getFileVersion()), stok.toString()});
            }
            ParseSupport.parseMandatoryWord(stok, "Text Coord 'at'", "at");
            shape.setPosition(ParseSupport.parseNode(stok, "Text coordinates"));
            shape.setColor(ParseSupport.parseColor(stok, "Text Color"));
            ParseSupport.parseMandatoryWord(stok, "fontname 'font'", "font");
            shape.setFont(ParseSupport.parseFontInformation(stok, "font"));
            ParseSupport.parseMandatoryWord(stok, "text 'text'", "text");
            ParseSupport.parseMandatoryChar(stok, "text ':'", ':');
            shape.setText(AnimalParseSupport.parseText(stok, "Text text"));
            if (version >= 2) {
                ParseSupport.parseMandatoryWord(stok, "Text keyword 'depth'", "depth");
                shape.setDepth(ParseSupport.parseInt(stok, "Text depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return shape;
    }
}

