/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationExporter;
import animal.misc.MessageDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import translator.AnimalTranslator;

public class ExportModeChooser
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 4895506508149252074L;
    private JToggleButton fullAnimation;
    private JToggleButton selectedSteps;
    private JToggleButton staticSnapshot;
    private JToggleButton dynamicStep;
    private JComboBox sizeBox;
    private JComboBox speedBox;
    private JList stepList;
    private double magScale = 1.0;
    private double speed = 1.0;
    public static final String[] MAG_SIZES = new String[]{"50%", "71%", "100%", "141%", "200%"};
    public static final String[] SPEED_SETTINGS = new String[]{"10%", "25%", "50%", "75%", "100%", "150%", "200%", "250%", "500%"};

    public ExportModeChooser(AnimationExporter chosenExporter) {
        super(AnimalTranslator.translateMessage("chooseExMode"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 2));
        ButtonGroup exportModeGroup = new ButtonGroup();
        boolean canHandleFull = chosenExporter.canExportFullAnimation();
        this.fullAnimation = AnimalTranslator.getGUIBuilder().generateJToggleButton("fullAnimEx", null, this, true);
        this.fullAnimation.setEnabled(canHandleFull);
        this.fullAnimation.setSelected(canHandleFull);
        this.selectedSteps = AnimalTranslator.getGUIBuilder().generateJToggleButton("selectedEx", null, this, true);
        this.selectedSteps.setSelected(!canHandleFull);
        this.selectedSteps.setEnabled(chosenExporter.canExportSelectedSteps());
        panel.add(this.fullAnimation);
        panel.add(this.selectedSteps);
        exportModeGroup.add(this.fullAnimation);
        exportModeGroup.add(this.selectedSteps);
        ButtonGroup exportTypeGroup = new ButtonGroup();
        boolean canHandleDynamicSteps = chosenExporter.canExportDynamicStep();
        this.dynamicStep = AnimalTranslator.getGUIBuilder().generateJToggleButton("dynamicEx", null, null, true);
        this.dynamicStep.setEnabled(canHandleDynamicSteps);
        this.dynamicStep.setSelected(canHandleDynamicSteps);
        this.staticSnapshot = AnimalTranslator.getGUIBuilder().generateJToggleButton("staticEx", null, null, true);
        this.staticSnapshot.setSelected(!canHandleDynamicSteps);
        panel.add(this.dynamicStep);
        panel.add(this.staticSnapshot);
        exportTypeGroup.add(this.dynamicStep);
        exportTypeGroup.add(this.staticSnapshot);
        panel.add(AnimalTranslator.getGUIBuilder().generateJLabel("exportMag"));
        boolean canHandleMagnification = chosenExporter.canScaleDisplay();
        JToggleButton defaultSize = AnimalTranslator.getGUIBuilder().generateJToggleButton("normalScale", null, null, true);
        defaultSize.setSelected(true);
        panel.add(defaultSize);
        if (canHandleMagnification) {
            JToggleButton canvasScaleButton = AnimalTranslator.getGUIBuilder().generateJToggleButton("canvasScale", null, null, true);
            panel.add(canvasScaleButton);
            this.sizeBox = AnimalTranslator.getGUIBuilder().generateJComboBox("exScale", null, MAG_SIZES, MAG_SIZES[MAG_SIZES.length >> 1]);
            this.sizeBox.setEditable(true);
            this.sizeBox.addActionListener(this);
            panel.add(this.sizeBox);
            ButtonGroup magnificationGroup = new ButtonGroup();
            magnificationGroup.add(defaultSize);
            magnificationGroup.add(canvasScaleButton);
        }
        panel.add(AnimalTranslator.getGUIBuilder().generateJLabel("exportSpeed"));
        boolean canHandleSpeedSetting = chosenExporter.canAdjustSpeed();
        JToggleButton defaultSpeed = AnimalTranslator.getGUIBuilder().generateJToggleButton("normalSpeed", null, null, true);
        defaultSpeed.setSelected(true);
        panel.add(defaultSpeed);
        if (canHandleSpeedSetting) {
            JToggleButton animSpeedButton = AnimalTranslator.getGUIBuilder().generateJToggleButton("animSpeed", null, null, true);
            panel.add(animSpeedButton);
            this.speedBox = AnimalTranslator.getGUIBuilder().generateJComboBox("exSpeed", null, SPEED_SETTINGS, SPEED_SETTINGS[SPEED_SETTINGS.length >> 1]);
            this.speedBox.setEditable(true);
            this.speedBox.addActionListener(this);
            panel.add(this.speedBox);
            ButtonGroup speedGroup = new ButtonGroup();
            speedGroup.add(defaultSpeed);
            speedGroup.add(animSpeedButton);
        }
        this.getContentPane().add((Component)panel, "North");
        String[] steps = chosenExporter.getAnimation().getLinkLabels();
        this.stepList = new JList<String>(steps);
        this.stepList.setEnabled(!this.fullAnimation.isSelected());
        this.getContentPane().add((Component)new JScrollPane(this.stepList), "Center");
        JPanel buttonPanel = new JPanel();
        AbstractButton okButton = AnimalTranslator.getGUIBuilder().generateJButton("ok", null, false, chosenExporter);
        buttonPanel.add(okButton);
        AbstractButton cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("cancel", null, false, chosenExporter);
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setVisible(true);
        this.pack();
    }

    public boolean exportFullAnimation() {
        return this.fullAnimation.isSelected();
    }

    public boolean dynamicStepExport() {
        return this.dynamicStep.isSelected();
    }

    public int[] getExportSteps() {
        int[] result = null;
        Object[] selected = this.stepList.getSelectedValues();
        if (selected != null && selected.length != 0) {
            int nr = selected.length;
            result = new int[nr];
            int i = 0;
            while (i < selected.length) {
                try {
                    result[i] = Integer.parseInt(((String)selected[i]).substring(5));
                }
                catch (NumberFormatException e) {
                    MessageDisplay.message("invalidNumberInput", new String[]{(String)selected[i]});
                }
                ++i;
            }
        }
        return result;
    }

    public double getDisplaySpeed() {
        return this.speed;
    }

    public double getMagnification() {
        return this.magScale;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JToggleButton) {
            this.stepList.setEnabled(!this.fullAnimation.isSelected());
        } else if (event.getSource() == this.sizeBox) {
            String itemBoxValue = (String)this.sizeBox.getSelectedItem();
            String useThis = itemBoxValue.trim();
            boolean usesPercentage = useThis.endsWith("%");
            if (usesPercentage) {
                useThis = useThis.substring(0, useThis.length() - 1);
            }
            try {
                this.magScale = Double.parseDouble(useThis);
            }
            catch (NumberFormatException nfe) {
                this.magScale = 1.0;
                this.sizeBox.setSelectedItem("100%");
            }
            if (usesPercentage) {
                this.magScale /= 100.0;
            }
        } else if (event.getSource() == this.speedBox) {
            String itemBoxValue = (String)this.speedBox.getSelectedItem();
            String useThis = itemBoxValue.trim();
            boolean usesPercentage = useThis.endsWith("%");
            if (usesPercentage) {
                useThis = useThis.substring(0, useThis.length() - 1);
            }
            try {
                this.speed = Double.parseDouble(useThis);
            }
            catch (NumberFormatException nfe) {
                this.speed = 1.0;
                this.speedBox.setSelectedItem("100%");
            }
            if (usesPercentage) {
                this.speed /= 100.0;
            }
        }
    }
}

