/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.animator.Animator;
import animal.animator.Move;
import animal.animator.Rotate;
import animal.animator.Show;
import animal.animator.TimedShow;
import animal.exchange.ExportModeChooser;
import animal.exchange.FormatSpecification;
import animal.exchange.MagnificationAdjustableExporter;
import animal.exchange.SpeedAdjustableExporter;
import animal.graphics.PTGraphicObject;
import animal.gui.GraphicVector;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.AnimationListEntry;
import animal.main.AnimationState;
import animal.misc.AnimalFileChooser;
import animal.misc.MessageDisplay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.GregorianCalendar;
import translator.AnimalTranslator;

public abstract class AnimationExporter
implements FormatSpecification,
ActionListener {
    public static final int EXPORT_STATIC_SNAPSHOT = 1;
    public static final int EXPORT_DYNAMIC_STEP = 2;
    public static final int EXPORT_FULL_ANIMATION = 4;
    public static final int EXPORT_INDIVIDUAL_STEPS = 8;
    public static final int EXPORT_SCALE_DISPLAY = 16;
    public static final int EXPORT_ADJUST_SPEED = 32;
    public static AnimalConfiguration animalConfig;
    private AnimationExporter exporter = null;
    private ExportModeChooser exportModeChooser;
    protected Animation animationToExport = null;
    protected int exportCapabilities = 1;
    protected boolean[] exportSteps = null;
    protected int exportType = 1;
    String filename = null;
    String formatName = null;

    public static void setAnimalConfig(AnimalConfiguration newConfig) {
        animalConfig = newConfig;
    }

    public static AnimationExporter getExporterFor(String formatName) {
        return animalConfig.getExportHandlerFor(formatName);
    }

    public boolean canAdjustSpeed() {
        return (this.exportCapabilities & 0x20) == 32;
    }

    public boolean canExportStaticSnapshot() {
        return (this.exportCapabilities & 1) == 1;
    }

    public boolean canExportDynamicStep() {
        return (this.exportCapabilities & 2) == 2;
    }

    public boolean canExportFullAnimation() {
        return (this.exportCapabilities & 4) == 4;
    }

    public boolean canExportSelectedSteps() {
        return (this.exportCapabilities & 8) == 8;
    }

    public boolean canScaleDisplay() {
        return (this.exportCapabilities & 0x10) == 16;
    }

    public int getExportCapabilities() {
        return this.exportCapabilities;
    }

    public static String[] getExtensions() {
        return animalConfig.getExportExtensions();
    }

    public String[] getFormatNames() {
        return AnimalConfiguration.getDefaultConfiguration().getExportFormats();
    }

    public abstract boolean exportAnimationTo(String var1);

    public Animation getAnimation() {
        return this.animationToExport;
    }

    public void init(String format) {
        this.formatName = format;
    }

    public String printExportSteps() {
        if (this.exportSteps == null) {
            return AnimalTranslator.translateMessage("noStepsSet");
        }
        StringBuilder sb = new StringBuilder(this.exportSteps.length << 2);
        sb.append(AnimalTranslator.translateMessage("stepsToExport"));
        boolean currentlyInInterval = false;
        int intervalStart = -1;
        int i = 1;
        while (i < this.exportSteps.length) {
            if (this.exportSteps[i]) {
                if (!currentlyInInterval) {
                    sb.append(i);
                    intervalStart = i;
                    currentlyInInterval = true;
                } else if (currentlyInInterval) {
                    if (intervalStart != i - 1) {
                        sb.append("-").append(i - 1);
                    }
                    sb.append(" ");
                    currentlyInInterval = false;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public int[] determineExportableGraphicObjects() {
        if (this.animationToExport == null) {
            return null;
        }
        int maxNrOfObjects = this.animationToExport.getNextGraphicObjectNum();
        int[] mustBeExported = new int[maxNrOfObjects + 1];
        int currentStep = 0;
        int i = 0;
        AnimationListEntry[] localinfo = this.animationToExport.getAnimatorList();
        AnimationState animState = new AnimationState(this.animationToExport);
        boolean[] exportThese = new boolean[maxNrOfObjects + 1];
        while (currentStep != Integer.MAX_VALUE) {
            if (this.exportSteps[currentStep]) {
                GraphicVector objectsVisibleInStep = animState.getCurrentObjects();
                int j = 0;
                while (j < objectsVisibleInStep.getSize()) {
                    PTGraphicObject ptgo = objectsVisibleInStep.elementAt(j).getGraphicObject();
                    int currentObject = ptgo.getNum(false);
                    exportThese[currentObject] = true;
                    ++j;
                }
            }
            currentStep = animState.getNextStep();
            animState.setStep(currentStep, true);
        }
        currentStep = 0;
        i = 0;
        while (i < localinfo.length) {
            AnimationListEntry ali = localinfo[i];
            if (ali.mode == 2) {
                currentStep = ali.link.getStep();
                animState.setStep(currentStep, true);
            } else if (ali.mode == 1) {
                Animator animator = ali.animator;
                if (this.exportSteps[currentStep]) {
                    int baseNum = -1;
                    if (animator instanceof Move) {
                        baseNum = ((Move)animator).getMoveBaseNum();
                    } else if (animator instanceof Rotate) {
                        baseNum = ((Rotate)animator).getCenterNum();
                    }
                    if (baseNum != -1 && mustBeExported[baseNum] == 0) {
                        mustBeExported[baseNum] = -currentStep;
                    }
                }
                if (animator instanceof Show || animator instanceof TimedShow) {
                    boolean isShow = animator instanceof Show ? ((Show)animator).isShow() : ((TimedShow)animator).isShow();
                    int[] objectNums = animator.getObjectNums();
                    int objectNr = 0;
                    while (objectNr < objectNums.length) {
                        if (isShow) {
                            mustBeExported[objectNums[objectNr]] = currentStep;
                        } else {
                            int checkStep = mustBeExported[objectNums[objectNr]];
                            mustBeExported[objectNums[objectNr]] = checkStep < currentStep ? checkStep : 0;
                        }
                        ++objectNr;
                    }
                }
            }
            ++i;
        }
        return mustBeExported;
    }

    public void setAnimation(Animation anim) {
        this.exporter = this;
        this.animationToExport = anim;
        int nrOfSteps = this.animationToExport.getMaxStepNum();
        this.exportSteps = new boolean[nrOfSteps + 1];
    }

    public void chooseExportMode() {
        this.exportModeChooser = new ExportModeChooser(this.exporter);
    }

    public void setExportMode(int targetMode) throws IllegalArgumentException {
        if ((targetMode & this.exportCapabilities) != targetMode) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("illegalExportMode"));
        }
        this.exportType = targetMode;
    }

    public void setFullExport() throws IllegalArgumentException {
        if (this.animationToExport == null || this.exportSteps == null) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("noAnimSetForExport"));
        }
        if ((this.exportCapabilities & 4) != 4) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("noFullExportSupported"));
        }
        int i = 1;
        while (i < this.exportSteps.length) {
            this.exportSteps[i] = true;
            ++i;
        }
    }

    public void setTargetInterval(int startStep, int endStep) throws IllegalArgumentException {
        if (this.animationToExport == null || this.exportSteps == null) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("noAnimSetForExport"));
        }
        if (endStep < startStep || startStep < 0 || endStep >= this.exportSteps.length) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("illegalExportInterval", new String[]{String.valueOf(startStep), String.valueOf(endStep), String.valueOf(this.exportSteps.length - 1)}));
        }
        int i = startStep;
        while (i <= endStep) {
            this.exportSteps[i] = true;
            ++i;
        }
    }

    public void setTargetSteps(int[] stepNrs) throws IllegalArgumentException {
        if (this.animationToExport == null || stepNrs == null || stepNrs.length == 0) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("noAnimOrIntervalInvalid"));
        }
        int i = 0;
        while (i < stepNrs.length) {
            if (stepNrs[i] > 0 && this.animationToExport.verifyStep(stepNrs[i]) != 0) {
                this.exportSteps[stepNrs[i]] = true;
            }
            ++i;
        }
    }

    public void setTargetStep(int stepNr) throws IllegalArgumentException {
        if (this.animationToExport == null) {
            throw new IllegalArgumentException(AnimalTranslator.translateMessage("noAnimSetForExport"));
        }
        if (stepNr > 0 && this.animationToExport.verifyStep(stepNr) != 0) {
            this.exportSteps[stepNr] = true;
        }
    }

    public String toString() {
        return AnimalTranslator.translateMessage("notOverridden", new String[]{this.getClass().getName()});
    }

    public static boolean validFormat(String formatName) {
        return animalConfig.validExportFormat(formatName.toLowerCase());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.exportModeChooser.setVisible(false);
            return;
        }
        if (this.exportModeChooser.exportFullAnimation()) {
            this.exporter.setFullExport();
        } else {
            this.exporter.setTargetSteps(this.exportModeChooser.getExportSteps());
        }
        if (this.exportModeChooser.dynamicStepExport()) {
            this.exporter.setExportMode(2);
        } else {
            this.exporter.setExportMode(1);
        }
        this.exportModeChooser.setVisible(false);
        this.exportModeChooser.dispose();
        long timeTaken = System.currentTimeMillis();
        if (this.exporter instanceof MagnificationAdjustableExporter) {
            ((MagnificationAdjustableExporter)((Object)this.exporter)).setMagnification(this.exportModeChooser.getMagnification());
        }
        if (this.exporter instanceof SpeedAdjustableExporter) {
            ((SpeedAdjustableExporter)((Object)this.exporter)).setDisplaySpeed(this.exportModeChooser.getDisplaySpeed());
        }
        this.exporter.exportAnimationTo(this.filename);
        AnimationExporter.addExportMessage(this.filename, this.exporter, timeTaken);
    }

    public static void addExportMessage(String filename, AnimationExporter exporter, long startTime) {
        long timeTaken = System.currentTimeMillis() - startTime;
        StringBuilder sb = new StringBuilder();
        GregorianCalendar calendar = new GregorianCalendar();
        sb.append('[').append(calendar.get(11));
        sb.append(':').append(calendar.get(12));
        sb.append(':').append(calendar.get(13));
        sb.append("]");
        sb.append(filename);
        if (!filename.endsWith(exporter.getDefaultExtension())) {
            filename = String.valueOf(filename) + "." + exporter.getDefaultExtension();
        }
        File f = new File(filename);
        MessageDisplay.message("exportConfirm", new String[]{sb.toString(), filename, String.valueOf(f.length()), String.valueOf(timeTaken)});
    }

    public void setFilename(String fileName) {
        if (this.exporter != null) {
            this.exporter.filename = fileName;
        } else {
            this.filename = fileName;
        }
    }

    public static void startLocalExporting(String inputFileName, String inputFormat, AnimalFileChooser fileChooser) {
        String targetFormat;
        AnimationExporter exporter;
        Animal animal = Animal.get();
        Animation targetAnimation = animal.getAnimation();
        String filename = fileChooser.openForExport(animal);
        if (filename != null && (exporter = AnimationExporter.getExporterFor(targetFormat = fileChooser.getDescription())) != null) {
            exporter.setFilename(filename);
            exporter.setAnimation(targetAnimation);
            exporter.chooseExportMode();
        }
    }

    public static boolean exportAnimation(Animation currentAnim) {
        AnimalFileChooser fc = AnimationExporter.animalConfig.saveFileChooser;
        String filename = "test";
        if (fc != null) {
            filename = fc.openForExport(Animal.get());
        }
        String targetFormat = AnimationExporter.animalConfig.saveFileChooser.getFormat();
        if (filename != null && targetFormat != null) {
            return AnimationExporter.exportAnimation(currentAnim, filename, targetFormat);
        }
        return false;
    }

    public static boolean saveAnimation(Animation targetAnimation) {
        String filename = animalConfig.getCurrentFilename();
        AnimationExporter exporter = AnimationExporter.getExporterFor("animation/animal-ascii-compressed");
        if (exporter != null) {
            if (!filename.endsWith(exporter.getDefaultExtension())) {
                if (filename.lastIndexOf(46) == filename.length() - 4) {
                    filename = filename.substring(0, filename.length() - 4);
                }
                filename = String.valueOf(filename) + '.' + exporter.getDefaultExtension();
            }
            exporter.setAnimation(targetAnimation);
            exporter.setExportMode(2);
            exporter.setFullExport();
            animalConfig.setCurrentFormat("animation/animal-ascii-compressed");
            long timeTaken = System.currentTimeMillis();
            exporter.exportAnimationTo(filename);
            AnimationExporter.addExportMessage(filename, exporter, timeTaken);
            AnimationExporter.updateFilenameAndFormat(filename, "animation/animal-ascii-compressed");
            return true;
        }
        return false;
    }

    private static void updateFilenameAndFormat(String filename, String formatName) {
        AnimationExporter exporter;
        if (AnimationExporter.validFormat(formatName) && (exporter = AnimationExporter.getExporterFor(formatName)) != null) {
            animalConfig.setCurrentFilename(filename);
            animalConfig.setCurrentFormat(formatName);
        }
    }

    public static boolean exportAnimation(Animation currentAnimation, String filename, String targetFormat) {
        AnimationExporter exporter = AnimationExporter.getExporterFor(targetFormat);
        if (exporter != null) {
            if (!filename.endsWith(exporter.getDefaultExtension())) {
                filename = String.valueOf(filename) + "." + exporter.getDefaultExtension();
            }
            exporter.setFilename(filename);
            exporter.setAnimation(currentAnimation);
            exporter.chooseExportMode();
            AnimationExporter.updateFilenameAndFormat(filename, targetFormat);
            return true;
        }
        return false;
    }
}

