/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.IndexedContentChooser;
import animal.editor.graphics.AbstractTextEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntMatrix;
import animal.graphics.PTMatrix;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public abstract class MatrixEditor
extends AbstractTextEditor
implements ActionListener,
ChangeListener,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 2295451210977833754L;
    protected ColorChooserAction colorChooser;
    protected ColorChooserAction fillColorChooser;
    protected ColorChooserAction textColorChooser;
    protected ColorChooserAction cellHighlightColorChooser;
    protected ColorChooserAction elemHighlightColorChooser;
    protected JCheckBox filledCB;
    protected JTextField rowCnt;
    protected JSpinner topMarginSpinner;
    protected JSpinner bottomMarginSpinner;
    protected JSpinner leftMarginSpinner;
    protected JSpinner rightMarginSpinner;
    protected JRadioButton leftRB;
    protected JRadioButton centerRB;
    protected JRadioButton rightRB;
    protected JRadioButton leftRowRB;
    protected JRadioButton centerRowRB;
    protected JRadioButton rightRowRB;
    protected IndexedContentChooser chooseIndex;
    public static final String MATRIX_SIZE_BL = "Matrix.rowCountBL";
    public static final String MATRIX_ROW_COUNT_LABEL = "Matrix.rowCountLabel";
    public static final String MATRIX_TEXT_OPERATIONS_LABEL = "Matrix.enterValueLabel";
    public static final String MATRIX_FONT_AND_STYLE_LABEL = "AbstractTextEditor.fontBL";
    public static final String MATRIX_MARGIN_AND_ALIGNMENT_BOX_LABEL = "Matrix.marginAlignmentBL";
    public static final String MATRIX_TOP_MARGIN_LABEL = "Matrix.topMarginLabel";
    public static final String MATRIX_BOTTOM_MARGIN_LABEL = "Matrix.bottomMarginLabel";
    public static final String MATRIX_LEFT_MARGIN_LABEL = "Matrix.leftMarginLabel";
    public static final String MATRIX_RIGHT_MARGIN_LABEL = "Matrix.rightMarginLabel";
    public static final String MATRIX_TEXT_ALIGNMENT_LABEL = "Matrix.textAlignmentLabel";
    public static final String MATRIX_LEFT_TEXT_ALIGNMENT = "leftAlignment";
    public static final String MATRIX_CENTERED_TEXT_ALIGNMENT = "centeredAlignment";
    public static final String MATRIX_RIGHT_TEXT_ALIGNMENT = "rightAlignment";
    public static final String MATRIX_ALIGNMENT_LABEL = "alignmentLabel";
    public static final String MATRIX_LEFT_ALIGNMENT = "leftAlignment";
    public static final String MATRIX_CENTERED_ALIGNMENT = "centeredAlignment";
    public static final String MATRIX_RIGHT_ALIGNMENT = "rightAlignment";
    public static final String MATRIX_METHOD_SET_TEXT = "Method.setText";
    public static final String MATRIX_METHOD_SET_HIGHLIGHTED = "Method.setHighlighted";
    public static final String MATRIX_METHOD_SET_UNHIGHLIGHTED = "Method.setUnhighlighted";
    public static final String MATRIX_METHOD_SET_ELEMENT_HIGHLIGHTED = "Method.setElemHighlighted";
    public static final String MATRIX_METHOD_SET_ELEMENT_UNHIGHLIGHTED = "Method.setElemUnhighlighted";
    public static final String MATRIX_METHOD_SET_VISIBLE = "Method.setVisible";
    public static final String MATRIX_METHOD_SET_INVISIBLE = "Method.setInvisible";
    public static final String MATRIX_METHOD_SET_OUTLINED = "Method.setOutlined";
    public static final String MATRIX_METHOD_SET_NOTOUTLINED = "Method.setNotOutlined";
    public static final String MATRIX_METHOD_SET_COLUMN_COUNT = "Matrix.methodSetColumnCount";
    public static final String MATRIX_METHOD_SET_DIAGONAL_DOWN = "Matrix.methodSetDiagonalDown";
    public static final String MATRIX_METHOD_SET_DIAGONAL_UP = "Matrix.methodSetDiagonalUp";
    public static final String MATRIX_INDEX_CHOOSER_LABEL = "IndexedContenChooser.selectObjects";

    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.createSizeBox(generator);
        this.chooseIndex = new IndexedContentChooser(MATRIX_INDEX_CHOOSER_LABEL);
        this.addBox(this.chooseIndex.getContentBox());
        this.addBox(this.generateTextOperationsBox(generator, MATRIX_TEXT_OPERATIONS_LABEL));
        this.createColorBoxes(generator);
        this.createTextMarginAndAlignmentBox(generator);
        this.addBox(this.generateFontAndStyleBox(generator, MATRIX_FONT_AND_STYLE_LABEL));
        this.italic.addItemListener(this);
        this.bold.addItemListener(this);
        this.finishBoxes();
    }

    protected void setChooseIndexContent(PTGraphicObject object) {
        PTGraphicObject[] objects = new PTGraphicObject[]{object};
        Vector<String> methods = new Vector<String>();
        methods.add("Matrix.cellIdentifier Method.setText");
        methods.add("Matrix.cellIdentifier Method.setHighlighted");
        methods.add("Matrix.cellIdentifier Method.setUnhighlighted");
        methods.add("Matrix.cellIdentifier Method.setElemHighlighted");
        methods.add("Matrix.cellIdentifier Method.setElemUnhighlighted");
        methods.add("Matrix.cellIdentifier Method.setVisible");
        methods.add("Matrix.cellIdentifier Method.setInvisible");
        methods.add("Matrix.cellIdentifier Method.setOutlined");
        methods.add("Matrix.cellIdentifier Method.setNotOutlined");
        methods.add("Matrix.cellIdentifier Matrix.methodSetDiagonalDown");
        methods.add("Matrix.cellIdentifier Matrix.methodSetDiagonalUp");
        methods.add("Matrix.rowIdentifier Matrix.methodSetColumnCount");
        this.chooseIndex.setData(objects, methods);
    }

    protected void createTextMarginAndAlignmentBox(TranslatableGUIElement generator) {
        Box marginAlignmentBox = generator.generateBorderedBox(3, MATRIX_MARGIN_AND_ALIGNMENT_BOX_LABEL);
        Box topBottomBox = new Box(2);
        topBottomBox.add(generator.generateJLabel(MATRIX_TOP_MARGIN_LABEL));
        SpinnerNumberModel spinnerModelTopMargin = new SpinnerNumberModel(3, 0, 99, 1);
        this.topMarginSpinner = new JSpinner(spinnerModelTopMargin);
        this.topMarginSpinner.addChangeListener(this);
        topBottomBox.add(this.topMarginSpinner);
        topBottomBox.add(generator.generateJLabel(MATRIX_BOTTOM_MARGIN_LABEL));
        SpinnerNumberModel spinnerModelBottomMargin = new SpinnerNumberModel(3, 0, 99, 1);
        this.bottomMarginSpinner = new JSpinner(spinnerModelBottomMargin);
        this.bottomMarginSpinner.addChangeListener(this);
        topBottomBox.add(this.bottomMarginSpinner);
        marginAlignmentBox.add(topBottomBox);
        Box leftRightBox = new Box(2);
        leftRightBox.add(generator.generateJLabel(MATRIX_LEFT_MARGIN_LABEL));
        SpinnerNumberModel spinnerModelLeftMargin = new SpinnerNumberModel(3, 0, 99, 1);
        this.leftMarginSpinner = new JSpinner(spinnerModelLeftMargin);
        this.leftMarginSpinner.addChangeListener(this);
        leftRightBox.add(this.leftMarginSpinner);
        leftRightBox.add(generator.generateJLabel(MATRIX_RIGHT_MARGIN_LABEL));
        SpinnerNumberModel spinnerModelRightMargin = new SpinnerNumberModel(3, 0, 99, 1);
        this.rightMarginSpinner = new JSpinner(spinnerModelRightMargin);
        this.rightMarginSpinner.addChangeListener(this);
        leftRightBox.add(this.rightMarginSpinner);
        marginAlignmentBox.add(leftRightBox);
        Box alignmentBox = new Box(2);
        ButtonGroup alignmentGroup = new ButtonGroup();
        this.leftRB = (JRadioButton)generator.generateJToggleButton("leftAlignment", null, this, true);
        this.leftRB.setSelected(true);
        this.leftRB.addItemListener(this);
        alignmentGroup.add(this.leftRB);
        this.centerRB = (JRadioButton)generator.generateJToggleButton("centeredAlignment", null, this, true);
        this.centerRB.addItemListener(this);
        this.centerRB.setSelected(false);
        alignmentGroup.add(this.centerRB);
        this.rightRB = (JRadioButton)generator.generateJToggleButton("rightAlignment", null, this, true);
        this.rightRB.addItemListener(this);
        this.rightRB.setSelected(false);
        alignmentGroup.add(this.rightRB);
        alignmentBox.add(generator.generateJLabel(MATRIX_TEXT_ALIGNMENT_LABEL));
        alignmentBox.add(this.leftRB);
        alignmentBox.add(this.centerRB);
        alignmentBox.add(this.rightRB);
        marginAlignmentBox.add(alignmentBox);
        Box rowAlignmentBox = new Box(2);
        ButtonGroup rowAlignmentGroup = new ButtonGroup();
        this.leftRowRB = (JRadioButton)generator.generateJToggleButton("leftAlignment", null, this, true);
        this.leftRowRB.setSelected(true);
        this.leftRowRB.addItemListener(this);
        rowAlignmentGroup.add(this.leftRowRB);
        this.centerRowRB = (JRadioButton)generator.generateJToggleButton("centeredAlignment", null, this, true);
        this.centerRowRB.addItemListener(this);
        this.centerRowRB.setSelected(false);
        rowAlignmentGroup.add(this.centerRowRB);
        this.rightRowRB = (JRadioButton)generator.generateJToggleButton("rightAlignment", null, this, true);
        this.rightRowRB.addItemListener(this);
        this.rightRowRB.setSelected(false);
        rowAlignmentGroup.add(this.rightRowRB);
        rowAlignmentBox.add(generator.generateJLabel(MATRIX_ALIGNMENT_LABEL));
        rowAlignmentBox.add(this.leftRowRB);
        rowAlignmentBox.add(this.centerRowRB);
        rowAlignmentBox.add(this.rightRowRB);
        marginAlignmentBox.add(rowAlignmentBox);
        this.addBox(marginAlignmentBox);
    }

    private void createSizeBox(TranslatableGUIElement generator) {
        Box sizeBox = generator.generateBorderedBox(3, MATRIX_SIZE_BL);
        Box firstRow = new Box(2);
        firstRow.add(generator.generateJLabel(MATRIX_ROW_COUNT_LABEL));
        this.rowCnt = new JTextField(9);
        this.rowCnt.addActionListener(this);
        this.rowCnt.setText("1");
        firstRow.add(this.rowCnt);
        sizeBox.add(firstRow);
        this.addBox(sizeBox);
    }

    private void createColorBoxes(TranslatableGUIElement generator) {
        Box colorBox = generator.generateBorderedBox(3, "GenericEditor.colorBL");
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        Box lineColorBox = new Box(2);
        JLabel colorLabel = generator.generateJLabel("GenericEditor.colorLabel");
        lineColorBox.add(colorLabel);
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntMatrix)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("GenericEditor.chooseColor")}), initialColor);
        ExtendedActionButton button = new ExtendedActionButton(this.colorChooser, 67);
        lineColorBox.add(button);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(lineColorBox, gbc);
        panel.add(lineColorBox);
        Box fillColorBox = new Box(2);
        JLabel fillColorLabel = generator.generateJLabel("GenericEditor.fillColorLabel");
        fillColorBox.add(fillColorLabel);
        initialColor = this.getCurrentObject(false) == null ? Color.white : ((PTIntMatrix)this.getCurrentObject(false)).getFillColor();
        this.fillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "fillColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("GenericEditor.fillColor")}), initialColor);
        fillColorBox.add(new ExtendedActionButton(this.fillColorChooser, 70));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbl.setConstraints(fillColorBox, gbc);
        panel.add(fillColorBox);
        Box textColorBox = new Box(2);
        textColorBox.add(generator.generateJLabel("AbstractArrayEditor.fontColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntMatrix)this.getCurrentObject(false)).getTextColor();
        this.textColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("fontColor")}), initialColor);
        textColorBox.add(new ExtendedActionButton(this.textColorChooser, 84));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbl.setConstraints(textColorBox, gbc);
        panel.add(textColorBox);
        Box cellHighlightColorBox = new Box(2);
        cellHighlightColorBox.add(generator.generateJLabel("highlightColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.yellow : ((PTIntMatrix)this.getCurrentObject(false)).getHighlightColor();
        this.cellHighlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "highlightColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("highlightColor")}), initialColor);
        cellHighlightColorBox.add(new ExtendedActionButton(this.cellHighlightColorChooser, 84));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbl.setConstraints(cellHighlightColorBox, gbc);
        panel.add(cellHighlightColorBox);
        Box elemHighlightColorBox = new Box(2);
        elemHighlightColorBox.add(generator.generateJLabel("AbstractIndexedStructureEditor.elemHighlightColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.red : ((PTIntMatrix)this.getCurrentObject(false)).getElemHighlightColor();
        this.elemHighlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "elemHighlightColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("AbstractIndexedStructureEditor.elemHighlightColor")}), initialColor);
        elemHighlightColorBox.add(new ExtendedActionButton(this.elemHighlightColorChooser, 84));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbl.setConstraints(elemHighlightColorBox, gbc);
        panel.add(elemHighlightColorBox);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbl.setConstraints(this.filledCB, gbc);
        panel.add(this.filledCB);
        colorBox.add(panel);
        this.addBox(colorBox);
    }

    public void setProperties(XProperties props) {
    }

    public void getProperties(XProperties props) {
    }

    public int pointsNeeded() {
        return 1;
    }

    public boolean nextPoint(int num, Point p) {
        if (num == 1) {
            ((PTMatrix)this.getCurrentObject()).setLocation(p);
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        Rectangle box = go.getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, ((PTMatrix)go).getLocation()), new EditPoint(-2, new Point(box.x + box.width, box.y)), new EditPoint(-3, new Point(box.x + box.width, box.y + box.height)), new EditPoint(-4, new Point(box.x + box.width / 2, box.y + box.height / 2)), new EditPoint(-5, new Point(box.x, box.y + box.height))};
    }

    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTMatrix matrix = (PTMatrix)eo;
        matrix.setColor(this.colorChooser.getColor());
        matrix.setHighlightColor(this.cellHighlightColorChooser.getColor());
        matrix.setElemHighlightColor(this.elemHighlightColorChooser.getColor());
        matrix.setTextColor(this.textColorChooser.getColor());
        matrix.setFillColor(this.fillColorChooser.getColor());
        matrix.setFilled(this.filledCB.isSelected());
        matrix.setFont(this.storeFont());
        matrix.setMargin(0, ((SpinnerNumberModel)this.topMarginSpinner.getModel()).getNumber().intValue());
        matrix.setMargin(1, ((SpinnerNumberModel)this.rightMarginSpinner.getModel()).getNumber().intValue());
        matrix.setMargin(2, ((SpinnerNumberModel)this.bottomMarginSpinner.getModel()).getNumber().intValue());
        matrix.setMargin(3, ((SpinnerNumberModel)this.leftMarginSpinner.getModel()).getNumber().intValue());
        this.handleIndexedContentPropertyChange(matrix);
        this.storeAlignment(matrix);
    }

    protected void storeAlignment(PTMatrix matrix) {
        if (this.leftRB.isSelected()) {
            matrix.setTextAlignment(PTMatrix.Alignment.LEFT);
        } else if (this.centerRB.isSelected()) {
            matrix.setTextAlignment(PTMatrix.Alignment.CENTER);
        } else if (this.rightRB.isSelected()) {
            matrix.setTextAlignment(PTMatrix.Alignment.RIGHT);
        }
        if (this.leftRowRB.isSelected()) {
            matrix.setRowAlignment(PTMatrix.Alignment.LEFT);
        } else if (this.centerRowRB.isSelected()) {
            matrix.setRowAlignment(PTMatrix.Alignment.CENTER);
        } else if (this.rightRowRB.isSelected()) {
            matrix.setRowAlignment(PTMatrix.Alignment.RIGHT);
        }
    }

    protected Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        int fontStyle = 0;
        if (this.italic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        return new Font(name, fontStyle, this.getInt(size, 12));
    }

    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTMatrix matrix = (PTMatrix)eo;
        this.colorChooser.setColor(matrix.getColor());
        this.cellHighlightColorChooser.setColor(matrix.getHighlightColor());
        this.elemHighlightColorChooser.setColor(matrix.getElemHighlightColor());
        this.textColorChooser.setColor(matrix.getTextColor());
        this.fillColorChooser.setColor(matrix.getFillColor());
        this.rowCnt.setText(String.valueOf(matrix.getRowCount()));
        ((SpinnerNumberModel)this.topMarginSpinner.getModel()).setValue(matrix.getMargin(0));
        ((SpinnerNumberModel)this.rightMarginSpinner.getModel()).setValue(matrix.getMargin(1));
        ((SpinnerNumberModel)this.bottomMarginSpinner.getModel()).setValue(matrix.getMargin(2));
        ((SpinnerNumberModel)this.leftMarginSpinner.getModel()).setValue(matrix.getMargin(3));
        this.extractAlignment(matrix);
        this.filledCB.setSelected(matrix.isFilled());
        this.extractFont(matrix.getFont());
        this.setChooseIndexContent(matrix);
    }

    private void extractAlignment(PTMatrix matrix) {
        PTMatrix.Alignment textAlignment = matrix.getTextAlignment();
        if (textAlignment == PTMatrix.Alignment.LEFT) {
            this.leftRB.setSelected(true);
        } else if (textAlignment == PTMatrix.Alignment.CENTER) {
            this.centerRB.setSelected(true);
        } else if (textAlignment == PTMatrix.Alignment.RIGHT) {
            this.rightRB.setSelected(true);
        }
        PTMatrix.Alignment rowAlignment = matrix.getRowAlignment();
        if (rowAlignment == PTMatrix.Alignment.LEFT) {
            this.leftRowRB.setSelected(true);
        } else if (rowAlignment == PTMatrix.Alignment.CENTER) {
            this.centerRowRB.setSelected(true);
        } else if (rowAlignment == PTMatrix.Alignment.RIGHT) {
            this.rightRowRB.setSelected(true);
        }
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage(String.valueOf(this.getBasicType()) + "Editor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTMatrix matrix = (PTMatrix)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (matrix != null) {
            if ("color".equals(eventName)) {
                matrix.setColor((Color)event.getNewValue());
            }
            if ("fillColor".equals(eventName)) {
                matrix.setFillColor((Color)event.getNewValue());
            }
            if ("textColor".equals(eventName)) {
                matrix.setTextColor((Color)event.getNewValue());
            }
            if ("highlightColor".equals(eventName)) {
                matrix.setHighlightColor((Color)event.getNewValue());
            }
            if ("elemHighlightColor".equals(eventName)) {
                matrix.setElemHighlightColor((Color)event.getNewValue());
            }
            if (!event.getOldValue().equals(event.getNewValue())) {
                this.repaintNow();
                if (Animation.get() != null) {
                    Animation.get().doChange();
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        PTMatrix matrix = (PTMatrix)this.getCurrentObject();
        if (matrix != null) {
            if (e.getSource() == this.filledCB) {
                matrix.setFilled(this.filledCB.isSelected());
            } else if (e.getSource() == this.leftRB) {
                matrix.setTextAlignment(PTMatrix.Alignment.LEFT);
            } else if (e.getSource() == this.centerRB) {
                matrix.setTextAlignment(PTMatrix.Alignment.CENTER);
            } else if (e.getSource() == this.rightRB) {
                matrix.setTextAlignment(PTMatrix.Alignment.RIGHT);
            } else if (e.getSource() == this.leftRowRB) {
                matrix.setRowAlignment(PTMatrix.Alignment.LEFT);
            } else if (e.getSource() == this.centerRowRB) {
                matrix.setRowAlignment(PTMatrix.Alignment.CENTER);
            } else if (e.getSource() == this.rightRowRB) {
                matrix.setRowAlignment(PTMatrix.Alignment.RIGHT);
            } else if (e.getSource() == this.bold || e.getSource() == this.italic) {
                matrix.setFont(this.storeFont());
            }
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.getCurrentObject() != null) {
            PTMatrix matrix = (PTMatrix)this.getCurrentObject();
            if (e.getSource() == this.topMarginSpinner) {
                matrix.setMargin(0, ((SpinnerNumberModel)this.topMarginSpinner.getModel()).getNumber().intValue());
            } else if (e.getSource() == this.bottomMarginSpinner) {
                matrix.setMargin(2, ((SpinnerNumberModel)this.bottomMarginSpinner.getModel()).getNumber().intValue());
            } else if (e.getSource() == this.leftMarginSpinner) {
                matrix.setMargin(3, ((SpinnerNumberModel)this.leftMarginSpinner.getModel()).getNumber().intValue());
            } else if (e.getSource() == this.rightMarginSpinner) {
                matrix.setMargin(1, ((SpinnerNumberModel)this.rightMarginSpinner.getModel()).getNumber().intValue());
            }
            Animation.get().doChange();
            this.repaintNow();
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (this.getCurrentObject() != null) {
            PTMatrix matrix = (PTMatrix)this.getCurrentObject();
            if (e.getSource() == this.rowCnt) {
                matrix.setRowCount(this.getInt(this.rowCnt.getText(), matrix.getRowCount()));
                this.chooseIndex.updateIndexSets();
            } else if (e.getSource() == this.textField) {
                this.handleIndexedContentPropertyChange(matrix);
            } else if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
                matrix.setFont(this.storeFont());
            }
            Animation.get().doChange();
            this.repaintNow();
        }
    }

    protected void handleIndexedContentPropertyChange(PTMatrix matrix) {
        Vector<Integer> indices = this.chooseIndex.getSelectedIndices();
        if ("Matrix.rowIdentifier".equals(this.chooseIndex.getSelectedKindOfObject())) {
            if (indices.size() == 1 && this.chooseIndex.getSelectedMethod().equals("Matrix.rowIdentifier Matrix.methodSetColumnCount")) {
                int r = indices.get(0);
                if (r == -1) {
                    int row = 0;
                    while (row < matrix.getRowCount()) {
                        matrix.setColumnCount(row, this.getInt(this.textField.getText(), matrix.getColumnCount(row)));
                        ++row;
                    }
                } else {
                    matrix.setColumnCount(r, this.getInt(this.textField.getText(), matrix.getColumnCount(r)));
                }
                this.chooseIndex.updateIndexSets();
            }
        } else if ("Matrix.cellIdentifier".equals(this.chooseIndex.getSelectedKindOfObject()) && indices.size() == 2) {
            int r = indices.get(0);
            int c = indices.get(1);
            if (r == -1) {
                int row = 0;
                while (row < matrix.getRowCount()) {
                    if (c == -1) {
                        int column = 0;
                        while (column < matrix.getColumnCount(row)) {
                            this.handleChosenMethod(matrix, row, column);
                            ++column;
                        }
                    } else {
                        this.handleChosenMethod(matrix, row, c);
                    }
                    ++row;
                }
            } else if (c == -1) {
                int column = 0;
                while (column < matrix.getColumnCount(r)) {
                    this.handleChosenMethod(matrix, r, column);
                    ++column;
                }
            } else {
                this.handleChosenMethod(matrix, r, c);
            }
        }
    }

    protected void handleChosenMethod(PTMatrix matrix, int row, int column) {
        String kindOfObject;
        String selectedMethod = this.chooseIndex.getSelectedMethod();
        if (selectedMethod.equals(String.valueOf(kindOfObject = this.chooseIndex.getSelectedKindOfObject()) + " " + MATRIX_METHOD_SET_TEXT)) {
            this.setDataAt(row, column, this.textField.getText(), matrix);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_HIGHLIGHTED)) {
            matrix.setHighlighted(row, column, true);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_UNHIGHLIGHTED)) {
            matrix.setHighlighted(row, column, false);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_ELEMENT_HIGHLIGHTED)) {
            matrix.setElementHighlighted(row, column, true);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_ELEMENT_UNHIGHLIGHTED)) {
            matrix.setElementHighlighted(row, column, false);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_VISIBLE)) {
            matrix.setVisible(row, column, true);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_INVISIBLE)) {
            matrix.setVisible(row, column, false);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_OUTLINED)) {
            matrix.setOutlined(row, column, true);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_NOTOUTLINED)) {
            matrix.setOutlined(row, column, false);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_DIAGONAL_DOWN)) {
            matrix.setDiagonalElements(row, column, this.textField.getText(), true);
        } else if (selectedMethod.equals(String.valueOf(kindOfObject) + " " + MATRIX_METHOD_SET_DIAGONAL_UP)) {
            matrix.setDiagonalElements(row, column, this.textField.getText(), false);
        }
    }

    protected abstract void setDataAt(int var1, int var2, String var3, PTMatrix var4);
}

