/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.TimedAnimator;
import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandler;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimedAnimatorEditor
extends AnimatorEditor
implements ItemListener {
    JComboBox methodChoice;
    private JRadioButton timeCB;
    private JRadioButton ticksCB;
    protected JTextField totalTF;
    private JTextField offsetTF;
    int[] objectNums = null;

    @Override
    protected void buildGUI() {
        this.objectSB.addItemListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel c = new JPanel(gbl);
        JLabel a = AnimalTranslator.getGUIBuilder().generateJLabel("AnimatorEditor.methodLabel");
        gbl.setConstraints(a, gbc);
        c.add(a);
        this.methodChoice = new JComboBox();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbl.setConstraints(this.methodChoice, gbc);
        c.add(this.methodChoice);
        this.timeCB = new JRadioButton("ms", true);
        this.timeCB.setMnemonic(77);
        gbc.gridwidth = 1;
        gbl.setConstraints(this.timeCB, gbc);
        c.add(this.timeCB);
        a = AnimalTranslator.getGUIBuilder().generateJLabel("AnimatorEditor.totalLabel", null);
        gbl.setConstraints(a, gbc);
        c.add(a);
        this.totalTF = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.totalTF, gbc);
        c.add(this.totalTF);
        this.ticksCB = new JRadioButton("ticks", false);
        this.ticksCB.setMnemonic(84);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbl.setConstraints(this.ticksCB, gbc);
        c.add(this.ticksCB);
        ButtonGroup g = new ButtonGroup();
        g.add(this.timeCB);
        g.add(this.ticksCB);
        a = AnimalTranslator.getGUIBuilder().generateJLabel("AnimatorEditor.offsetLabel", null);
        gbl.setConstraints(a, gbc);
        c.add(a);
        this.offsetTF = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.offsetTF, gbc);
        c.add(this.offsetTF);
        this.addLayer(c);
    }

    @Override
    public void setProperties(XProperties props) {
        if (props.getBoolProperty("TimedAnimator.useTicks")) {
            this.ticksCB.setSelected(true);
        } else {
            this.timeCB.setSelected(true);
        }
        this.setInt(this.totalTF, props.getIntProperty("TimedAnimator.duration", 10));
        this.setInt(this.offsetTF, props.getIntProperty("TimedAnimator.offset", 0));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("TimedAnimator.useTicks", this.ticksCB.isSelected());
        props.put("TimedAnimator.duration", this.getInt(this.totalTF.getText(), 0));
        props.put("TimedAnimator.offset", this.getInt(this.offsetTF.getText(), 0));
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        return null;
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        TimedAnimator ta = (TimedAnimator)eo;
        this.methodChoice.setSelectedItem(ta.getMethod());
        this.timeCB.setSelected(!ta.isUnitIsTicks());
        this.ticksCB.setSelected(ta.isUnitIsTicks());
        this.setInt(this.totalTF, ta.getDuration());
        this.setInt(this.offsetTF, ta.getOffset());
    }

    @Override
    public void storeAttributesInto(EditableObject a) {
        super.storeAttributesInto(a);
        TimedAnimator ta = (TimedAnimator)a;
        ta.setMethod((String)this.methodChoice.getSelectedItem());
        ta.setUnitIsTicks(this.ticksCB.isSelected());
        ta.setDuration(this.getInt(this.totalTF.getText(), ta.getDuration()));
        ta.setOffset(this.getInt(this.offsetTF.getText(), ta.getOffset()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof ObjectSelectionButton) {
            int[] now = ((ObjectSelectionButton)e.getSource()).getObjectNums();
            if (now != this.objectNums && now != null) {
                this.objectNums = now;
                Object property = ((TimedAnimator)this.getCurrentObject()).getProperty(0.0);
                Vector<String> methods = this.getApplicableMethods(property);
                String oldMethod = (String)this.methodChoice.getSelectedItem();
                if (this.methodChoice.getItemCount() > 0) {
                    this.methodChoice.removeAllItems();
                }
                if (methods != null && methods.size() != 0) {
                    int i = 0;
                    while (i < methods.size()) {
                        String method = methods.elementAt(i);
                        this.methodChoice.addItem(method);
                        ++i;
                    }
                    this.methodChoice.setSelectedItem(oldMethod);
                } else if (now != null && now.length > 1) {
                    this.methodChoice.addItem(AnimalTranslator.translateMessage("AnimatorEditor.noCommonMethod"));
                } else {
                    this.methodChoice.addItem(AnimalTranslator.translateMessage("AnimatorEditor.noAppropriateMethod"));
                }
            } else if (now == null) {
                this.methodChoice.removeAllItems();
                this.methodChoice.addItem(AnimalTranslator.translateMessage("AnimatorEditor.noObjectSelectedException"));
            }
        }
        this.methodChoice.repaint();
    }

    protected Vector<String> getApplicableMethods(Object property) {
        Vector<String> methods = null;
        Vector<String> newMethods = null;
        GraphicObjectHandler handler = null;
        PTGraphicObject g = null;
        int a = 0;
        while (a < this.objectNums.length) {
            g = Animation.get().getGraphicObject(this.objectNums[a]);
            newMethods = null;
            if (g != null) {
                handler = g.getHandler();
            }
            if (handler != null) {
                newMethods = handler.getMethods(g, property);
                if (newMethods == null) {
                    methods = null;
                    break;
                }
                if (methods == null) {
                    methods = newMethods;
                } else {
                    int b = methods.size() - 1;
                    while (b >= 0) {
                        if (!newMethods.contains(methods.elementAt(b)) && !g.isCompatibleMethod(methods.elementAt(b))) {
                            methods.removeElementAt(b);
                        }
                        --b;
                    }
                }
            }
            ++a;
        }
        return methods;
    }

    @Override
    protected String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        String method = (String)this.methodChoice.getSelectedItem();
        if (method == null) {
            return null;
        }
        if (method.equals(AnimalTranslator.translateMessage("AnimatorEditor.noCommonMethod")) || method.equals(AnimalTranslator.translateMessage("AnimatorEditor.noAppropriateMethod")) || method.equals(AnimalTranslator.translateMessage("AnimatorEditor.noObjectsSelected"))) {
            return method;
        }
        return null;
    }
}

