/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.SetFont;
import animal.editor.Editor;
import animal.editor.animators.TimedAnimatorEditor;
import animal.main.Animal;
import animal.misc.EditableObject;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import translator.AnimalTranslator;

public class SetFontEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -2832505946091287650L;
    private JScrollPane scp;
    private JComboBox fontName;
    private JComboBox fontSize;
    private JCheckBox italic;
    private JCheckBox bold;
    private boolean isItalic;
    private boolean isBold;

    protected void buildGUI() {
        super.buildGUI();
        JTabbedPane tp = new JTabbedPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel fontPanel = new JPanel(gbl);
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.nameLabel"), gbc);
        String[] fonts = Animal.GLOBAL_FONTS;
        gbc.gridwidth = 0;
        this.fontName = new JComboBox();
        fontPanel.add((Component)this.fontName, gbc);
        int j = 0;
        while (j < fonts.length) {
            this.fontName.addItem(fonts[j]);
            ++j;
        }
        this.fontName.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("AbstractTextEditor.fontSizeLabel"), gbc);
        gbc.gridwidth = 0;
        this.fontSize = new JComboBox();
        fontPanel.add((Component)this.fontSize, gbc);
        this.fontSize.setEditable(true);
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("24");
        this.fontSize.setSelectedItem("12");
        this.fontSize.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("AbstractTextEditor.fontStyleLabel"), gbc);
        this.italic = AnimalTranslator.getGUIBuilder().generateJCheckBox("italic", null, this);
        this.italic.setHorizontalAlignment(0);
        fontPanel.add((Component)this.italic, gbc);
        this.bold = AnimalTranslator.getGUIBuilder().generateJCheckBox("bold", null, this);
        this.bold.setHorizontalAlignment(0);
        fontPanel.add((Component)this.bold, gbc);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("SetFontEditor.font", null, fontPanel, tp);
        this.scp = new JScrollPane(fontPanel);
        this.addLayer(this.scp);
        this.finish();
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Font f = ((SetFont)eo).getValue();
        this.isItalic = f.isItalic();
        this.isBold = f.isBold();
        this.italic.setSelected(this.isItalic);
        this.bold.setSelected(this.isBold);
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
    }

    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        SetFont setFont = (SetFont)eo;
        setFont.setValue(this.storeFont());
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        this.isItalic = this.italic.isSelected();
        this.isBold = this.bold.isSelected();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        SetFontEditor result = new SetFontEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        SetFont h = new SetFont();
        this.storeAttributesInto(h);
        return h;
    }
}

