/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.variables.Variable;

public class VariableUpdate
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "VariableDeclaration";
    private transient AnimationState animState;
    private String name;
    private String targetValue;

    public VariableUpdate() {
    }

    public VariableUpdate(int step, String varName, String newValue) {
        super(step, (int[])null);
        this.name = varName;
        this.targetValue = newValue;
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.animState = animationState;
    }

    public void action(long time, double ticks) {
        this.execute();
    }

    public void execute() {
        super.execute();
        Variable variable = this.animState.getVariables().get(this.name);
        if (variable != null) {
            variable.setValue(this.targetValue);
        }
        AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView(false).setStep(this.getStep());
    }

    public String getAnimatorName() {
        return "VariableUpdate";
    }

    public int getFileVersion() {
        return 1;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{"VariableUpdate"};
    }

    public boolean isChangingAnimator() {
        return false;
    }

    public boolean isGraphicalObjectAnimator() {
        return false;
    }

    public void discard() {
        this.animState = null;
        this.name = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append(this.name).append(" = ").append(this.targetValue);
        return sb.toString();
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String aValue) {
        this.targetValue = aValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

