<?php //$Id: restorelib.php,v 1.1.2.2 2008/08/06 10:14:54 thepurpleblob Exp $
    //This php script contains all the stuff to backup/restore
    //groupselect mods

    //This is the "graphical" structure of the groupselect mod:   
    //
    //                       groupselect 
    //                    (CL,pk->id)
    //
    // Meaning: pk->primary key field of the table
    //          fk->foreign key to link with parent
    //          nt->nested field (recursive data)
    //          CL->course level info
    //          UL->user level info
    //          files->table may have files)
    //
    //-----------------------------------------------------------

    //This function executes all the restore procedure about this mod
    function groupselect_restore_mods($mod,$restore) {

        global $CFG;

        $status = true;

        //Get record from backup_ids
        $data = backup_getid($restore->backup_unique_code,$mod->modtype,$mod->id);

        if ($data) {
            //Now get completed xmlized object
            $info = $data->info;
            traverse_xmlize($info);                                                                     //Debug
            print_object ($GLOBALS['traverse_array']);                                                  //Debug
            $GLOBALS['traverse_array']="";                                                              //Debug
          
            //Now, build the LABEL record structure
            $groupselect = new object();
            $groupselect->course        = $restore->course_id;
            $groupselect->name          = backup_todb($info['MOD']['#']['NAME']['0']['#']);
            $groupselect->intro         = backup_todb($info['MOD']['#']['INTRO']['0']['#']);
            $groupselect->password      = backup_todb($info['MOD']['#']['PASSWORD']['0']['#']);
            $groupselect->timeavailable = backup_todb($info['MOD']['#']['TIMEAVAILABLE']['0']['#']);
            $groupselect->timedue       = backup_todb($info['MOD']['#']['TIMEDUE']['0']['#']);
            $groupselect->timemodified  = backup_todb($info['MOD']['#']['TIMEMODIFIED']['0']['#']);
 
            //The structure is equal to the db, so insert the groupselect
            $newid = insert_record ("groupselect",$groupselect);

	    //Restore the groupinfo, now we have to do some tricks to
	    //get the new group ids. We assume that groups are
	    //restored before mods (these seems to be true
	    //assertions).
	    if (array_key_exists ('GROUPINFO', $info['MOD']['#']))
	      {
		$groupinfo = $info['MOD']['#']['GROUPINFO'];
		
		foreach ($groupinfo as $gi)
		  {
		    $groupid = backup_todb ($gi['#']['GROUPID']['0']['#']);
		    $group   = backup_getid ($restore->backup_unique_code, 'groups', $groupid);
		    
		    if ($group)
		      {			
			$groupid = $group->new_id;
			$maxmembers = backup_todb ($gi['#']['MAXMEMBERS']['0']['#']);
			
			execute_sql ("insert into {$CFG->prefix}groupselect_groupinfo " .
				     "values ($newid, $groupid, $maxmembers)", false);
		      }
		  }
	      }
	    
            //Do some output     
            if (!defined('RESTORE_SILENTLY')) {
                echo "<li>".get_string("modulename","groupselect")." \"".format_string(stripslashes($groupselect->name),true)."\"</li>";
            }
            backup_flush(300);

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,$mod->modtype,
                             $mod->id, $newid);
   
            } else {
                $status = false;
            }
        } else {
            $status = false;
        }

        return $status;
    }

    function groupselect_decode_content_links_caller($restore) {
        global $CFG;
        $status = true;

        if ($groupselects = get_records_sql ("SELECT l.id, l.intro
                                   FROM {$CFG->prefix}groupselect l
                                   WHERE l.course = $restore->course_id")) {
            $i = 0;   //Counter to send some output to the browser to avoid timeouts
            foreach ($groupselects as $groupselect) {
                //Increment counter
                $i++;
                $intro = $groupselect->intro;
                $result = restore_decode_content_links_worker($intro,$restore);

                if ($result != $intro) {
                    //Update record
                    $groupselect->intro = addslashes($result);
                    $status = update_record("groupselect", $groupselect);
                    if (debugging()) {
                        if (!defined('RESTORE_SILENTLY')) {
                            echo '<br /><hr />'.s($intro).'<br />changed to<br />'.s($result).'<hr /><br />';
                        }
                    }
                }
                //Do some output
                if (($i+1) % 5 == 0) {
                    if (!defined('RESTORE_SILENTLY')) {
                        echo ".";
                        if (($i+1) % 100 == 0) {
                            echo "<br />";
                        }
                    }
                    backup_flush(300);
                }
            }
        }
        return $status;
    }

    //This function returns a log record with all the necessay transformations
    //done. It's used by restore_log_module() to restore modules log.
    function groupselect_restore_logs($restore,$log) {
                    
        $status = false;
                    
        //Depending of the action, we recode different things
        switch ($log->action) {
        case "add":
            if ($log->cmid) {
                //Get the new_id of the module (to recode the info field)
                $mod = backup_getid($restore->backup_unique_code,$log->module,$log->info);
                if ($mod) {
                    $log->url = "view.php?id=".$log->cmid;
                    $log->info = $mod->new_id;
                    $status = true;
                }
            }
            break;
        case "update":
            if ($log->cmid) {
                //Get the new_id of the module (to recode the info field)
                $mod = backup_getid($restore->backup_unique_code,$log->module,$log->info);
                if ($mod) {
                    $log->url = "view.php?id=".$log->cmid;
                    $log->info = $mod->new_id;
                    $status = true;
                }
            }
            break;
        default:
            if (!defined('RESTORE_SILENTLY')) {
                echo "action (".$log->module."-".$log->action.") unknown. Not restored<br />";                 //Debug
            }
            break;
        }

        if ($status) {
            $status = $log;
        }
        return $status;
    }
?>
