/*
    Copyright 2006 by Mark Weyer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mdGold.inc"

#declare Gold = texture {
  pigment {rgb <1,2/3,0>}
  finish {specular 0.8 metallic}
}

/*
//Dekommentieren, wenn man die Stapel schnell anpassen will
#macro Muenze()
  cylinder {
    -HDicke*y HDicke*y Rad
    Textur(texture {Gold})
  }
#end
*/

#declare KopfRad = Rad*0.7;
#declare Rundheit = Rad/20;
#declare Gravurtiefe = KopfRad/32/sqrt(2); // Damit die Steigung immer 1 ist
#declare Rand = Rad/8;
#declare ZahlHoehe = Rad/3;
#declare ZifferBreite = Rad/5;
#declare ZifferRad = Rad/15;
#declare ZahlZMax = -Rad/3;
#declare ZahlZMin = ZahlZMax-ZahlHoehe;
#declare ZahlKreisZ1 = ZahlZMax-ZifferBreite/2;
#declare ZahlKreisZ2 = ZahlZMin+ZifferBreite/2;
#declare ZweiD1 = sqrt(pow(ZifferRad,2)
  + pow(ZahlHoehe-ZifferBreite+ZifferRad,2));
#declare ZweiWinkel = atan((ZahlHoehe-ZifferBreite+ZifferRad)/ZifferRad)
  - asin(ZifferRad/ZweiD1);
#declare ZweiCos = cos(ZweiWinkel);
#declare ZweiSin = sin(ZweiWinkel);
#declare LogoRad1 = Rad/5;
#declare LogoRad2 = LogoRad1*2;
#declare LogoExtra = LogoRad1/2;
#declare LogoZ = Rad/5;
#declare LogoX = LogoRad2-2*LogoRad1+LogoExtra/2;

#declare NasenkugelGrau = function {pigment {
  image_map {ppm "inGrau.ppm" once interpolate 2}
  translate -1/2
  scale 2*KopfRad
}}


//Kommentieren, wenn man die Stapel schnell anpassen will
#macro Muenze()
  isosurface {
    function {sqrt(
      pow(max(0,sqrt(pow(x,2)+pow(z,2))-Rad+Rundheit),2) +
      pow(max(0,
        abs(y)-HDicke+Rundheit +
        max(0,min(Gravurtiefe,Rad-Rand-sqrt(pow(x,2)+pow(z,2)))) -
        max(0,min(Gravurtiefe,Gravurtiefe-select(y,
          // Rckseite
          Gravurtiefe*NasenkugelGrau(-x,z,0).x,
          // Vorderseite
          select(z-ZahlZMax,
            // Jahreszahl
            select(abs(x)-ZifferBreite,
              // 00
              abs(sqrt(
                pow(abs(x)-ZifferBreite/2,2)+
                pow(max(0,z-ZahlKreisZ1,ZahlKreisZ2-z),2)
                )-ZifferRad),
              select(x,
                // 2
                min(
                  select(
                    (x+ZifferBreite*3/2)*ZweiCos+(z-ZahlKreisZ1)*ZweiSin
                      +ZweiD1,
                  Gravurtiefe,select(
                    (x+ZifferBreite*3/2)*ZweiCos+(z-ZahlKreisZ1)*ZweiSin,
                    min(
                      sqrt(pow(x+ZifferBreite*3/2+ZweiCos*ZifferRad,2)
                        +pow(z-ZahlKreisZ1-ZweiSin*ZifferRad,2)),
                      abs((x+ZifferBreite*3/2+ZifferRad)*ZweiSin
                        -(z-ZahlKreisZ2+ZifferRad)*ZweiCos)),
                    abs(sqrt(
                        pow(abs(x)-ZifferBreite*3/2,2)+pow(z-ZahlKreisZ1,2))
                      -ZifferRad)
                  )),
                  sqrt(pow(z-ZahlKreisZ2+ZifferRad,2)+
                    pow(max(0,x+ZifferBreite*3/2-ZifferRad,
                      -ZifferBreite*3/2-ZifferRad-x),2))
                ),
                // 6
                min(
                  abs(sqrt(pow(x-ZifferBreite*3/2,2)+pow(z-ZahlKreisZ2,2))
                    -ZifferRad),
                  select(z-ZahlKreisZ2,Gravurtiefe,select(z-ZahlKreisZ1,
                    select(x-ZifferBreite*3/2,
                      abs(x-ZifferBreite*3/2+ZifferRad),
                      sqrt(pow(x-ZifferBreite*3/2-ZifferRad,2)
                        +pow(z-ZahlKreisZ1,2))),
                    abs(sqrt(pow(x-ZifferBreite*3/2,2)+pow(z-ZahlKreisZ1,2))
                      -ZifferRad)))
                )
              )
            ),
            // Logo
            min(
              // Cu
              select(x-LogoX+LogoRad1+LogoExtra,
                abs(abs(sqrt(pow(x-LogoX+LogoRad1+LogoExtra,2)+pow(z-LogoZ,2))
                  -(LogoRad1+LogoRad2)/2)-(LogoRad2-LogoRad1)/2),
                sqrt(pow(max(0,x-LogoX+LogoRad1),2)+pow(abs(abs(z-LogoZ)
                  -(LogoRad1+LogoRad2)/2)-(LogoRad2-LogoRad1)/2,2))),
              // y (waagerecht)
              sqrt(pow(max(0,LogoX-LogoRad1-LogoExtra-x,x-LogoX),2) +
                pow(z-LogoZ,2)),
              // y (senkrecht)
              sqrt(pow(x-LogoX,2) +
                pow(max(0,abs(z-LogoZ)-LogoRad1-LogoExtra),2)),
              // o
              abs(sqrt(pow(x-LogoX-2*LogoRad1,2)+pow(z-LogoZ,2))-LogoRad1)
            )
          )
        )))
      ),2)
    )}
    threshold Rundheit
    max_gradient 1.5
    contained_by {sphere {0 Rad+HDicke}}
    Textur(texture {Gold})
  }
#end


#ifdef(Version)
  #declare Gross=(Version=-1);
#else
  #declare Gross=0;
#end


#if (Gross)

  /* Zwei Mnzen (Vorder- und Rckseite) in Groaufnahme */

  camera {orthographic location -2*z right 4*x up 2*y}

  light_source {<-1,1,-2>*1000 1.5}

  #macro Textur(T) texture{T} #end

  object {
    Muenze()
    rotate 90*x
    rotate 180*z
    translate Rad*1.1*x
    scale 0.9/Rad
  }

  object {
    Muenze()
    rotate -90*x
    translate Rad*-1.1*x
    scale 0.9/Rad
  }

#else

  #declare Breite=4;
  #declare Hoehe=4;

  #include "dungeon.inc"

  #declare Muenz = Muenze()

  #declare Block = union {
    #local II=0;
    #while (II<AnzMuenzen)
      object {
        Muenz
        rotate Muenzen[II][3]*y
        rotate Muenzen[II][4]*x
        rotate Muenzen[II][5]*y
        translate <Muenzen[II][0]+1/2,Muenzen[II][1],Muenzen[II][2]+1/2>
      }
      #local II=II+1;
    #end
  }

  #ifdef (Version)
    Setze()
  #else
    union {
      object {Boden}
      object {Block translate <1,0,1>}
      object {Block translate <1,0,-2>}
      object {Block translate <-2,0,1>}
      object {Block translate <-2,0,-2>}
      rotate -90*x
    }
  #end

#end

