/*
    Copyright 2006 by Mark Weyer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

global_settings {
  max_intersections 200
}

#declare Eigenes_Licht = 1;

#ifdef(Version)
  #declare Eigene_Kamera = 1;
#else
  #ifndef(Breite)
    #declare Breite = 6;
    #declare Hoehe = 2;
  #end
#end

#include "dungeon_boden.inc"

#declare Hintergrund = 0;
#declare Nebelweite = 1000;

#include "cuyopov.inc"

#declare Hoehe = 3;
#declare Ueberlappung = 0.03;
#declare Augenhoehe = Hoehe*2/3;
#declare Sichtweite = 5.5;
 
#declare Groesse = array[7] {   // Die letzten zwei Eintrge
                                // sind Dummies fr Boden und Himmel
  4,4,3,3,2,0,-1
};

#macro BlockAusWand(Wand)
  union {
    object {Wand}
    object {Wand rotate 90*y translate z}
    object {Wand rotate 180*y translate x+z}
    object {Wand rotate 270*y translate x}
  }
#end

#macro SetzBlock(X,Z)
  object {Block clipped_by {box {<-1,1/4,-1> <2,1+Hoehe,2>}} translate <X,0,Z>}
#end

#macro Setze()
  #ifdef (Version)
    #local Z=int(sqrt(Version+1));
    #local X=Version+1-Z*Z-Z;
    SetzBlock(X,Z)
    #ifndef (Nur_Umriss)
      object {Boden}
    #end
  #else
    union {
      #ifndef (Nur_Umriss)
        object {Boden}
      #end
      union {
        SetzBlock(-1,0) SetzBlock(-1,-1)
        clipped_by {box{<-1,0,-1><1,1+Hoehe,1>}}
        rotate DraufsichtDrehung*90*y
        translate (DraufsichtDrehung-1)*2*x
      }
      rotate -90*x
    }
  #end
#end


#ifdef (Version)

  camera {
    location <1/2,Augenhoehe,1/2>
    right 2*x
    #switch (Groesse[int(sqrt(Version+1))-1])
      #case (4) #local hoch=1; #local runter=1; #break
      #case (3) #local hoch=1/2; #local runter=1; #break
      #case (2) #local hoch=1/2; #local runter=1/2; #break
      #case (0) #local hoch=0; #local runter=1; #break
      #case (-1) #local hoch=1; #local runter=0; #break
    #end
    up (hoch+runter)*y
    direction (hoch-runter)/2*y+z
  }

  #ifndef (Nur_Umriss)

    box{
      -Nebelweite <Nebelweite,Hoehe,Nebelweite>
      hollow
      pigment {rgbt <0,0,0,1>}
      interior {media {emission 1/Sichtweite}}
      #ifndef (Version)
        rotate -90*x
      #end
    }

    #declare Numlights = 4*5;

    #local I=0;
    #while (I<Numlights)
      light_source {
        y*10000
        5/Numlights
        parallel
        point_at 0
        rotate 30*z
        rotate 360*I/Numlights*y
        #ifndef (Version)
          rotate -90*x
        #end
      }
      #local I=I+1;
    #end

  #end

#else

  light_source {
    <-1,1,-Hoehe>
    1
    parallel
    point_at 0
  }
  light_source {
    <1,0,-Hoehe>
    1/2
    parallel
    point_at 0
  }
  light_source {
    <0,-1,-1>
    1/2
    parallel
    point_at 0
  }

#end

