/***************************************************************************
                          spielfeld.h  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPIELFELD_H
#define SPIELFELD_H

#include "inkompatibel.h"

#include <cstdlib>

#include <qwidget.h>
#include <qtimer.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "blop.h"
#include "blopgitter.h"
#include "fall.h"


#define graue_bei_kettenreaktion 5 // (grx - 1) // (grz - minflopp)

/* gibt an, um wie viele Pixel pro Zeitschritt sich alles beim Reihe-Rbergeben
   verschiebt; sollte Teiler von gric sein */
#define reihe_rueber_senkrecht_pixel 8

#define fall_langsampix 6



/* Fr das Grafik-Update-System... */
#define ebene_hintergrund 0
#define ebene_blops 2
#define ebene_fall 3
#define ebene_hetzrand 4



/* Rckgabewerte fr getFallModus(); wird vom KIPlayer bentigt. */
#define fallmodus_keins 0
#define fallmodus_neu 1
#define fallmodus_unterwegs 2




class KIPlayer;

/**
  *@author immi
  */

class Spielfeld : public QWidget  {
  Q_OBJECT
public:
  Spielfeld(bool re, QWidget *parent=0, const char *name=0);
  ~Spielfeld();
  /** Sollte einmal direkt nach dem Start von cuyo aufgerufen werden;
      initialisiert den aktuellen Level und benutzt das Startbild als
      Titelbild. */
  void erzeugTitelbild();
  /** sollte nur aufgerufen werden, wenn papa->spielLaeuft() false
      liefert; liefert
      true, wenn alle Spiel-Stop-Animationen fertig sind; liefert
      brigens auch true,
      wenn dieser Spieler gar nicht mitspielt */
  bool bereitZumStoppen();
  /** Lsst den Hetzrand schnell runterkommen (fr die
      Zeitbonus-Animation). Liefert true, wenn fertig. */
  bool bonusSchritt();
  /** Liefert true, wenn grade ein Fallendes unterwegs ist.
      Wird vom KIPlayer bentigt */
  int getFallModus() const;
  /** Liefert true, wenn noch Gras da ist (d. h. wenn nicht gewonnen.) */
  bool istGrasDa() const;
  /** Liefert einen Pointer auf das Blopgitter zurck. */
  BlopGitter * getDatenPtr();
  /** Liefert einen Pointer auf die fallendne Blops zurck.
      Wird von KIPlayer einmal am Anfang aufgerufen. */
  const Blop * getFallPtr();
  /** Liefert die Pos. zurck, an der neue Dinge oben
      auftauchen. */
  int getHetzrandYAuftauch() const;
  /** Liefert die Pos. zurck, bis wohin noch Dinge liegen
      drfen, ohne dass man tot ist. */
  int getHetzrandYErlaubt() const;
  /** Liefert die Pos. vom Hetzrand in Pixeln zurck. Wird
      vom Fall gebraucht. */
  int getHetzrandYPix() const ;
  /** Liefert die (rberreihenbedingte) Hochverschiebung
      des gesamten Spielfelds. Wird vom Fall bentigt (um
      seine Koordinaten in Feldern zu berechnen). */
  int getHochVerschiebung();
  /** setzt den Bereich vom Fallenden auf upzudaten */
  void setUpdateFall(int ebene = ebene_hintergrund);

  /** Zeigt t gro an. (Oder weniger gro.) Auf Wunsch wird
      ein Update-Event gesendet. (Sonst ist der Aufrufer selbst
      dafr verantwortlich, dass der Text auch wirklich mal
      angezeigt wird.) */
  void setText(__String t, bool update_event = true,
               bool kleine_schrift = false);
  
  /** Fr whrend des Spiels: Setzt einen Text, der ein paar mal
      aufblinkt. */
  void setMessage(__String mess);
  
 protected: // Protected methods
  /** liefert die Hhe vom hchsten Trmchen */
  int getHoehe();
  /**  */
  void paintEvent(QPaintEvent *);
  /** Liefert die Koordinaten eines Felds in Pixeln zurck (ungespiegelt) */
  QPoint getFeldKoord(int x, int y) const;
  /** liefert eine VerbindungsBitliste fr den Blop bei x, y. Bezieht sich
      ggf. auf's Feuer. */
  int getVerbindungen(int x, int y, bool feuer = false) const;
  /** berechnet, ob und welche Blops platzen mssen. Auerdem
      werden den Blops die Kettengren mitgeteilt, und Graue
      und Punkte verteilt */
  bool calcFlopp();
  /** sucht die Zusammenhangskomponente von x, y mit Farbe n.
      Setzt flopp[][] an den entspr. Stellen auf w.
      Aufruf mit w = -1 um rauszufinden, ob genug gleichfarbige beisammen sind;
      liefert Anzahl der gleichfarbigen zurck;
      Danach Aufruf mit w = 1 und richtigem anz-Wert, um den Blops ihre neue
      Kettengre mitzuteilen.
      Liefert Anzahl der Punkte zurck, die's dafr gibt (wenn Blops platzen).
      Wenn auch_gras true ist, wird auch benachbartes Gras gesprengt.
      Nur wenn platzen = true ist, wird platzen durchgefhrt.
      Sonst bekommen die
      Blops nur ihre Kettengre mitgeteilt.
      @return Je nach w Gre der Zshgskomp. oder Anz. d. Punkte */
  int calcFloppRec(int flopp[grx][gry], int x, int y,
		   int n, int w, bool platzen = false,
		   bool auch_gras = false, int anz = 0);
  /** Ruft malUpdateIntern() auf und malt das interne Bild dann
      auf p.
      Bei force = true wird nicht darauf geschaut, ob die Zeit gerade
      knapp ist. */
  void malUpdate(QPainter & p, bool force = false);
  /** Hier findet die Grafik statt: Alles was in den mUpdateXXX-
      Variablen angegeben ist (auch in denen von den Blops selbst),
      wird auf den internen Puffer neu gezeichnet. */
  void malUpdateIntern();
  /** verschiebt einen Blop (auch wenn er explodiert oder sonstwie
      grad animiert ist). Was dort hin soll, von wo der Blop weg ist
      (z. B. blopart_wirklich_keins) kann bergeben werden. */
  void verschiebBlop(int x1, int y1, int x2, int y2,
		     int bg_sorte = blopart_keins);
  /** ndert die Hhe vom Hetzrand auf y (in Pixeln).
      Insbesondere wird auch hetzrandY gendert. */
  void setHetzrandYPix(int y);
  /** Wenn der Level gespiegelt ist, wird auch r gespiegelt */
  QRect spiegelRect(const QRect & r);
  /** Setzt das Rechteck r auf upzudaten. Der ebene-Parameter sollte
      (im Moment) nur von malUpdate() benutzt werden. */
  void setUpdateRect(QRect r, int ebene = ebene_hintergrund);
  /** Setzt das Rechteck x, y, w, h auf upzudaten. */
  void setUpdateRect(int x, int y, int w = gric, int h = gric,
		     int ebene = ebene_hintergrund);
  /** Setzt alles auer den Hetzrand auf upzudaten. */
  void setUpdateFastAlles();
  /** Malt die Schrift auf den Bildschirm */
  void malSchrift(QPainter & p, bool mitte = true);
  /** Lsst ein neues Fall oben auftauchen. Liefert false, wenn
      dafr kein Platz ist. */
  bool neuesFall();
  /** Lsst in der Luft hngende Blops ein Stck runterfallen.
      Liefert zurck, ob sich nichts bewegt hat, nur unten oder auch
      oben. Bei auchGraue = true, kommen auch Graue, die ganz ber
      dem Spielfeld hngen. */
  int rutschNach(bool auchGraue);
  public:
  /** Kmmert sich um hin- und hergeben von Reihen. */
  void rueberReihenSchritt();
  protected:
  /** Prft, ob ein Reihenbekommen sinnvoll wre und initiiert es ggf.
      (Unterhlt sich auch mit dem anderen Spieler). Liefert true,
      wenn es jetzt grad nicht mglich war, eine Reihe zu bekommen,
      aber nur weil der andere Spieler noch damit beschftigt war,
      von einer vorigen Reihe sein Spielfeld runterzuschieben. Unter
      manchen Umstnden wird dann spter nochmal probiert, eine
      Reihe zu bekommen. */
  bool bekommVielleichtReihe();


  /***** Variablen, die die ganze Zeit konstant sind *****/
  
	
  /** true, wenn rechter von den beiden Spielern */
  bool mRechterSpieler;

  /** Das Titelbild (fr whrend kein Spiel luft) */
  QPixmap mTitelbild;
	
  /***** Variablen, die sich hufig ndern *****/

  /** Kopie vom Bildschirm fr flackerfreies Malen
      (nur vom Spielgeschehen, nicht von Schrift, die drber steht;
      also von dem, was malUpdate() / malUpdateIntern() malt) */
  QPixmap mBild;
	
  /** Text, der grade angezeigt wird (falls das Spiel nicht luft) */
  __String mText;
  /** True, wenn die Schrift von mText klein sein soll. */
  bool mTextKlein;
  /** Text, der grade blinkt */
  __String mMessageText;
  /** Blink-Zeitzhler. */
  int mMessageZeit;
		
  /** _die_ Spielfelddaten */
  BlopGitter mDaten;
  /** Zeit innerhalb des Levels */
  int mZeit;
  /** Hhe in Pixeln vom Rand, der mit der Zeit runterkommt,
      damit der Level nicht so ewig geht */
  int mHetzrandYPix;
  /** Hhe in Feldern vom Rand */
  int mHetzrandY;
  /** Alle Fall-Daten */
  Fall mFall;
  /** True, wenn das Fall grade frisch aufgetaucht ist. Der KI-Player will
      das wissen. */
  bool mFallIstNeu;
  /** eigentlicher Modus */
  int mModus;
  /** Aktueller Stand des Reihen hin- und hergebens. */
  int mRueberReihenModus;
  /** True, wenn wir so lange probieren, eine Reihe zu bekommen, bis
      der andere Spieler sagt, dass wir wirklich keine bekommen. */
  bool mWillHartnaeckigReihe;
  /** Aktuelle Pos. der Reihe beim Rberrutschen. */
  int mRestRueberReihe;
  /** true, wenn grade schon was geplatzt ist.
      Wird auf false gesetzt, wenn ein fallendes aufkommt und auf true, wenn
      etwas fertig geplatzt ist. */
  bool mKettenreaktion;
  /** Anzahl der Grauen, die darauf warten, runterzukommen */
  int mGrauAnz;
  /** != 0 whrend des Reihen hin und hergebens. Um so viele Pixel ist das
      gesamte Spielfeld nach oben verschoben. */
  int mHochVerschiebung;

  /** Die nachfolgenden Variablen werden nur whrend einer
      Rochade-Animation gebraucht */
  int mRoY;
  bool mRoGross;
  int mRoZeit;
  Blop mRoTurm;
  Blop mRoKoenig;
	
  /***** Variablen, die sich so hufig ndern, dass sie nach einem
         Funktionsaufruf von auen nicht mehr bentigt werden *****/
	
	
  /* Die folgenden Variablen geben an, was von malUpdate() neu gemalt werden soll.
     Sie sollten nur von setUpdateRect() gendert werden. */
  /** Welche Datenfelder sollen geupdatet werden? In die untere Bonuszeile wird im
      Sechseck-Modus ab und zu evtl. Mll geschrieben. */
  bool mUpdateDaten[grx][gry + 2];
  bool mUpdateFall;
  bool mUpdateHetzrand;	// der Hetzrand (samt Bild)
  /** Bereiche in den verschiedenen Ebenen, die upgedatet werden mssen.
      Kann null (statt empty) sein.
      Achtung: Schon gespiegelt */
  QRegion mUpdateRegion;
	
 public:
  /** Initialisiert alles fr's Spiel. Schaltet die Spielfeldanzeige an.
      Muss in einer Gleichzeit aufgerufen werden, fr die init-Events. 
      Danach muss noch einmal animiere() aufgerufen werden, damit alle
      Blops wissen, wie sie aussehen, und damit die Grafik gemalt wird. */
  void startLevel();
  /** Spiel abbrechen (sofort, ohne Animation; oder die
      Animation ist schon vorbei).
      Wenn malen = true ist, Bildschirm sofort updaten.
      Wenn wegen_fehler = true ist, wird das Spiel trotzdem weiter
      angezeigt. */
  void stopLevel(bool malen, bool wegen_fehler = false);
  
  
  /***** Funktionen, die einmal pro Spielschritt aufgerufen werden *****/

  /** Um Fall kmmern. (Aber nicht darum, neues Fall zu erzeugen). */
  void fallSchritt();
  
  /** kmmert sich ggf. um blinkendes Message */
  void blinkeMessage();
  
  /** Sorgt dafr, dass bei Spielende bei geeigneter Gelegenheit auch in diesem
      Spielfeld das Spiel beendet wird */
  void testeSpielende();

  /** Bewegt den Hetzrand eins nach unten. Testet auch, ob dabei
      was berdeckt wird. */
  void bewegeHetzrand();
  
  /** Sendet sich selbst (ggf.) zufllige Graue */
  void zufallsGraue();
 
  /** Zusammenhangskomponenten bestimmen und ggf. Explosionen auslsen */
  void testeFlopp();
 
  /** Ein Schritt vom Spiel.
      Animationen und das Grafik-Update werden *nicht* gemacht.
      Dazu muss animiere() aufgerufen werden. (Weil alle Animationen
      innerhalb einer Gleichzeit stattfinden sollen.) */
  void spielSchritt();
  /** Fhrt alle Animationen durch, und bei der Gelegenheit auch
      die Grafikupdates (auch die, die evtl. frher beim
      spielSchritt()-Aufruf angefallen sind). Sollte innerhalb einer
      Gleichzeit aufgerufen werden. */
  void animiere();
  
  
  
  
  
  /** Fhrt eine der nachfolgenden Tasten-Routinen aus.
      (t = taste_*). */
  void taste(int t);
  /** Bewegt das Fall eins nach links */
  void tasteLinks();
  /** Bewegt das Fall eins nach rechts */
  void tasteRechts();
  /** Dreht das Fall */
  void tasteDreh();
  /** ndert die Fallgeschwindigkeit vom Fall */
  void tasteFall();

 public slots:
  /** Graue von anderem Spieler bekommen; wird ignoriert, falls dieser
      Spieler grad nicht spielt */
  void empfangeGraue(int g);
  /** liefert (in ret) zurck, ob wir dem anderen
      Spieler eine Reihe geben (er hat Hhe h); eine der Konstanten
      bewege_reihe_xxx */
  void gebReihe(int h, int & ret);
  /** gibt einen Stein an den anderen Spieler
      rber; in s wird die Steinfarbe zurckgeliefert */
  void gebStein(Blop & s);

 signals: // Signals
  /** emit, wenn das Spiel (fr diesen Spieler) zu Ende ist */
  void sigTot();
  /** emit, wenn Graue an andere Spieler zu liefern sind (Param = Anz. d. Grauen) */
  void sigSendeGraue(int);
  /** emit, wenn evtl. eine Reihe vom anderen Spieler her sollte;
      der 1. Parameter ist dann die eigene Hhe; im zweiten speichert
      der andere Spieler die Antwort: eine der Konstanten
      bewege_reihe_xxx */
  void sigWillReihe(int, int &);
  /** emit, wenn ein Stein von der Reihe, die grad rber geht, rbergegeben werden
      soll; Steinart wird im Parameter gespeichert */
  void sigWillStein(Blop &);
  /** emit, wenn dieser Spieler Punkte bekommt. Parameter: rechterSpieler, #Punkte */
  void sigBekommPunkte(bool, int);
};

#endif

