#
#   Copyright 2005 by Mark Weyer
#
#   Partly based on code by (in alphabetical order) Berni, Immi, and Jela
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Labskaus = {
  name = "Potpourri"
  name[de] = "Labskaus"
  author = "Mark Weyer (editor)"
  author[de] = "Mark Weyer (Hrsg.)"
  description = "Made of 100% recycled graphics"
  description[de] = "Das ist alles nur gek(l)aut"
  pics = ivElephant, bmG, jjJahr, Baelle, ihLila, mbBunt, silbergold
  greypic = grau
  startpic = inGras
  startdist="BACDADBCDB"
  chaingrass = 1
  emptypic = jhBallons

  <<
    var zeit, zeit2;    # Fr jjJahr
    var drehpos;        # Fr Baelle

    global={
      zeit = (zeit + 1) % 512; # 32*4*4
      zeit2 = zeit / 32;
      drehpos = (drehpos + 1) % 12;
    };
  >>

  ivElephant = {
    numexplode = 6
    numexplode1 = 9
    pics=ivElefant.xpm

    <<
      ivElephant={
        switch {
          0?0?0?0? -> {{A,Y,a};*;};
          0?1?0?0? -> {{B,U,W};*;};
          1?1?1?0? -> {{J,R,T};*;};
          1?0?0?0? -> {{M,Q,S};*;};
          1?1?0?1? -> {{O,V,X};*;};
          -> schema16;
        };
      };
    >>
  }

  bmG = {
    numexplode = 2
    pics=bmKarten.xpm,bmStrich.xpm

    <<
      var zuklappen=1;

      bmG={
        switch {
          falling -> G*;
          zuklappen => {
            # Grade aufgekommen oder so was.
            # Aber erst noch ein Bildchen lang normal, weil sonst die
            # Start-Karten schon beim ersten Bild leicht umklappen.
            {zuklappen=0;G*}, V*, 1A*, P*
          };
          1:70 => {
            # Kurz aufklappen
            P*, 1A*, V*,
            G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,
            V*, 1A*, P*
          };
          -> A*; # zugeklappt
        };
      };
    >>
  }

  jjJahr = {
    numexplode = 4
    pics=jjWinter1.xpm,jjWinter2.xpm,jjWinter3.xpm,jjWinter4.xpm,
         jjFruehling1.xpm,jjFruehling2.xpm,jjFruehling3.xpm,jjFruehling4.xpm,
         jjSommer1.xpm,jjSommer2.xpm,jjSommer3.xpm,jjSommer4.xpm,
         jjHerbst1.xpm,jjHerbst2.xpm,jjHerbst3.xpm,jjHerbst4.xpm

    <<
      jjJahr={file=zeit2@;schema16;};
    >>
  }

  Baelle = {
    numexplode = 4
    pics=ibBaelle.xpm,ibBaelle2.xpm

    <<
      Baelle={schema16;pos=drehpos@;1*};
    >>    
  }

  ihLila = {
    numexplode=4
    numexplode1=6
    neighbours=1
    pics=ihLila.xpm

    <<
      ihLila=schemaDiag2;
    >>
  }

  mbBunt = {
    numexplode=2
    pics=mbBunt.xpm

    <<
      mbBunt={pos=37;*};
    >>
  }

  jhBallons = {
    pics=jhBallons.xpm

    <<
      var ballon;

      jhBallons = {
	if ballon@(0,1)==1 || (????0??? && 1:1000)
	  => {{ballon@(0,0)=1;*}, ballon@(0,0)=0};
      };
    >>
  }

  grau = {
    pics=explosion.xpm          # Eigentlich braucht grau gar keine Bilder

    <<
      grau.init = {
        switch {
          1:6 -> kind=mbBunt;
          1:5 -> kind=ihLila;
          1:4 -> kind=Baelle;
          1:3 -> kind=jjJahr;
          1:2 -> kind=bmG;
              -> kind=ivElephant;
        };
      };
    >>
  }

  inGras = {
    pics="inGras.xpm"

    <<
      var li, re;
    
      inGras={
        li = ??????1? || loc_x == 0;
        re = ??1????? || loc_x == 9;
        switch {
          li && re -> {pos=version + 1; *; pos=version+7; *@(0,1)};
          re -> {A*; G*@(0,1);};
          li -> {F*; L*@(0,1);};
          -> {
            [qu=Q_TL] A*;
            [qu=Q_BL] A*;
            [qu=Q_TL] G*@(0,1);
            [qu=Q_TR] F*;
            [qu=Q_BR] F*;
            [qu=Q_TR] L*@(0,1);
          };
        }
      };
    >>
  }

  silbergold = {
    pics = mgsSilberGold.xpm
    neighbours = 4
    numexplode = 4

    <<
      silbergold.init = {inhibit = DIR_UUL+DIR_LLD+DIR_DDR+DIR_RRU};

      silbergold = {
        *;
        B;
        if kind@(-1,2)==silbergold -> {qu=Q_TL; *@(0,1); qu=Q_BR; *@(-1,1);};
        if kind@( 2,1)==silbergold -> {qu=Q_BL; *@(1,0); qu=Q_TR; *@( 1,1);};
      };
    >>
  }

}

