# driver.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# $Id: driver.py,v 1.6 2005/11/28 04:07:28 mkennedy Exp $

import sys
import curses
import re
import signal
import time
import threading

import Yahoo
import Entry
import Session
import output
import cmdparser
import YahooMD5

def use_my_colors():
	curses.use_default_colors()
	curses.init_pair(0, -1, -1)
	curses.init_pair(1, 1, -1);
	curses.init_pair(2, 2, -1);
	curses.init_pair(3, 3, -1);
	curses.init_pair(4, 4, -1);
	curses.init_pair(5, 5, -1);
	curses.init_pair(6, 6, -1);
	curses.init_pair(7, -1, -1);

def go(stdscr, sess_arg):
	global sess, y
	global entry, chatwin, statusbar
	global pminrow
	t0 = time.time()
	t1 = t0

	pminrow = (curses.LINES - 2) * 19
	sess = sess_arg
	sess.time = time.strftime('%H:%M')

	y = Yahoo.Client(sess)
	sess.server = 'cs1.msg.dcn.yahoo.com'
	#sess.server = 'scs.msg.yahoo.com'
	y.connect(sess.server)
	y.write_message(type='challenge', user=sess.user)
	#y.write_message(type='login', user=sess.user, cookie=sess.cookie)

	# disable cntrl-c and other special chars
	#Edited by bow4IamTheBOFH -- comment the .raw() and add two lines
	#curses.raw()
	curses.noecho()
	curses.cbreak()
	#end edit

	use_my_colors()

	chatwin = create_chat_window()
	statusbar = create_status_bar(sess)
	entry = Entry.Entry()
	sr_thread = threading.Thread(target=y.chat)
	try:
		signal.signal(signal.SIGWINCH, win_size)
		sr_thread.start()
		msgp = None
		while sr_thread.isAlive():
			chatwin.noutrefresh(pminrow,0, 0,0, curses.LINES-3, curses.COLS)
			entry.show()
			curses.doupdate()
			maybe_update_clock()
			msg = y.read_message()
			while msg:
				if msg != msgp:
					hook(msg)
					if msg['type'] == 'logout':
						y.disconnect()
						sr_thread.join(1.0)
						break
					msgp = msg
				msg = y.read_message()
			s = entry.edit(sess.users, sess.ybuddies, sess.logoutusers, sess.cmd, sess.mycmd.keys(), [sess.pm_recipient])
			pminrow = get_scroll(pminrow)
			if pminrow == 9999:
				sr_thread.join(1.0)
				break
			if s:
				if re.match('^/(e|exit|bye) *$', s, re.I):
					still_on = 0
					y.disconnect()
					sr_thread.join(1.0)
					break
				else:
					cmdparser.do(s, y, sess, chatwin, statusbar)
	finally:
		sess.clean()
		sr_thread.join(1.0)
		y.disconnect()

def win_size(signum, frame):
	# some code should be here
	pass

def maybe_update_clock():
	time_now = time.strftime('%H:%M')
	if time_now != sess.time:
		sess.time = time_now
		output.status(statusbar, sess)
#		---------------CUT HERE---------------------		#
#Commented until deepcopy works. See output.py
#		if re.match('00:00',sess.time,re.I):
#			output.logrotate(sess.log)
#		---------------CUT HERE---------------------		#

def create_chat_window():
	win = curses.newpad(((curses.LINES-2)*20)+1, curses.COLS)
	win.idlok(1)
	win.scrollok(1)
	win.erase()
	win.move((curses.LINES-2)*19, 0)
	return win

def create_status_bar(sess):
	win = curses.newwin(1, curses.COLS, curses.LINES-2, 0)
	win.idlok(0)
	win.clearok(1)
	win.scrollok(0)
	win.bkgdset(ord(' '), curses.color_pair(sess.color['statusbar']) | curses.A_REVERSE)
	win.erase()
	win.noutrefresh()
	return win

def get_scroll(pmin):
	pud = entry.pp()
	if pud == 1:
		if pmin > 0:
			pmin = pmin - (curses.LINES-2)
	elif pud == -1:
		if pmin < ((curses.LINES-2)*19):
			pmin = pmin + (curses.LINES-2)
	elif pud == 999:
		chatwin.refresh(pminrow,0, 0,0, curses.LINES-3, curses.COLS)
		statusbar.clear()
		output.status(statusbar, sess)
	elif pud == 9999:
		pmin = 9999
	return pmin

def hook(msg):
	if msg['type'] == 'login':
		if not sess.login_ok:
			y.write_message(type='online', user=sess.user, sessionID=sess.sessionID)
			if msg['users']:
				sess.ybuddies.extend(msg['users'])
				msg['type'] = 'buddyisonline'
		elif msg['users']:
			msg['type'] = 'buddyisonline'
			if msg['users'][0] not in sess.ybuddies:
				sess.ybuddies.append(msg['users'][0])
			else:
				msg['type'] = 'crap'
	elif msg['type'] == 'buddyisoffline':
		if msg['user'] in sess.ybuddies:
			sess.ybuddies.remove(msg['user'])
		else:
			msg['type'] = 'crap'
	elif msg['type'] == 'online':
		sess.login_ok = 1
		y.write_message(type='join', user=sess.user, room=sess.room, sessionID=sess.sessionID)
		sess.userinfo[sess.user] = {}
		sess.userinfo[sess.user]['starttime'] = sess.time0
		sess.userinfo[sess.user]['commentcount'] = 0
		sess.userinfo[sess.user]['lastcomment'] = ''
		sess.userinfo[sess.user]['repeatcount'] = 0
	elif msg['type'] == 'challenge':
		sess.md5 = msg['md5']
		sess.sessionID = msg['sessionID']
		sess.md5key1, sess.md5key2 = YahooMD5.curphoo_process_auth(sess.user, sess.password, sess.md5)
		y.write_message(type='login', user=sess.user, key1=sess.md5key1, key2=sess.md5key2)
	elif msg['type'] == 'enter':
		add_user(sess, msg['user'])
		output.status(statusbar, sess)
	elif msg['type'] == 'join':
		now = time.time()
		# reset users list
		sess.users = []
		for user in msg['users']:
			add_user(sess, user, now)
		sess.room = msg['room']
		output.status(statusbar, sess)
	elif msg['type'] == 'exit':
		user = msg['user']
		if user in sess.users:
			sess.users.remove(user)
		# purge session userinfo
		if sess.userinfo.has_key(user):
			del sess.userinfo[user]

		sess.cache_logout_user(user)
		output.status(statusbar, sess)
	elif msg['type'] == 'pm':
		if not sess.pms_are_ok:
			if not (msg['user'].lower() in sess.buddies or msg['user'].lower() in sess.ybuddies):
				msg['type'] = 'crap'
	elif msg.has_key('text'):
		# append the the curphoo user list based on the user having
		# posted something (works around unreliable Yahoo! server-side
		# room lists)

		if msg.has_key('user'):
			add_user(sess, msg['user'])

		if not msg['text']:
			msg['type'] = 'crap'

		else:
			for e in sess.myregex:
				if re.search(e, msg['text'], re.I):
					msg['type'] = 'crap'
					#output.un_notice(chatwin, sess, msg['text'])
					#output.log(msg, sess.log)
					break


	if msg.has_key('user'):
		user = msg['user']
		if sess.ignores.has_key(user) or sess.mutes.has_key(user):
			msg['type'] = 'crap'
		else:
			if msg.has_key('text') and msg['text']:
				if not sess.userinfo.has_key(user):
					sess.userinfo[user] = {}
					sess.userinfo[user]['starttime'] = time.time()
					sess.userinfo[user]['commentcount'] = 0
					sess.userinfo[user]['lastcomment'] = ''
					sess.userinfo[user]['repeatcount'] = 0
					
				if sess.userinfo[user].has_key('commentcount'):
					sess.userinfo[user]['commentcount'] = sess.userinfo[user]['commentcount'] + 1
				else:
					sess.userinfo[user]['commentcount'] = 1
				if sess.userinfo[user]['lastcomment'].strip() == msg['text'].strip():
					sess.userinfo[user]['repeatcount'] = sess.userinfo[user]['repeatcount'] + 1
				sess.userinfo[user]['lastcomment'] = msg['text']
				x = re.search(r'(http://|ftp://|www)[^ ]+ ?', msg['text'])
				if x: sess.url = x.group()
		#		output.log(msg, sess.log)

		for u in sess.unregex:
			if re.search(u, user, re.I):
		#	if re.search(u, msg['user'], re.I):
				msg['type'] = 'crap'
		#		output.log(msg, sess.log, msg['text'])
		#		output.un_notice(chatwin, sess, user)

		for e in sess.excludes:
			if re.search(e, user, re.I):
		#	if re.search(u, msg['user'], re.I):
				msg['type'] = 'comment'
		#		output.log(msg, sess.log, msg['text'])
		#		output.un_notice(chatwin, sess, user)

		# for e in sess.excludes:
		# 	if sess.excludes.has_key(user):
		#	if re.search(u, msg['user'], re.I):
		# 		msg['type'] = 'comment'
		#		output.log(msg, sess.log)
		#		output.un_notice(chatwin, sess, user)

	# a quick hack to prevent 'crap' from seaping into output
	if msg['type'] != 'crap':
	#	autoignore(sess, msg)
		output.message(chatwin, msg, sess.user, sess)
		output.log(msg, sess.log)

def add_user(sess, user, timestamp = None):
	"Add user to session users list.  Use current time unless time is specified explicitly"
	if not timestamp:
		timestamp = time.time()
	if user not in sess.users:
		sess.users.append(user)
		sess.userinfo[user] = {}
		sess.userinfo[user]['starttime'] = timestamp
		sess.userinfo[user]['commentcount'] = 0
		sess.userinfo[user]['lastcomment'] = ''
		sess.userinfo[user]['repeatcount'] = 0

def autoignore(sess, msg):
	# filter crap
	if msg['type'] == 'crap':
		return None
	# filter non pertinent message
	if not (msg.has_key('user') and msg.has_key('text')):
		return None
	user = msg['user']
	text = msg['text']
	# code to ignore spambots
	if sess.rc['ignore-spambot'] == 'Y':
		autoignore_spambot(sess, msg, user, text)

def autoignore_spambot(sess, msg, user, text):
	if user in sess.excludes:
		return
	if int(sess.rc['ignore-spambot-length']) <= len(text) and int(sess.rc['ignore-spambot-seconds']) >= time.time() - sess.userinfo[user]['starttime'] and int(sess.rc['ignore-spambot-count']) >= sess.userinfo[user]['commentcount']:
		if re.search(sess.rc['ignore-spambot-string'], text, re.I):
			sess.ignores[user] = 1;
			output.autoignore_notice(chatwin, sess, user, 'spambot')
			if sess.rc['ignore-spambot-preignore'] == 'Y':
				msg['type'] = 'crap'
			return
