# Yahoo.py
# Copyright (C) 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: Yahoo.py,v 1.3 2005/11/27 20:52:46 mkennedy Exp $

import socket, sys, select, struct, time
import m9dec
import encodep
import threading
import babelizer

class Client:


	def __init__(self, sess):
		self.__socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		self.__rbuf = ''
		self.__wbuf = ''
		self.__wbufq = []
		self.ok = 0
		self.locket = threading.Lock()
		self.sess = sess
		self.ping_interval = 60			# send ping every 60 seconds (from GAIM)

	def connect(self, server):
		try:
			self.__socket.connect((server, 5050))
		except socket.error, e:
			sys.exit('connect failed: %s\n' % str(e))
		except socket.herror, e:
			sys.exit('connect failed: %s\n' % str(e))
		except socket.gaierror, e:
			sys.exit('connect failed: %s\n' % str(e))
		self.__socket.setblocking(0)
		self.ok = 1

	def disconnect(self):
		try:
			self.__socket.close()
		except:
			pass
		self.ok = 0
		return 1

	def __send(self):
		ok = 1
		self.locket.acquire()
		n = self.__socket.send(self.__wbuf)
		if n:
			self.__wbuf = self.__wbuf[n:]
		else:
			ok = 0
		self.locket.release()
		return ok

	def __recv(self):
		ok = 1
		self.locket.acquire()
		r = self.__socket.recv(1024)
		if r:
			self.__rbuf = '%s%s' % (self.__rbuf, r)
		else:
			ok = 0
		self.locket.release()
		return ok

	def chat(self):
		s = self.__socket
		slow = 0.750
		fast = 0.0125
		readwait = fast
		writewait = fast
		t1 = time.time()
		while self.ok:
			try:
				r, w, e = select.select([s], [], [], readwait)
				t2 = time.time()
				if t2 - t1 > self.ping_interval:
					t1 = t2
					# TODO make sure both service and chat ping types are sent
					self.write_message(
						type='ping',
						user=self.sess.user,
						sessionID=self.sess.sessionID)
				if s in r:
					self.__recv() or self.disconnect()
				else:
					if self.__wbuf:
						r, w, e = select.select([], [s], [], writewait)
						if s in w:
							self.__send() or self.disconnect()
							if len(self.__wbufq) > 2:
								readwait = slow
							else:
								readwait = fast
					# prepare the next packet
					else:
						if self.__wbufq:
							self.locket.acquire()
							self.__wbuf = self.__wbufq.pop(0)
							self.locket.release()
			except (socket.error, select.error):
				self.disconnect()
		return self.ok

	def read_message(self):
		hlen = 20 
		header = self.__rbuf[:hlen]
		if len(header) == hlen:
			u = struct.unpack('!4slhhll', header)
			plen = u[2] + hlen
			if len(self.__rbuf) >= plen:
				packet = self.__rbuf[:plen]
				self.locket.acquire()
				self.__rbuf = self.__rbuf[plen:]
				self.locket.release()
				return m9dec.do(packet, self.sess)

	def write_message(self, **keywords):
		self.locket.acquire()
		if self.__wbuf:
			self.__wbufq.append(encodep.do(keywords) or '')
		else:
			self.__wbuf = '%s%s' % (self.__wbuf, encodep.do(keywords) or '')
		self.locket.release()

