# m9dec.py
# Copyright (C) 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: m9dec.py,v 1.2 2005/11/27 20:52:46 mkennedy Exp $

import struct
from yahoodef import *
import cpformat
import string

TFROM = '%s%s' % (
						''.join([chr(x) for x in range(0x00, 0x20)]),
						''.join([chr(x) for x in range(0x7f, 0xff)])  )
TTO = '#'*len(TFROM)
TTABLE = string.maketrans(TFROM, TTO)
tr = lambda s: s.translate(TTABLE)

def list2dict(l):
	d = {}
	m = l[:]
	while m:
		k = m.pop(0)
		if m:
			d[k] = m.pop(0)
	return d

def do(packet, sess = None):
	packet_type = struct.unpack('!h', packet[10:12])[0]
	sessionID = struct.unpack('!l', packet[16:20])[0]
	#flag = struct.unpack('!l', packet[12:16])[0]
	flag = struct.unpack('!h', packet[12:14])[0]
	payload = packet[20:]
	data = payload.split("\xC0\x80")
	datadict = list2dict(data)

	#if flag not in (0x01, 0x00, 0x05): return {
		#"type": "crap"
	#}
	if flag: return {
		'type': 'unknownoff',
		'text': '-CRAP- [code %x]  %s' % (packet_type, datadict)
	}

	elif packet_type == 0x57: return {
		"type": "challenge",
		"user": datadict['1'],
		"md5": datadict['94'],
		"sessionID": sessionID
	}

	elif packet_type == 0x02 and datadict.has_key('7'): return {
		"type": "buddyisoffline",
		"user": datadict['7']
	}

	elif packet_type == 0x01:
		datac = data[:]
		onlinebuds = []
		while datac:
			if datac.pop(0) == '7' and datac:
				onlinebuds.append(datac.pop(0))
		return {
			"type": "login",
			"account": datadict['0'],
			"user": datadict.get('1', datadict['0']),
			"users": onlinebuds
		}

	elif packet_type == 0x98 and datadict.has_key('128'):
		users = []
		while data:
			if data.pop(0) == "109" and data:
				users.append(data.pop(0))
		return {
			"type": "join",
			"room": datadict.get('104', 'No Room'),
			"topic": datadict.get('105', 'No Topic'),
			"users": users
		}

	elif packet_type == 0x98 and datadict.has_key('104') and datadict.has_key('109'): return {
		"type": "enter",
		"room": datadict['104'],
		"user": datadict['109']
	}

	elif packet_type == 0x9b: return {
		"type": "exit",
		"room": datadict['104'],
		"user": datadict['109']
	}

	elif packet_type == 0xa8:
		if datadict['124'] == "1": return {
			"type": "comment",
			"user": datadict['109'],
			"text": cpformat.do(datadict['117'], sess)
		}
		else: return {
			'type': 'emote',
			"user": datadict['109'],
			"text": cpformat.do(datadict['117'], sess)
		}
			
	elif packet_type == 0x06: return {
		"type": "pm",
		"user": datadict.has_key('4') and datadict['4'] or datadict.has_key('1') and datadict['1'] or "Parse Error (PM)",
		"text": datadict.has_key('14') and cpformat.do(datadict['14'], sess) or "Parse Error (PM)"
	}

	elif packet_type == 0x0b: return {
		"type": "mail",
		"num": datadict.get('9'),
		"sender": datadict.get('43'),
		"address": datadict.get('42'),
		"subject": datadict.get('18')
	}

	elif packet_type == 0xa0: return {
		"type": "logout"
	}

	elif packet_type == 0x20: return {
		"type": "pm",
		"user": datadict.has_key('4') and datadict['4'] or datadict.has_key('1') and datadict['1'] or "Parse Error (PM)",
		"text": datadict.has_key('14') and datadict['14'] or "Parse Error (PM)"
	}
		
	elif packet_type == 0x96: return {
		"type": "online"
	}

	elif packet_type == 0x03 and datadict.has_key('7') and datadict.has_key('10'): return {
		"type": "away",
		"user": datadict['7'],
		"text": datadict['10'] == '1' and 'Be Right Back' or
		datadict['10'] == '2' and 'Busy' or
		datadict['10'] == '2' and 'Not At Home' or
		datadict['10'] == '2' and 'Not At My Desk' or
		datadict['10'] == '2' and 'Not In The Office' or
		datadict['10'] == '2' and 'On The Phone' or
		datadict['10'] == '2' and 'On Vacation' or
		datadict['10'] == '2' and 'Out To Lunch' or
		datadict['10'] == '2' and 'Stepped Out' or
		datadict['10'] == '11' and 'Auto-Away' or
		datadict['10'] == '99' and datadict.get('19', 'Custom Away')
	}

	elif packet_type == 0x04 and datadict.has_key('7'): return {
		"type": "back",
		"user": datadict['7']
	}

	else: return {
		'type': 'unknownoff',
		'text': '[code %x]  %s' % (packet_type, datadict)
	}

