# cmdparser.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: cmdparser.py,v 1.9 2006/01/02 11:04:56 mkennedy Exp $
##


import re
import curses
import time
import string
import urllib
import webbrowser

import output
import shexec
import Session
import cmdhelp
import babelizer

AWAY_MSG = "JuGgLiNg"

# I will be kicking ass if adhoc releases cause our users confusion (matt)

PLUG_MSG = "is using Curphoo 0.4.1 http://savannah.nongnu.org/projects/curphoo/"

def btk(cli, sess, statusbar):
	if sess.afk:
		sess.afk = 0
		cli.write_message(type='back')
		output.status(statusbar, sess)

def do(cmd, cli, sess, chatwin, statusbar):
	"I don't want to have to tell you twice. Do what you're told Damn It!"
	# clean up after zombies
	shexec.clean_up(sess.pids)
	# I could've had functions here to break it down a little
	# bit but in the end for some funny reason I chose not to.
	# Enjoy!

	# COMMENTS
	if re.match(r'^[^/:!\\ ].*$', cmd, re.I):
		# this should match the majority of comments.
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=cmd, sessionID=sess.sessionID)
		# chatwin.addstr("cmd:%s" % cmd)
		# if chatwin.getyx()[1]: chatwin.addstr('\n')
		output.mycomment(chatwin, sess, cmd)

	# QUIT 
	elif re.match('^/q(uit)? *$', cmd, re.I):
		if sess.sessionID:
			cli.write_message(type='logout', user=sess.user, sessionID=sess.sessionID)

	# GOT SOMETHING TO SAY BEFORE YOU QUIT?
	elif re.match('^/q(uit)? +?[^ ].*$', cmd, re.I):
		quit_msg = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=quit_msg, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, quit_msg)
		cli.write_message(type='logout', user=sess.user, sessionID=sess.sessionID)

	# EMOTES
	elif re.match('^:.*?[^ ].*$', cmd, re.I):
		myemote = cmd[1:].strip()
		smiley = myemote.split()
		if smiley and ':%s'%smiley[0] in [":)", ":-)", ":(", ":-(", ":D", ":-D", ":-/", ":-\\", ":x", ":-x", ":X", ":-X", ":p", ":-p", ":P", ":-P", ":O", ":-O", ":>", ":->", ":((", ":-((", ":))", ":-))", ":|", ":-|", ":B", ":-B", ":-&", ":-$", ":o)", ":0)", ":O)", ":@)", ":(|)"]:
			cli.write_message(type='comment', user=sess.user, room=sess.room, text=':%s'%myemote, sessionID=sess.sessionID)
			output.mycomment(chatwin, sess, ':%s'%myemote)
		else:
			cli.write_message(type='emote', user=sess.user, room=sess.room, text=myemote, sessionID=sess.sessionID)
			output.myemote(chatwin, sess, myemote)


	elif re.match('^/me *?[^ ].*$', cmd, re.I):
		msg = cmd.split(' ',1).pop().strip()
		cli.write_message(type='emote', user=sess.user, room=sess.room, text=msg, sessionID=sess.sessionID)
		output.myemote(chatwin, sess, msg)

	# CLEAR CHAT WINDOW
	elif re.match('^/cl(ear|s) *$', cmd, re.I):
		chatwin.clear()
		chatwin.move((curses.LINES -2) * 19, 0)

	# WELL.. WELL.. LOOK WHO's HERE
	elif re.match('(^/u(sers)? *$|^/$)', cmd, re.I):
		output.list_currentusers(chatwin, sess, sess.users, sess.color['userlist'], 'Users')

	# JOIN ROOMS
	elif re.match('^/j(oin)? +?[^ ].*$', cmd, re.I):
		chat_room = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='join', user=sess.user, sessionID=sess.sessionID, room=chat_room)

	# THINK OUT LOUD
	elif re.match('^/t(hink)? +?[^ ].*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='emote', user=sess.user, room=sess.room, text=". o O ( %s )"%thought, sessionID=sess.sessionID)
		#cli.write_message(type='thought', user=sess.user, room=sess.room, text=". o O ( %s )"%thought, sessionID=sess.sessionID)
		output.myemote(chatwin, sess, '. o O ( %s )'%thought)
		#cli.write_message(type='thought', text=thought)

	# STOP BITCHING ABOUT THE NON-FUNCTIONAL BACKSPACE DAMN IT!
	elif re.match('^/t(hink)? *$', cmd, re.I):
		cli.write_message(type='emote',
				text=". o O ( wtf is ^H: Gee...  I don't know what ^H means... )",
				user=sess.user, room=sess.room, sessionID=sess.sessionID)
		output.myemote(chatwin, sess, ". o O ( wtf is ^H: Gee... I don't know what ^H means... )")

	# *DYING*
	elif re.match('^/d(ying)? +[^ ].*$', cmd, re.I):
		dead_stuff = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='comment', user=sess.user, room=sess.room, text='%s is *dying*' % dead_stuff, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, "%s is *dying*"%dead_stuff)

	elif re.match('^/up(time)? *$', cmd, re.I):
		u = time.time() - sess.time0
		u = int(u)
		days = u / (60*60*24)
		u = u % (60*60*24)
		hours = u / (60*60)
		u = u % (60*60)
		minutes = u / (60)
		seconds = u % 60
		msg = "my chat client is up"
		if days:
			msg = "%s %s %s" % (msg, days, days > 1 and 'days,' or 'day,')
		msg = "%s %02d:%02d.%02d" % (msg, hours, minutes, seconds)
		#msg = "%s because i'm kick ass and i need my chat client to be kick ass with me (heh.)" % (msg)
		msg = "%s because I kick ass!" % (msg)
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=msg, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, msg)

	# LIST ALL REGEXES ON IGNORE
	elif re.match('^/r(e|egex)? *$', cmd, re.I):
		output.list_regex(chatwin, sess, sess.myregex, sess.color['ignorelist'], 'List of regex ignores.')

	# APPEND A REGEX TO THE LIST
	elif re.match('^/r(e|egex)? +[^ ].*', cmd, re.I):
		regex = cmd.split(' ',1).pop().strip()
		if regex in sess.myregex:
			#output.ignore_notice(chatwin, "RegEx "+regex, sess.color['ignoreoffnotice'], 0)
			output.ignore_notice(chatwin, sess, "RegEx "+regex, 0)
			sess.myregex.remove(regex)
		else:
			#output.ignore_notice(chatwin, "RegEx "+regex, sess.color['ignoreonnotice'])
			output.ignore_notice(chatwin, sess, "RegEx "+regex, 1)
			sess.myregex.append(regex)

	#sl4ckw4re_syst3m strikes again
	# APPEND A BABEL TO THE LIST
	elif re.match('^/tr(anslate)? +[^ ].*', cmd, re.I):
		regex = cmd.split(' ',1).pop().strip()
		if regex in sess.babellist:
			output.translate_notice(chatwin, sess, "User "+regex, 0)
			sess.babellist.remove(regex)
		else:
			output.translate_notice(chatwin, sess, "User "+regex, 1)
			sess.babellist.append(regex)

	#sl4ckw4re_syst3m - change default base language for translation
	elif re.match('^/babel_from? +[^ ].*', cmd, re.I):
		regex = cmd.split(' ',1).pop().strip()
		sess.babellang_from = regex;
	
	#sl4ckw4re_syst3m - change default 'to' language for translation
	elif re.match('^/babel_to? +[^ ].*', cmd, re.I):
		regex = cmd.split(' ',1).pop().strip()
		sess.babellang_to = regex;
	

	# GIVE USER INFO
	elif re.match('^/ui(nfo)? +[^ ].*$', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if user:
			output.user_info(chatwin, sess, user)
		else:
			output.user_info(chatwin. sess. sess.user)

	# COLOR INFO
	elif re.match('^/col(o|ou)r(s)? *$', cmd, re.I):
		output.list_color(chatwin, sess)

	# COLOR COMMANDS
	elif re.match('^/col(o|ou)r(s)? +[^ ].*$', cmd, re.I):
		tokens = re.split('\s+', cmd)[1:]
		command = tokens[0]
		params = tokens[1:]
		if re.match('(re)?load', command, re.I) and len(params) == 0:
			sess.load_color()
			output.notify(chatwin, sess, 'color profile loaded')
			output.status(statusbar, sess)
		elif command.lower() == 'save' and len(params) == 0:
			sess.save_color()
			output.notify(chatwin, sess, 'color profile saved')
		elif command.lower() == 'set':
			if params[0] in sess.color.keys():
				if params[1].upper() in sess.colorrevmap:
					sess.set_color(params[0], params[1])
					output.notify(chatwin, sess, 'color profile %s set to %s' % (params[0], params[1].upper()))
					if params[0] == 'statusbar':
						output.status(statusbar, sess)
				else:
					output.error(chatwin, sess, 'unknown color \'%s\'' % params[1])
			else:
				output.error(chatwin, sess, 'unknown color profile name \'%s\'' % params[0])

	# GIVE A BUDDY PM PRIVILEGES
	elif re.match('^/b(uddy)? +?[^ ].*$', cmd, re.I):
		user = cmd.split(' ', 1).pop().strip().lower()
		if user in sess.buddies: 
			sess.buddies.remove(user)
			output.pm_notice(chatwin, sess, user, 0)
		else:
			sess.buddies.append(user)
			output.pm_notice(chatwin, sess, user)
		output.status(statusbar, sess)

	elif re.match('^/yb(uddy)? +?[^ ].*$', cmd, re.I):
		user = cmd.split(' ', 1).pop().strip().lower()
		if user not in (sess.ybuddies):
			cli.write_message(type='addbuddy', user=sess.user, friend=user, sessionID=sess.sessionID)
			sess.ybuddies.append(user)
			output.buddy_notice(chatwin, sess, user)

	# LIST ALL CHATTERS WITH PM PRIVILEGES
	elif re.match('^/b(uddy)? *$', cmd, re.I):
		output.list_buddies(chatwin, sess, sess.buddies, sess.color['buddylist'], 'List of buddies')

	elif re.match('^/yb(uddy)? *$', cmd, re.I):
		output.list_buddies(chatwin, sess, sess.ybuddies, sess.color['buddylist'], 'List of ybuddies')

	elif re.match('^/pm *$', cmd, re.I):
		if sess.pms_are_ok:
			sess.pms_are_ok = 0
			output.pm_status(chatwin, sess, 'Accepting private messages from friends')
		else:
			sess.pms_are_ok = 1
			output.pm_status(chatwin, sess, 'Accepting all private messages', 0)

	# HIGLIGHT A CHATTER's COMMENTS ONLY COS YOU LOVE HIM/HER SO MUCH
	elif re.match('^/h(ilite-user|u) +?[^ ].*$', cmd, re.I):
		user = cmd.split(' ', 1).pop().strip().lower()
		if user in sess.high: 
			sess.high.remove(user);
			output.hi_notice(chatwin, sess, user, 0)
		else:
			sess.high.append(user);
			output.hi_notice(chatwin, sess, user)

	# CHECK OUT WHO WE HAVE HIGHLIGHTED
	elif re.search('^/h(ilight-user|u) *$', cmd, re.I):
		output.list_highlightusers(chatwin, sess, sess.high, sess.color['hulist'], 'List of users to highlight')

	# HIGHLIGHT COMMENTS CONTAINING A PARTICULAR STRING
	elif re.match('^/h(ilite-string|s) +?[^ ].*$', cmd, re.I):
		string = cmd.split().pop().strip().lower()
		if string in sess.highstr:
			# remove string from highlighted string list
			sess.highstr.remove(string)
			output.histr_notice(chatwin, sess, string, 0)
		else:
			# add string to highlighted string list
			sess.highstr.append(string)
			output.histr_notice(chatwin, sess, string)

	# HMM.. I WONDER WHAT STRINGS WE HIGHLIGHT
	elif re.search('^/h(ilight-string|s) *$', cmd, re.I):
		output.list_highliststring(chatwin, sess.highstr, sess.color['hslist'], 'List of strings to highlight')

	# QUIETLY IGNORE ANNOYING CHATTERS
	elif re.match('^/i(g|gnore)? +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if sess.ignores.has_key(user):
			# unignore user
			del sess.ignores[user]
			output.ignore_notice(chatwin, sess, user, 0)
		else:
			# ignore user
			sess.ignores[user] = 1
			output.ignore_notice(chatwin, sess, user)
		output.status(statusbar, sess)

	# IGNORE SEVERAL ANNOYING CHATTERS IN ONE COMMAND
	elif re.match(r'^/i(gnore)?\* +[^ ].*', cmd, re.I):
		users = cmd.split(' ',1).pop().strip()
		users = [e.lower() for e in users.split()]
		for e in users:
			if sess.ignores.has_key(e):
				# unignore user
				output.ignore_notice(chatwin, sess, e[:-1], 0)
			else:
				# ignore user
				sess.ignores[e] = 1
				output.ignore_notice(chatwin, sess, e[:-1])
			output.status(statusbar, sess)

	# NOTIFY THE ROOM THAT YOU'RE IGNORING SOMEONE
	elif re.match('^/i(g|gnore)?v +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if sess.ignores.has_key(user):
			# unignore user
			del sess.ignores[user]
			output.ignore_notice(chatwin, sess, user, 0)
		else:
			# ignore user
			sess.ignores[user] = 1
			iggy_comment = sess.ignoremsg % user
			cli.write_message(type='comment', user=sess.user, room=sess.room, text=iggy_comment, sessionID=sess.sessionID)
			output.mycomment(chatwin, sess, text=iggy_comment)
		output.status(statusbar, sess)

	# LIST ALL USERS ON IGNORE
	elif re.match('^/i(g|gnore)? *$', cmd, re.I):
		ignores = []  # ignored users in current room
		for user in sess.users:
			if sess.ignores.has_key(user):
				ignores.append(user)
		output.list_ignoredusers(chatwin, sess, ignores, sess.color['ignorelist'], 'List of users on ignore')

	# MUTE USER - temporarily ignore a user for the duration of current session
	elif re.match('^/mute +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if sess.mutes.has_key(user):
			del sess.mutes[user]
			output.mute_notice(chatwin, sess, user, 0)
		else:
			sess.mutes[user] = 1
			output.mute_notice(chatwin, sess, user)
		output.status(statusbar, sess)

	# SHOW EXCLUDE LIST
	elif re.match('^/(ex|exclude) +', cmd, re.I):
		output.list_excludeusers(chatwin, sess, excludes, sess.color['excludelist'], 'List of users on excluded from auto-ignore')

	# HANDLE EXCLUDE COMMAND
	elif re.match('^/(ex|exclude) +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if user in sess.excludes:
			del sess.exclude[user]
			output.exclude_notice(chatwin, sess, user, 0)
		else:
			sess.exclude[user] = 1
			output.exclude_notice(chatwin, sess, user)
		output.status(statusbar, sess)

	# SHOW SETTINGS
	elif re.match('^/se(t)?$', cmd, re.I):
		output.list_rc(chatwin, sess)

	# HANDLE SET COMMAND
	# set command allows modification of values in ~/.curphoo/curphoorc file
	elif re.match('^/se(t)? +[^ ].*', cmd, re.I):
		tokens = re.split('\s+', cmd)[1:]
		key = tokens[0]
		if len(tokens) == 1:
			output.error(chatwin, sess, 'parameter value not specified')
		else:
			value = tokens[1]
			if sess.rc.has_key(key):
				sess.rc[key] = value;
			else:
				output.error(chatwin, sess, 'unknown parameter name: \'%s\'' % key)

	# PROMOTE CURPHOO
	elif re.match('/v(er|ersion)? *$', cmd, re.I):
		cli.write_message(type='emote', user=sess.user, room=sess.room, text=PLUG_MSG, sessionID=sess.sessionID)
		output.myemote(chatwin, sess, PLUG_MSG)

	# SH FU w/out SENDING TO CHAT
	elif re.match(r'^[!][!] *?[^ ].*$', cmd, re.I):
		shc = cmd[2:].strip()
		bufsize = 512 - len(shc) - 4
		res = shexec.do(shc, bufsize, sess.pids)
		output.shellcommand(chatwin, sess, '%s:\n%s' % (shc, res))

	# IMPRESS YOUR FRIENDS W/ SOME SH FU
	#elif re.match(r'^[!][^!]+?[^ ].*$', cmd, re.I):
	elif re.match(r'^[!].+$', cmd, re.I):
		shc = cmd[1:].strip()
		if shc:
			bufsize = 512 - len(shc) - 4
			res = '%s:\n%s' % (shc, shexec.do(shc, bufsize, sess.pids))
			cli.write_message(type='comment', user=sess.user, room=sess.room, text=res, sessionID=sess.sessionID)
			output.mycomment(chatwin, sess, res)

	# THE WHOLE WORLD's JUST GOTTA KNOW YOUR BACK
	elif re.match('^/back *$', cmd, re.I):
		cli.write_message(type='back', sessionID=sess.sessionID)
		cli.write_message(type='emote', user=sess.user, room=sess.room, text="is back", sessionID=sess.sessionID)
		output.myemote(chatwin, sess, "is back")
		sess.afk = 0
		output.status(statusbar, sess)

	# FOR SOME REASON YOU'RE AFK
	elif re.match('^/a(way)? +?[^ ].*$', cmd, re.I):
		away_msg = cmd[len('/away '):].strip()
		away_msg = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='away', text=away_msg, sessionID=sess.sessionID)
		cli.write_message(type='emote', user=sess.user, room=sess.room, text="is away (%s)"%away_msg, sessionID=sess.sessionID)
		output.myemote(chatwin, sess, "is away (%s)"%away_msg)
		sess.afk = 1
		output.status(statusbar, sess)

	elif re.match('^/a(way)? *$', cmd, re.I):
		if sess.afk:
			cli.write_message(type='back', sessionID=sess.sessionID)
			cli.write_message(type='emote', user=sess.user, room=sess.room, text="is back", sessionID=sess.sessionID)
			output.myemote(chatwin, sess, "is back")
			sess.afk = 0
		else:
			cli.write_message(type='away', text=AWAY_MSG, sessionID=sess.sessionID)
			cli.write_message(type='emote', user=sess.user, room=sess.room, text="is away (%s)"%AWAY_MSG, sessionID=sess.sessionID)
			output.myemote(chatwin, sess, "is away (%s)"%AWAY_MSG)
			sess.afk = 1
		output.status(statusbar, sess)

	# TELL YOUR GIRLFRIEND STUFF IN PRIVATE
	elif re.match('^/(m(sg)?|tell) *?[^ ]+? +?[^ ].*$', cmd, re.I):
		user_msg = cmd.split(' ',1).pop().strip()
		u = user_msg.split(' ',1).pop(0)
		sess.pm_recipient = u
		m = user_msg.split(' ',1).pop().strip()
		if m.startswith('!'):
			shc = m[1:].strip()
			if shc:
				res = shexec.do(shc, 512 - len(shc) - 2, sess.pids)
				cli.write_message(type='pm', user=sess.user, text='%s:\n%s' % (shc, res), otheruser=u, sessionID=sess.sessionID)
				output.pm_user(chatwin, sess, u, '%s:\n%s' % (shc, res))
			else:
				cli.write_message(type='pm', user=sess.user, text='!', otheruser=u, sessionID=sess.sessionID)
				output.pm_user(chatwin, sess, u, '!')
		else:
			cli.write_message(type='pm', user=sess.user, text=m, otheruser=u, sessionID=sess.sessionID)
			output.pm_user(chatwin, sess, u, m)

	# FOLLOW A USER
	elif re.match('^/goto +?[^ ].*$', cmd, re.I):
		u = cmd.split(' ',1).pop().strip()
		cli.write_message(type='goto', user=sess.user, otheruser=u, sessionID=sess.sessionID)

	# open urls from chat in a web browser
	elif re.match(r'^/openurl *$', cmd, re.I):
		if sess.url:
			try:
				webbrowser.open(sess.url, new=1, autoraise=0)
				output.blah(chatwin, sess, 'opening %s' % sess.url)
			except:
				output.blah(chatwin, sess, 'failed to open browser')
			output.status(statusbar, sess)

	# open url from the input box in a web browser
	elif re.match(r'^/openurl *?[^ ].*$', cmd, re.I):
		url = cmd.split(' ',1).pop().strip()
		try:
			output.blah(chatwin, sess, 'opening %s' % url)
			webbrowser.open(url, new=1, autoraise=0)
		except:
			output.blah(chatwin, sess, 'failed to open browser')
		output.status(statusbar, sess)

	# open user's profile page in a web browser
	elif re.match(r'^/openprofile *?[^ ].*$', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		url = sess.profileurl + urllib.quote(user)
		try:
			output.blah(chatwin, sess, 'opening %s' % url)
			webbrowser.open(url, new=1, autoraise=0)
		except:
			output.blah(chatwin, sess, 'failed to open browser')
		output.status(statusbar, sess)

	elif re.match(r'^/load +?[^ ].*$', cmd, re.I):
		param = cmd.split(' ',1).pop().strip()
		if param.lower() == 'color':
			sess.load_color();
			output.notify(chatwin, sess, 'color profile loaded')
		if param.lower() == 'command' or param.lower() == 'commands':
			sess.load_mycmd();
			output.notify(chatwin, sess, 'command list loaded')
		if param.lower() == 'exclude' or param.lower() == 'excludes':
			sess.load_exclude();
			output.notify(chatwin, sess, 'exclude list loaded')
		if param.lower() == 'ignore':
			sess.load_ignores();
			output.notify(chatwin, sess, 'ignore list loaded')
		if param.lower() == 'ignoremsg':
			sess.load_ignoremsg();
			output.notify(chatwin, sess, 'ignore message loaded')
		if param.lower() == 'rc':
			sess.load_rc();
			output.notify(chatwin, sess, 'curphoorc file loaded')
		if param.lower() == 'regex':
			sess.load_myregex();
			output.notify(chatwin, sess, 'regex ignore file loaded')

	elif re.match(r'^/save +?[^ ].*$', cmd, re.I):
		param = cmd.split(' ',1).pop().strip()
		if param.lower() == 'color':
			sess.save_color();
			output.notify(chatwin, sess, 'color profile saved')
		if param.lower() == 'exclude' or param.lower() == 'excludes':
			sess.save_exclude();
			output.notify(chatwin, sess, 'exclude list saved')
		if param.lower() == 'ignore' or param.lower() == 'ignores':
			sess.save_ignores();
			output.notify(chatwin, sess, 'ignore list saved')
		if param.lower() == 'rc':
			sess.save_rc();
			output.notify(chatwin, sess, 'runtime configuration saved')
		if param.lower() == 'regex':
			sess.save_myregex();
			output.notify(chatwin, sess, 'regex ignore file saved')

   	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* automagicl337sp33k 
	elif re.match(r'^/h(a)?x(or)? +[^ ].*$', cmd, re.I):
		e1337 = cmd.split(' ', 1).pop().strip()
		e1337 = e1337.lower()
		e1337 = e1337.replace("a", "4")
		e1337 = e1337.replace("A", "@")
		e1337 = e1337.replace("t", "+")
		e1337 = e1337.replace("o", "0")
		e1337 = e1337.replace("x", "><")
		e1337 = e1337.replace("e", "3")
		e1337 = e1337.replace("s", "5")
		e1337 = e1337.replace("n", "N")
		e1337 = e1337.replace("m", "M")
		e1337 = e1337.replace("l", "|")
		e1337 = e1337.replace("w", "\/\/")
		e1337 = e1337.replace("i", "i")
		e1337 = e1337.replace("u", "U")
		e1337 = e1337.replace("f", "F")
		e1337 = e1337.replace("c", "(")
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=e1337, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, e1337)
								

   	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* english->french translation via babelfish
	elif re.match(r'^/fr(ench)? .*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		thought = thought.replace("`", "\`")
		thought = thought.replace("\"", "\\\"")
		thought = thought.replace("'", "\'")
		try:
        		shc =  babelizer.translate( thought, "English", "French" )
		except:
        		return
		bufsize = 0x549 - len(shc) - 4
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=shc, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, shc)

	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* english->german translation via babelfish
	elif re.match(r'^/ge(rman)? .*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		thought = thought.replace("`", "\`")
		thought = thought.replace("\"", "\\\"")
		thought = thought.replace("'", "\'")
		try:
        		shc =  babelizer.translate( thought, "English", "German" )
		except:
        		return
		bufsize = 0x549 - len(shc) - 4
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=shc, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, shc)

	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* english->spanish translation via babelfish
	elif re.match(r'^/sp(anish)? .*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		thought = thought.replace("`", "\`")
		thought = thought.replace("\"", "\\\"")
		thought = thought.replace("'", "\'")
		try:
        		shc =  babelizer.translate( thought, "English", "Spanish" )
		except:
        		return
		bufsize = 0x549 - len(shc) - 4
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=shc, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, shc)

	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* english->italian translation via babelfish
	elif re.match(r'^/it(alian)? .*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		thought = thought.replace("`", "\`")
		thought = thought.replace("\"", "\\\"")
		thought = thought.replace("'", "\'")
		try:
        		shc =  babelizer.translate( thought, "English", "Italian" )
		except:
        		return
		bufsize = 0x549 - len(shc) - 4
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=shc, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, shc)

	# *sl4ckw4re_syst3m slack@hackermail.com w0z h3r3* english->portugese translation via babelfish
	elif re.match(r'^/po(rtugese)? .*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		thought = thought.replace("`", "\`")
		thought = thought.replace("\"", "\\\"")
		thought = thought.replace("'", "\'")
		try:
        		shc =  babelizer.translate( thought, "English", "Portugese" )
		except:
        		return
		bufsize = 0x549 - len(shc) - 4
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=shc, sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, shc)


	#elif re.match(r'/help +?(/?join|/?quit|/?ignore\*?|/?buddy|/?ybuddy|/|/?tell|/?hs|/?hu|/?uptime|/?ver|[!]|[!][!]|:)$', cmd, re.I):
	# Thanks Matt Dunford <zoot@zotikos.com> for your work on cmdhelp.py :))
	elif re.match(r'^/help +?[/A-Za-z*!|]+', cmd, re.I):
		help_str = cmd.split(' ',1).pop().strip().lower()
		#output.help(chatwin, sess.color['help'], cmdhelp.helpd[help_str])
		if cmdhelp.helpd.has_key(help_str):
			output.help(chatwin, sess, cmdhelp.helpd[help_str])
		else:
			output.help(chatwin, sess, 'No help for '+help_str)

	elif re.match('^/help *$', cmd, re.I):
		output.help(chatwin, sess, cmdhelp.help)

	elif cmd[0] == '/' and cmd[1:].strip() and cmd.strip().split(' ',1).pop(0)[1:].lower() in sess.mycmd.keys():
		pair = cmd.strip().split(' ',1)
		k = pair.pop(0).strip()[1:].lower()
		k = k.lower()
		if sess.mycmd[k][0] == 'comment':
			if pair:
				v = pair.pop(0)
				s = sess.mycmd[k][1].replace('%s', v)
			else:
				s = sess.mycmd[k][1]
			cli.write_message(type='comment', user=sess.user, room=sess.room, text=s, sessionID=sess.sessionID)
			output.mycomment(chatwin, sess, s)
		elif sess.mycmd[k][0] == 'emote':
			if pair:
				v = pair.pop(0)
				s = sess.mycmd[k][1].replace('%s', v)
			else:
				s = sess.mycmd[k][1]
			cli.write_message(type='emote', user=sess.user, room=sess.room, text=s, sessionID=sess.sessionID)
			output.myemote(chatwin, sess, s)
		elif sess.mycmd[k][0] == 'filter':
			if pair:
				v = pair.pop(0)
				shc = sess.mycmd[k][1].replace('%s', v)
				bufsize = 510
				res = shexec.do(shc, bufsize, sess.pids)
				cli.write_message(type='comment', user=sess.user, room=sess.room, text=res, sessionID=sess.sessionID)
				output.mycomment(chatwin, sess, res)
		elif sess.mycmd[k][0] == 'exec o':
			if pair:
				v = pair.pop(0)
				shc = sess.mycmd[k][1].replace('%s', v)
				bufsize = 512 - len(k) - 5 - len(v)
				res = '%s %s:\n%s' % (k, v, shexec.do(shc, bufsize, sess.pids))
			else:
				shc = sess.mycmd[k][1]
				bufsize = 512 - len(k) - 4
				res = '%s:\n%s' % (k, shexec.do(shc, bufsize, sess.pids))
			cli.write_message(type='comment', user=sess.user, room=sess.room, text=res, sessionID=sess.sessionID)
			output.mycomment(chatwin, sess, res)

	elif re.match(r'^\\.*?[^ ].*$', cmd):
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=cmd[1:].strip(), sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, cmd[1:].strip())

	elif re.match(r'^/.*$', cmd):
		output.error(chatwin, sess, "Unknown Command")

	elif re.match(r'^ *?[^ ].*$', cmd):
		cli.write_message(type='comment', user=sess.user, room=sess.room, text=cmd.strip(), sessionID=sess.sessionID)
		output.mycomment(chatwin, sess, cmd.strip())

                                                                                
