# Session.py
# Copyright (C) 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import getpass
import sys
import urllib
import clopt
import pickle
import socket
import time

CPDIR = os.path.join(os.environ['HOME'], '.curphoo')
CPRC = os.path.join(CPDIR, 'curphoorc')
CPBUDDIES = os.path.join(CPDIR, 'buds')
CPIGNORES = os.path.join(CPDIR, 'ignorex')
CPLOG = os.path.join(CPDIR, 'log')
CPMYCMDS = os.path.join(CPDIR, 'commands')
CPMYREGEX = os.path.join(CPDIR, 'regex')

class Session:


	def __init__(self):
		self.user = ''
		self.alias = []
		self.cookie = ''
		self.password = ''
		self.afk = 0
		self.server = 'jcs4.chat.dcn.yahoo.com'
		self.room = 'Linux, FreeBSD, Solaris:1'
		self.url = 'http://www.waduck.com/~curphoo/'
		self.users = []
		self.high = []
		self.highstr = []
		self.buddies = []
		self.ignores = []
		self.mycmd = {}
		self.myregex = []
		self.cmd = ['JOIN ', 'QUIT ', 'TELL ', 'IGNORE ', 'BUDDY ', 'USERS ', 'AWAY ', 'GOTO ', 'VER', 'UPTIME', 'OPENURL '] 
		self.pids = []
		self.log = None
		self.time0 = time.time()
		self.reconnect = 1
		self.show_user_list = 1
		self.load_rc() # init members with curphoorc
		self.load_opts() # init members with command line switches
		if not self.user: self.user= raw_input('Username: ')
		if not self.password:
			try:
				self.setcookie() # app exits here if this fails
			except:
				sys.exit('ERROR: setcookie failed')
			rep = raw_input("Save profile to curphoorc? [Y/n]: ")[:1].lower()
			if rep in ('', 'y'):
				self.save_rc()
		try:
			self.setcookie() # app exits here if this fails
		except:
			sys.exit('ERROR2: setcookie failed')
		self.load_buds()
		self.load_ignores()
		self.load_mycmd()
		self.load_myregex()
		
	def load_myregex(self):
		if os.access(CPMYREGEX, os.R_OK):
			f = open(CPMYREGEX, 'r')
			while 1:
				s = f.readline()
				if not s:
					break
				else:
					r = s.rstrip()
					if r:
						self.myregex.append(r)
			f.close()

	def load_mycmd(self):
		if os.access(CPMYCMDS, os.R_OK):
			f = open(CPMYCMDS, 'r')
			k = ''
			while 1:
				s = f.readline()
				if s:
					s = s.strip()
					if not s or s.startswith('#'):
						# just a comment or a blank line
						continue
					if s.startswith('::'): # EMOTES
						if s[2:]:
							k = s[2:]
							self.mycmd[k] = ('emote', '')
					elif s.startswith(':'): # COMMENTS
						if s[1:]:
							k = s[1:]
							self.mycmd[k] = ('comment', '')
					elif s.startswith('!'): # EXEC O's
						if s[1:]:
							k = s[1:]
							self.mycmd[k] = ('exec o', '')
					elif s.startswith('|'): # FILTERS
						if s[1:]:
							k = s[1:]
							self.mycmd[k] = ('filter', '')
					else:
						if k:
							if self.mycmd[k][1]:
								self.mycmd[k] = (self.mycmd[k][0], '%s %s' % (self.mycmd[k][1], s))
							else:
								self.mycmd[k] = (self.mycmd[k][0], s)
				else:
					break
			#end while
			f.close()

	def clean(self):
		self.save_buds()
		self.save_ignores()
		if self.log:
			try:
				self.log.close()
			except IOError:
				pass

	def load_buds(self):
			try:
				f = open(CPBUDDIES, 'r')
				self.buddies = pickle.load(f)
				f.close()
			except IOError:
				pass
	
	def save_buds(self):
			try:
				f = open(CPBUDDIES, 'w')
				pickle.dump(self.buddies, f)
				f.close()
			except:
				pass

	def load_ignores(self):
			try:
				f = open(CPIGNORES, 'r')
				self.ignores = pickle.load(f)
				f.close()
			except IOError:
				pass
	
	def save_ignores(self):
			try:
				f = open(CPIGNORES, 'w')
				pickle.dump(self.ignores, f)
				f.close()
			except:
				pass

	def save_rc(self):
		if os.access(CPDIR, os.F_OK):
			if os.access(CPDIR, os.W_OK):
				if os.access(CPRC, os.F_OK):
					if os.access(CPRC, os.W_OK):
						self.write_rc()
				else:
					self.write_rc()
		else:
			os.mkdir(CPDIR, 0700)
			self.write_rc()
		
	def write_rc(self):
		f = open(CPRC, 'w')
		try:
			f.write('username=%s\nalias=%s\nroom=%s\npassword=%s\n' % (self.user, ','.join(self.alias), self.room, self.password))
		finally:
			f.close()

	def load_rc(self):
		if os.access(CPRC, os.R_OK|os.W_OK):
			f = open(CPRC, 'r')
			try:
				line = f.readline().strip()
				while line:
					if line.startswith('username='):
						self.user = line.split('=',1).pop().strip()
					elif line.startswith('room='):
						self.room = line.split('=',1).pop().strip()
					elif line.startswith('password='):
						self.password = line.split('=',1).pop().strip()
					line = f.readline().strip()
			finally:
				f.close()
				
	def load_opts(self):
		options = clopt.do()
		if options[0]: self.user = options[0]
		if options[1]: self.room = options[1]
		if options[2] in ('5', '6', '7', '8'):
			self.server = "cs%s.chat.yahoo.com" % options[2]
		if options[3]:
			try:
				self.log = open(CPLOG, 'a')
			except:
				pass
		if options[4]:
			if not options[0]:
				# the username in curphoorc is not wanted
				self.user = ""
				while not self.user:
					self.user=raw_input("Username: ")
					self.user=self.user.strip()
			self.password=''

	def setcookie(self):
		prompt = "Y! login: %s\nPassword: " % self.user
		if not self.password:
			self.password = getpass.getpass(prompt)
		print "fetching cookie, please wait..."
		q=urllib.quote
		s=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
		s.connect(('login.yahoo.com',80))
		s.send('HEAD /config/login?login=%s&passwd=%s HTTP/1.0\r\nAccept: */*%s'%(q(self.user),q(self.password),'\r\n'*3))
		d,c='',s.recv(1024)
		while c:d,c='%s%s'%(d,c),s.recv(1024)
		s.close()
		y,t,i='','',12
		for e in d.split('\n'):
			if e[i:i+2]=='Y=':y=e.split(';')[0][i:]
			elif e[i:i+2]=='T=':t=e.split(';')[0][i:]
		y and t or sys.exit('ERROR: Invalid login')
		self.alias=[self.user]
		self.cookie='%s; %s' % (y, t)
		#self.password=selfpassword

