# decodep.py
# Copyright (C) 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import struct
from yahoodef import *
import cpformat
import string

TFROM = '%s%s' % (
						''.join([chr(x) for x in range(0x00, 0x20)]),
						''.join([chr(x) for x in range(0x7f, 0xff)])  )
TTO = '\x01'*len(TFROM)
TTABLE = string.maketrans(TFROM, TTO)
tr = lambda s: s.translate(TTABLE)

def do(packet):
	packet_type = struct.unpack('!l', packet[8:12])[0]
	error = struct.unpack('!h', packet[12:14])[0]
	data = packet[HEADERLEN:]
	val = data.split(DELIM)
	if error:
		if packet_type != LOGOUT:
			return {'type': 'crap'}
	elif packet_type == COMMENT:
		return {
			'type': 'comment',
			'user': tr(val[1]),
			'text': cpformat.do(val[2])
		}
	elif packet_type == EMOTE:
		return {
			'type': 'emote',
			'user': tr(val[1]),
			'text': cpformat.do(val[2])
		}
	elif packet_type == PM:
		return {
			'type': 'pm',
			'user': tr(val[0]),
			'text': cpformat.do(val[2])
		}
	elif packet_type == AWAY:
		x = {}
		x['type'] =  'away'
		x['user'] = tr(val[0])
		try:
			x['text'] = AWAYMESG.get(val[2], 'is away (%s)' % val[3])
		except IndexError:
			x['text'] = 'is away'
		return x
	elif packet_type == ENTER:
		# join type packets have urls in val[2]
		if val[2] != ' ':
			return {
				'type': 'join',
				'room': val[0],
				'topic': val[1],
				'users': [tr(e) for e in re.split(NICKDELIM, val[4]) if e]
			}
		else:
			#user = tr(val[4])
			user = val[4]
			i = user.find("\x01")
			if i not in (0, -1):
				user = user[:i]
			i = user.find("\x02")
			if i not in (0, -1):
				user = user[:i]
			return {
				'type': 'enter',
				'room': val[0],
				'user': user
			}
	elif packet_type == EXIT:
		user = tr(val[1])
		i = user.find("#")
		if i not in (0, -1):
			user = user[:i]
		return {
			'type': 'exit',
			'room': val[0],
			'user': user
		}
	elif packet_type == THOUGHT:
		# This packet type might be deprecated.
		return {
			'type': 'thought',
			'user': tr(val[1]),
			'text': cpformat.do(val[2])
		}
	elif packet_type == LOGIN:
		return {
			'type': 'login',
			'text': 'Login successful'
		}
	elif packet_type == LOGOUT:
		return {
			'type': 'logout',
			'text': 'Logout successful'
		}
	else:
		return {
			'type': 'unknown',
			'text': "unknown packet type %x" % packet_type
		}
