# cmdparser.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: cmdparser.py,v 1.8 2002/05/05 02:47:22 hacker Exp $
#
# $Log: cmdparser.py,v $
# Revision 1.8  2002/05/05 02:47:22  hacker
# took out /flood command because its nasty and susceptible
# to script kiddies. heh
#
# Revision 1.7  2002/05/05 01:56:59  hacker
# more fixes to /help regex
#
# Revision 1.6  2002/05/05 01:53:41  hacker
# fixed /quit regex
#
# Revision 1.5  2002/05/05 01:51:42  hacker
# fixed /help regex
#
# Revision 1.4  2002/05/05 01:32:58  hacker
# added /msg alias /m
#
# Revision 1.3  2002/05/05 01:30:57  hacker
# added support for /me commands
#
# Revision 1.2  2002/05/04 23:08:26  hacker
# complete rewrite
# took out all the compiled regex
# added support for /uptime /help
# renamed and made aliases for some commands
#
# Revision 1.1  2002/05/01 08:39:22  hacker
# Initial revision
#
#
##


import re
import output
import shexec
import webbrowser
import curses
import Session
import time
import cmdhelp

IGNORE_MSG = "*** %s will be ignored. heh ***"
AWAY_MSG = "on vacation" 
PLUG_MSG= "is using Curphoo 0.02.0 RC2 http://www.waduck.com/~curphoo/"

def btk(cli, sess, statusbar):
	if sess.afk:
		sess.afk = 0
		#cli.write_message(type='back')
		output.status(statusbar, sess)

def do(cmd, cli, sess, chatwin, statusbar):
	"I don't want to have to tell you twice. Do what you're told Damn It!"
	# clean up after zombies
	shexec.clean_up(sess.pids)
	# I could've had functions here to break it down a little
	# bit but in the end for some funny reason I chose not to.
	# Enjoy!

	# COMMENTS
	if re.match(r'^[^/:!\\ ].*$', cmd, re.I):
		# this should match the majority of comments.
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text=cmd)

	# QUIT 
	elif re.match('^/q(uit)? *$', cmd, re.I):
		cli.write_message(type='logout')

	# GOT SOMETHING TO SAY BEFORE YOU QUIT?
	elif re.match('^/q(uit)? +?[^ ].*$', cmd, re.I):
		quit_msg = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='comment', text=quit_msg)
		cli.write_message(type='logout')

	# EMOTES
	#elif re.match('^:.*?[^ ].*$', cmd, re.I):
		##btk(cli, sess, statusbar)
		#cli.write_message(type='emote', text=cmd[1:].strip())
		##cli.write_message(type='comment', text=cmd[1:].strip())

	elif re.match('^/invite *?[^ ].*$', cmd, re.I):
		msg = cmd.split(' ',1).pop().strip()
		cli.write_message(type='invite', text=msg)
		cli.write_message(type='invite2', text=msg)

	elif re.match('^/me *?[^ ].*$', cmd, re.I):
		msg = cmd.split(' ',1).pop().strip()
		btk(cli, sess, statusbar)
		#cli.write_message(type='emote', text=msg)
		cli.write_message(type='comment', text='* %s' % msg)

	# CLEAR CHAT WINDOW
	elif re.match('^/cl(ear|s) *$', cmd, re.I):
		chatwin.clear()
		chatwin.move((curses.LINES -2) * 19, 0)

	# WELL.. WELL.. LOOK WHO's HERE
	elif re.match('(^/u(sers)? *$|^/$)', cmd, re.I):
		output.list_users(chatwin, sess.users, 'Users')

	# JOIN ROOMS
	elif re.match('^/j(oin)? +?[^ ].*$', cmd, re.I):
		chat_room = cmd.split(' ', 1).pop().strip()
		sess.afk = 0
		cli.write_message(type='join', room=chat_room)

	# THINK OUT LOUD
	elif re.match('^/t(hink)? +?[^ ].*$', cmd, re.I):
		thought = cmd.split(' ', 1).pop().strip()
		btk(cli, sess, statusbar)
		cli.write_message(type='thought', text=thought)

	# STOP BITCHING ABOUT THE NON-FUNCTIONAL BACKSPACE DAMN IT!
	elif re.match('^/t(hink)? *$', cmd, re.I):
		btk(cli, sess, statusbar)
		cli.write_message(type='thought',
				text="wtf is ^H: Gee...  I don't know what ^H means...'")

	# *DYING*
	elif re.match('^/d(ying)? +[^ ].*$', cmd, re.I):
		dead_stuff = cmd.split(' ', 1).pop().strip()
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text='%s is *dying*' % dead_stuff)

	elif re.match('^/up(time)? *$', cmd, re.I):
		u = time.time() - sess.time0
		u = int(u)
		days = u / (60*60*24)
		u = u % (60*60*24)
		hours = u / (60*60)
		u = u % (60*60)
		minutes = u / (60)
		seconds = u % 60
		msg = "uptime (Curphoo):  up"
		if days:
			msg = "%s %s %s" % (msg, days, days > 1 and 'days,' or 'day,')
		msg = "%s %02d:%02d.%02d" % (msg, hours, minutes, seconds)
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text=msg)

	# GIVE A BUDDY PM PRIVILEGES
	elif re.match('^/b(uddy)? +?[^ ].*$', cmd, re.I):
		user = cmd.split(' ', 1).pop().strip().lower()
		if user in sess.buddies: 
			sess.buddies.remove(user); output.pm_notice(chatwin, user, 0)
		else:
			sess.buddies.append(user); output.pm_notice(chatwin, user)
		output.status(statusbar, sess)

	# LIST ALL CHATTERS WITH PM PRIVILEGES
	elif re.match('^/b(uddy)? *$', cmd, re.I):
		output.list_users(chatwin, sess.buddies, 'List of buddies')

	# HIGLIGHT A CHATTER's COMMENTS ONLY COS YOU LOVE HIM/HER SO MUCH
	elif re.match('^/h(ilite-user|u) +?[^ ].*$', cmd, re.I):
		user = cmd.split(' ', 1).pop().strip().lower()
		if user in sess.high: 
			sess.high.remove(user); output.hi_notice(chatwin, user, 0)
		else:
			sess.high.append(user); output.hi_notice(chatwin, user)

	# CHECK OUT WHO WE HAVE HIGHLIGHTED
	elif re.search('^/h(ilight-user|u) *$', cmd, re.I):
		output.list_users(chatwin, sess.high, 'List of users to highlight')

	# HIGHLIGHT COMMENTS CONTAINING A PARTICULAR STRING
	elif re.match('^/h(ilite-string|s) +?[^ ].*$', cmd, re.I):
		string = cmd.split().pop().strip().lower()
		if string in sess.highstr: 
			sess.highstr.remove(string); output.histr_notice(chatwin, string, 0)
		else:
			sess.highstr.append(string); output.histr_notice(chatwin, string)

	# HMM.. I WONDER WHAT STRINGS WE HIGHLIGHT
	elif re.search('^/h(ilight-string|s) *$', cmd, re.I):
		output.list_users(chatwin, sess.highstr, 'List of strings to highlight')

	# QUIETLY IGNORE ANNOYING CHATTERS
	elif re.match('^/i(gnore)? +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if user in sess.ignores: 
			sess.ignores.remove(user); output.ignore_notice(chatwin, user, 0)
		else:
			sess.ignores.append(user); output.ignore_notice(chatwin, user)
		output.status(statusbar, sess)

	# IGNORE SEVERAL ANNOYING CHATTERS IN ONE COMMAND
	elif re.match(r'^/i(gnore)?\* +[^ ].*', cmd, re.I):
		users = cmd.split(' ',1).pop().strip()
		users = [e.lower() for e in users.split()]
		for e in users:
			if e in sess.ignores: 
				sess.ignores.remove(e)
				output.ignore_notice(chatwin, e[:-1], 0)
			else:
				sess.ignores.append(e)
				output.ignore_notice(chatwin, e[:-1])
			output.status(statusbar, sess)

	# NOTIFY THE ROOM THAT YOU'RE IGNORING SOMEONE
	elif re.match('^/i(gnore)?v +[^ ].*', cmd, re.I):
		user = cmd.split(' ',1).pop().strip()
		if user in sess.ignores:
			sess.ignores.remove(user)
			output.ignore_notice(chatwin, user, 0)
		else: 
			sess.ignores.append(user)
			iggy_comment = IGNORE_MSG % user
			btk(cli, sess, statusbar)
			cli.write_message(type='comment', text=iggy_comment)
		output.status(statusbar, sess)

	# LIST ALL USERS ON IGNORE
	elif re.match('^/i(gnore)? *$', cmd, re.I):
		output.list_users(chatwin, sess.ignores, 'List of users on ignore')

	# PROMOTE CURPHOO
	elif re.match('/v(er|ersion)? *$', cmd, re.I):
		btk(cli, sess, statusbar)
		cli.write_message(type='emote', text=PLUG_MSG)
		#cli.write_message(type='comment', text=PLUG_MSG)

	# IMPRESS YOUR FRIENDS W/ SOME SH FU
	elif re.match(r'^[!][^!]+?[^ ].*$', cmd, re.I):
		shc = cmd[1:].strip()
		bufsize = 0x549 - len(shc) - 4
		res = '%s:\n%s' % (shc, shexec.do(shc, bufsize, sess.pids))
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text=res)

	# SH FU w/out SENDING TO CHAT
	elif re.match(r'^[!][!] *?[^ ].*$', cmd, re.I):
		shc = cmd[2:].strip()
		bufsize = 512 - len(shc) - 4
		res = shexec.do(shc, bufsize, sess.pids)
		output.shcmd(chatwin, sess.user, '%s:\n%s' % (shc, res))

	# THE WHOLE WORLD's JUST GOTTA KNOW YOUR BACK
	elif re.match('^/back *$', cmd, re.I):
		cli.write_message(type='back')
		sess.afk = 0
		output.status(statusbar, sess)

	# FOR SOME REASON YOU'RE AFK
	elif re.match('^/a(way)? +?[^ ].*$', cmd, re.I):
		away_msg = cmd[len('/away '):].strip()
		away_msg = cmd.split(' ', 1).pop().strip()
		cli.write_message(type='away', text=away_msg)
		sess.afk = 1
		output.status(statusbar, sess)

	elif re.match('^/a(way)? *$', cmd, re.I):
		if sess.afk:
			cli.write_message(type='back')
			sess.afk = 0
		else:
			cli.write_message(type='away', text=AWAY_MSG)
			sess.afk = 1
		output.status(statusbar, sess)

	# TELL YOUR GIRLFRIEND STUFF IN PRIVATE
	elif re.match('^/(m(sg)?|tell) *?[^ ]+? +?[^ ].*$', cmd, re.I):
		user_msg = cmd.split(' ',1).pop().strip()
		u = user_msg.split(' ',1).pop(0)
		m = user_msg.split(' ',1).pop().strip()
		if m.startswith('!'):
			shc = m[1:].strip()
			if shc:
				res = shexec.do(shc, 512 - len(shc) - 2, sess.pids)
				cli.write_message(type='pm', me=sess.user, user=u, text='%s:\n%s' % (shc, res))
				output.pm_user(chatwin, sess.user, u, '%s:\n%s' % (shc, res))
			else:
				cli.write_message(type='pm', me=sess.user, user=u, text='!')
				output.pm_user(chatwin, sess.user, u, '!')
		else:
			cli.write_message(type='pm', me=sess.user, user=u, text=m)
			output.pm_user(chatwin, sess.user, u, m)

	# SL4CkSB00T3R
	elif re.match('^/(fuckup) *?[^ ]+? +?[^ ].*$', cmd, re.I):
		user_msg = cmd.split(' ',1).pop().strip()
		u = user_msg.split(' ',1).pop(0)
		m = user_msg.split(' ',1).pop().strip()
		z=m;
		x=0
		output.shcmd(chatwin, sess.user, '***B00+:  %s' % ( u ))
		while x < 1000:
			cli.write_message(type='pm', me=sess.user, user=u, text=m)
			m = '%s%s' % (m,x);

			if x>10:
				m='SDJDLJDSDKJSxxxxxxxxxxxLFJFLSJFSLFJS%s%s' % (m, x)
			if x>20:
				m='SDLKJDxxxxxxxxxxxxxxxxxxxxx%s%s' % (m, x)
			if x>40:
				m='WE HATEZ THEM PRECIOUS OH YES WE HATES THEM%s%s' % (m, x)
			if x>100:
				m=z;
			x=x+1

		output.shcmd(chatwin, sess.user, '***B00+ ENDED: %s:' % ( u ))


	# FOLLOW A USER
	elif re.match('^/goto +?[^ ].*$', cmd, re.I):
		u = cmd.split(' ',1).pop().strip()
		sess.afk = 0
		cli.write_message(type='goto', user=u)

	# open urls from chat in a webbrowser
	elif re.match(r'^/openurl *$', cmd, re.I):
		if sess.url:
			try:
				webbrowser.open(sess.url, new=1, autoraise=0)
				output.blah(chatwin, 'opening %s' % sess.url)
			except:
				output.blah(chatwin, 'failed to open browser')
			output.status(statusbar, sess)

	# open url from the input box in a webbrowser
	elif re.match(r'^/openurl *?[^ ].*$', cmd, re.I):
		url = cmd.split(' ',1).pop().strip()
		try:
			output.blah(chatwin, 'opening %s' % url)
			webbrowser.open(url, new=1, autoraise=0)
		except:
				output.blah(chatwin, 'failed to open browser')
		output.status(statusbar, sess)

	elif re.match(r'/help +?(/?join|/?quit|/?ignore\*?|/?buddy|/|/?tell|/?hs|/?hu|/?uptime|/?ver|[!]|[!][!]|:)$', cmd, re.I):
		help_str = cmd.split(' ',1).pop().strip().lower()
		output.help(chatwin, cmdhelp.helpd[help_str])

	elif re.match('/help *$', cmd, re.I):
		output.help(chatwin, cmdhelp.help)

	elif cmd[0] == '/' and cmd.strip().split(' ',1).pop(0)[1:].lower() in sess.mycmd.keys():
		pair = cmd.strip().split(' ',1)
		k = pair.pop(0).strip()[1:].lower()
		k = k.lower()
		if sess.mycmd[k][0] == 'filter':
			if pair:
				v = pair.pop(0)
				shc = sess.mycmd[k][1].replace('%s', v)
				bufsize = 510
				res = shexec.do(shc, bufsize, sess.pids)
				btk(cli, sess, statusbar)
				cli.write_message(type='comment', text=res)
		elif sess.mycmd[k][0] == 'exec o':
			if pair:
				v = pair.pop(0)
				shc = sess.mycmd[k][1].replace('%s', v)
				bufsize = 512 - len(k) - 5 - len(v)
				res = '%s %s:\n%s' % (k, v, shexec.do(shc, bufsize, sess.pids))
			else:
				shc = sess.mycmd[k][1]
				bufsize = 512 - len(k) - 4
				res = '%s:\n%s' % (k, shexec.do(shc, bufsize, sess.pids))
			btk(cli, sess, statusbar)
			cli.write_message(type='comment', text=res)
		elif sess.mycmd[k][0] == 'comment':
			if pair:
				v = pair.pop(0)
				s = sess.mycmd[k][1].replace('%s', v)
			else:
				s = sess.mycmd[k][1]
			btk(cli, sess, statusbar)
			cli.write_message(type='comment', text=s)
		elif sess.mycmd[k][0] == 'emote':
			if pair:
				v = pair.pop(0)
				s = sess.mycmd[k][1].replace('%s', v)
			else:
				s = sess.mycmd[k][1]
			btk(cli, sess, statusbar)
			cli.write_message(type='emote', text=s)
			#cli.write_message(type='comment', text=s)

	elif re.match(r'^\\.*?[^ ].*$', cmd):
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text=cmd[1:].strip())

	elif re.match(r'^/.*$', cmd):
		pass
	elif re.match(r'^ *?[^ ].*$', cmd):
		btk(cli, sess, statusbar)
		cli.write_message(type='comment', text=cmd.strip())

