# clopt.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys, getopt

def usage():
	print """
Curphoo 0.02.0
Usage:
	curphoo [-u<username>] [-r<chat room>] [-s<6|7|8>] [-l]

Options:
	-u    specify yahoo id to use
	-r    specify which chat room to go to
	-s    specify which chatserver to connect to
	      -s6 (connects to cs6.chat.yahoo.com)
	      -s7 (connects to cs7.chat.yahoo.com)
	      -s8 (connects to cs8.chat.yahoo.com)
	-l    log chat and save to $HOME/.curphoo/log
	--norc	specify that you don't want your curphoorc loaded

Example:
	curphoo -uThe_CPU_Fan -r"Linux, FreeBSD, Solaris:1" -s6

"""

def do():
	username = ''
	room = ''
	server = ''
	log=0
	norc=0
	try:
		opts = getopt.getopt(sys.argv[1:], "u:r:s:lh", ['norc'])[0]

		if len(opts) == 1 and opts[0][0] == '-h':
			usage()
			sys.exit(0)
		else:
			for o, a in opts:
				if o == '-u':
					username = a
				elif o == '-r':
					room = a
				elif o == '-s':
					server = a
				elif o == '-l':
					log = 1
				elif o == '--norc':
					norc = 1
		if norc:
			switch = [e[0] for e in opts]
			# unless -u is specified clear username
			if '-u' not in switch:
				username = ""
			# unless -r is specified clear room
			if '-r' not in switch:
				room = ""
	except getopt.GetoptError:
		usage()
		sys.exit(1)
	return (username, room, server, log, norc)

