# Yahoo.py
# Copyright (C) 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import socket, sys, select, struct
import decodep
import encodep

class Client:


	def __init__(self):
		self.__socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		self.__rbuf = ''
		self.__wbuf = ''
		self.__wbufq = []
		self.ok = 0

	def connect(self, server):
		try:
			self.__socket.connect((server, 8001))
		except socket.error, e:
			sys.exit('connect failed: %s\n' % str(e))
		except socket.herror, e:
			sys.exit('connect failed: %s\n' % str(e))
		except socket.gaierror, e:
			sys.exit('connect failed: %s\n' % str(e))
		self.__socket.setblocking(0)
		self.ok = 1

	def disconnect(self):
		self.__socket.close()
		self.ok = 0
		return 1

	def __send(self):
		ok = 1
		n = self.__socket.send(self.__wbuf)
		if n:
			self.__wbuf = self.__wbuf[n:]
		else:
			ok = 0
		return ok

	def __recv(self):
		ok = 1
		r = self.__socket.recv(4096)
		if r:
			self.__rbuf = '%s%s' % (self.__rbuf, r)
		else:
			ok = 0
		return ok

	def chat(self):
		s = self.__socket
		try:
			r, w, e = select.select([s], [], [], (len(self.__wbufq) > 3) and 0.1250 or 0.0250)
			s in r and (self.__recv() or self.disconnect())
			if not self.__rbuf:
				if self.__wbuf:
					r, w, e = select.select([], [s], [],
							(len(self.__wbufq) > 3) and 8.0 or 0.0250)
					s in w and (self.__send() or self.disconnect())
				else:
					if self.__wbufq:
						self.__wbuf = self.__wbufq.pop(0)
		except (socket.error, select.error):
			self.disconnect()
		return self.ok

	def read_message(self):
		hlen = 16
		header = self.__rbuf[:hlen]
		if len(header) == hlen:
			u = struct.unpack('!4sllhh', header)
			plen = u[4] + hlen
			if len(self.__rbuf) >= plen:
				packet = self.__rbuf[:plen]
				self.__rbuf = self.__rbuf[plen:]
				try:
					return decodep.do(packet)
				except struct.error:
					pass

	def write_message(self, **keywords):
		if self.__wbuf:
			self.__wbufq.append(encodep.do(keywords) or '')
		else:
			self.__wbuf = '%s%s' % (self.__wbuf, encodep.do(keywords) or '')

