/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdint.h>

#include <glib-object.h>
#include <glib.h>
#include <libgnome/gnome-i18n.h>

#include "debug.h"
#include "theme.h"

struct _CriaThemePrivate
{
	GHashTable	* layouts;
};

enum
{
	PROP_0,
	PROP_NAME
};

enum
{
	SIGNAL,
	N_SIGNALS
};

static	void	cria_theme_get_property	       (GObject		* object,
						guint		  prop_id,
						GValue		* value,
						GParamSpec	* param_spec);
static	void	cria_theme_init		       (CriaTheme	* self);
static	void	cria_theme_set_property        (GObject		* object,
						guint		  prop_id,
						const	GValue	* value,
						GParamSpec	* param_spec);
#if 0
static	guint	cria_theme_signals[N_SIGNALS] = { 0 };

static	void	cria_theme_signal	       (CriaTheme	* template,
						const	gchar	* string);
#endif
void
cria_theme_add_layout (
		CriaTheme	* self,
		CriaLayout	* layout)
{
	g_return_if_fail (CRIA_IS_THEME (self));
	g_return_if_fail (CRIA_IS_LAYOUT (layout));
	g_return_if_fail (g_hash_table_lookup (self->priv->layouts, cria_layout_get_name (layout)) == NULL);

	g_debug ("cria_theme_add_layout(0x%x): adding 0x%x as \"%s\"", (uintptr_t)self, (uintptr_t)layout, cria_layout_get_name (layout));

	g_hash_table_insert (
			self->priv->layouts,
			g_strdup (cria_layout_get_name (layout)),
			layout);
}

CriaLayout*
cria_theme_get_layout (
		CriaTheme	* self,
		const char	* layout)
{
	g_return_val_if_fail (CRIA_IS_THEME (self), NULL);

	g_debug ("cria_theme_get_layout(0x%x): looking for \"%s\"", (uintptr_t)self, layout);

	return CRIA_LAYOUT (g_hash_table_lookup (self->priv->layouts, layout));
}

static void
cria_theme_class_init (CriaThemeClass	* cria_theme_class)
{
	GObjectClass	* g_object_class;

	g_object_class = G_OBJECT_CLASS(cria_theme_class);
#if 0
	/* setting up signal system */
	cria_theme_class->signal = cria_theme_signal;

	cria_theme_signals[SIGNAL] = g_signal_new (
			"signal",
			CRIA_TYPE_THEME,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CriaThemeClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cria_theme_set_property;
	g_object_class->get_property = cria_theme_get_property;

	g_object_class_install_property (
			g_object_class,
			PROP_NAME,
			g_param_spec_string (
				"name",
				"Name",
				"The name of this theme",
				_("untitled"),
				G_PARAM_READWRITE | G_PARAM_CONSTRUCT)
			);
}

const char*
cria_theme_get_name (
		CriaTheme	* self)
{
	g_return_val_if_fail (CRIA_IS_THEME(self), NULL);
	
	return self->name;
}

static void
cria_theme_get_property (
		GObject		* object,
		guint		  prop_id,
		GValue		* value,
		GParamSpec	* param_spec)
{
	CriaTheme	* self;

	self = CRIA_THEME (object);

	switch (prop_id)
	{
	case PROP_NAME:
		g_value_set_string (
				value,
				self->name);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

GType
cria_theme_get_type (void)
{
	static GType	type = 0;

	if (!type)
	{
		const GTypeInfo info = {
			sizeof (CriaThemeClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cria_theme_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof (CriaTheme),
			0,
			(GInstanceInitFunc)cria_theme_init,
			0
		};

		type = g_type_register_static (
				G_TYPE_OBJECT,
				"CriaTheme",
				&info,
				0);
	}

	return type;
}

static void
cria_theme_init (CriaTheme *self)
{
	self->priv = g_new0 (CriaThemePrivate, 1);

	self->priv->layouts = g_hash_table_new_full (
			g_str_hash,
			g_str_equal,
			g_free,
			g_object_unref);
}

void
cria_theme_set_name (
		CriaTheme	* self,
		const gchar	* name)
{
	g_return_if_fail (CRIA_IS_THEME(self));

	if (self->name != NULL)
		g_free (self->name);

	self->name = g_strdup (name);

	g_object_notify (G_OBJECT (self), "name");
}

static void
cria_theme_set_property (
		GObject		* object,
		guint		  prop_id,
		const	GValue	* value,
		GParamSpec	* param_spec)
{
	CriaTheme	* self;
	
	self = CRIA_THEME (object);
	
	switch (prop_id)
	{
	case PROP_NAME:
		cria_theme_set_name (
				self,
				g_value_get_string (value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

