/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef SLIDE_H
#define SLIDE_H

#include <glib-object.h>

#include "layout.h"
#include "slide-block.h"
#include "theme.h"

G_BEGIN_DECLS

typedef struct _CriaSlide		CriaSlide;
typedef struct _CriaSlideClass		CriaSlideClass;
typedef struct _CriaSlidePrivate	CriaSlidePrivate;

void		cria_slide_add_block	       (CriaSlide	* self,
						CriaSlideBlock	* block);
CriaSlideBlock*	cria_slide_get_block	       (CriaSlide	* self,
						gchar const	* block);
gdouble		cria_slide_get_display_height  (CriaSlide	* self,
						GdkScreen	* screen);
gdouble		cria_slide_get_display_width   (CriaSlide	* self,
						GdkScreen	* screen);
GType		cria_slide_get_type	       (void);
CriaLayout*	cria_slide_get_layout	       (CriaSlide	* self);
CriaTheme*	cria_slide_get_theme	       (CriaSlide	* self);
const gchar*	cria_slide_get_title	       (CriaSlide	* self);
void		cria_slide_set_layout	       (CriaSlide	* self,
						CriaLayout	* layout);
void		cria_slide_set_theme	       (CriaSlide	* self,
						CriaTheme	* theme);
void		cria_slide_set_title	       (CriaSlide	* self,
						const char	* title);

#define CRIA_TYPE_SLIDE			(cria_slide_get_type ())
#define CRIA_SLIDE(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE, CriaSlide))
#define CRIA_SLIDE_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE, CriaSlideClass))
#define CRIA_IS_SLIDE(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE))
#define CRIA_IS_SLIDE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE))
#define CRIA_SLIDE_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE, CriaSlideClass))

struct _CriaSlide {
	GObject		  base_instance;
	gchar		* title;

	CriaSlidePrivate* priv;
};

struct _CriaSlideClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaSlide	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* SLIDE_H */
