/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef SLIDE_BLOCK_H
#define SLIDE_BLOCK_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _CriaSlideBlock		CriaSlideBlock;
typedef struct _CriaSlideBlockClass	CriaSlideBlockClass;
typedef struct _CriaSlideBlockPrivate	CriaSlideBlockPrivate;

const gchar*	cria_slide_block_get_processed_content (CriaSlideBlock	* self);
GType		cria_slide_block_get_type	       (void);
const gchar*	cria_slide_block_get_title	       (CriaSlideBlock	* self);
void		cria_slide_block_set_content	       (CriaSlideBlock	* self,
							const char	* content);
void		cria_slide_block_set_title	       (CriaSlideBlock	* self,
							const char	* attribute);

#define CRIA_TYPE_SLIDE_BLOCK			(cria_slide_block_get_type ())
#define CRIA_SLIDE_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE_BLOCK, CriaSlideBlock))
#define CRIA_SLIDE_BLOCK_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE_BLOCK, CriaSlideBlockClass))
#define CRIA_IS_SLIDE_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE_BLOCK))
#define CRIA_IS_SLIDE_BLOCK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE_BLOCK))
#define CRIA_SLIDE_BLOCK_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE_BLOCK, CriaSlideBlockClass))

struct _CriaSlideBlock
{
	GObject			  base_instance;
	gchar			* title;

	CriaSlideBlockPrivate	* priv;
};

struct _CriaSlideBlockClass
{
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaSlideBlock	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* SLIDE_BLOCK_H */
