/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <glib.h>
#include <glib/gprintf.h>

#include "debug.h"
#include "slide-block.h"

struct _CriaSlideBlockPrivate
{
	char	* content;
};

enum
{
	PROP_0,
	PROP_TITLE
};

enum
{
	SIGNAL,
	N_SIGNALS
};

static	void	cria_slide_block_get_property	       (GObject		* object,
						guint		  prop_id,
						GValue		* value,
						GParamSpec	* param_spec);
static	void	cria_slide_block_init	       (CriaSlideBlock	* self);
static	void	cria_slide_block_set_property        (GObject		* object,
						guint		  prop_id,
						const	GValue	* value,
						GParamSpec	* param_spec);
#if 0
static	guint	cria_slide_block_signals[N_SIGNALS] = { 0 };

static	void	cria_slide_block_signal	       (CriaSlideBlock	* template,
						const	gchar	* string);
#endif
static void
cria_slide_block_class_init (CriaSlideBlockClass	* cria_slide_block_class)
{
	GObjectClass	* g_object_class;

	g_object_class = G_OBJECT_CLASS(cria_slide_block_class);
#if 0
	/* setting up signal system */
	cria_slide_block_class->signal = cria_slide_block_signal;

	cria_slide_block_signals[SIGNAL] = g_signal_new (
			"signal",
			CRIA_TYPE_SLIDE_BLOCK,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CriaSlideBlockClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cria_slide_block_set_property;
	g_object_class->get_property = cria_slide_block_get_property;

	g_object_class_install_property(g_object_class,
					PROP_TITLE,
					g_param_spec_string("title",
							    "Title",
							    "The name of this block",
							    "default_value",
							    G_PARAM_READWRITE | G_PARAM_CONSTRUCT));
}

const gchar*
cria_slide_block_get_processed_content (
		CriaSlideBlock  * self)
{
	g_return_val_if_fail (CRIA_IS_SLIDE_BLOCK (self), NULL);

	g_debug ("cria_slide_block_get_processed_content(): markup is:");
	g_message ("%s", self->priv->content);
	
	return self->priv->content;
}

static void
cria_slide_block_get_property (
		GObject		* object,
		guint		  prop_id,
		GValue		* value,
		GParamSpec	* param_spec)
{
	CriaSlideBlock	* self;

	self = CRIA_SLIDE_BLOCK (object);

	switch (prop_id)
	{
	case PROP_TITLE:
		g_value_set_string (
				value,
				self->title);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

const char*
cria_slide_block_get_title (
		CriaSlideBlock	* self)
{
	g_return_val_if_fail (CRIA_IS_SLIDE_BLOCK(self), NULL);
	
	return self->title;
}

GType
cria_slide_block_get_type (void)
{
	static GType	type = 0;

	if (!type)
	{
		const GTypeInfo info = {
			sizeof (CriaSlideBlockClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cria_slide_block_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof (CriaSlideBlock),
			0,
			(GInstanceInitFunc)cria_slide_block_init,
			0
		};

		type = g_type_register_static (
				G_TYPE_OBJECT,
				"CriaSlideBlock",
				&info,
				0);
	}

	return type;
}

static void
cria_slide_block_init (CriaSlideBlock * self)
{
	self->priv = g_new0 (CriaSlideBlockPrivate, 1);
	self->priv->content = g_strdup ("");
}

void
cria_slide_block_set_content (
		CriaSlideBlock	* self,
		const gchar	* content)
{
	g_return_if_fail (CRIA_IS_SLIDE_BLOCK (self));

	if (self->priv->content != NULL)
		g_free (self->priv->content);

	self->priv->content = g_strdup (content);
}

void
cria_slide_block_set_title (
		CriaSlideBlock	* self,
		const gchar	* title)
{
	g_return_if_fail (CRIA_IS_SLIDE_BLOCK(self));

	if (self->title != NULL)
		g_free (self->title);

	self->title = g_strdup (title);

	g_object_notify (G_OBJECT (self), "title");
}

static void
cria_slide_block_set_property (
		GObject		* object,
		guint		  prop_id,
		const	GValue	* value,
		GParamSpec	* param_spec)
{
	CriaSlideBlock	* self;
	
	self = CRIA_SLIDE_BLOCK (object);
	
	switch (prop_id)
	{
	case PROP_TITLE:
		cria_slide_block_set_title (
				self,
				g_value_get_string (value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

