/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef LAYOUT_H
#define LAYOUT_H

#include <glib-object.h>
#include <gdk/gdkpixbuf.h>

#include "layout-block.h"

G_BEGIN_DECLS

typedef struct _CriaLayout		CriaLayout;
typedef struct _CriaLayoutClass		CriaLayoutClass;
typedef struct _CriaLayoutPrivate	CriaLayoutPrivate;

void		cria_layout_add_block	       (CriaLayout	* self,
						CriaLayoutBlock	* block);
GdkPixbuf*	cria_layout_get_background     (CriaLayout	* self);
CriaLayoutBlock*cria_layout_get_block	       (CriaLayout	* self,
						char const	* title);
char**		cria_layout_get_block_names    (CriaLayout	* self);
GType		cria_layout_get_type	       (void);
const gchar*	cria_layout_get_name	       (CriaLayout	* self);
void		cria_layout_set_background     (CriaLayout	* self,
						GdkPixbuf	* background);
void		cria_layout_set_description    (CriaLayout	* self,
						const char	* attribute);
void		cria_layout_set_name	       (CriaLayout	* self,
						const char	* attribute);

#define CRIA_TYPE_LAYOUT			(cria_layout_get_type ())
#define CRIA_LAYOUT(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_LAYOUT, CriaLayout))
#define CRIA_LAYOUT_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_LAYOUT, CriaLayoutClass))
#define CRIA_IS_LAYOUT(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_LAYOUT))
#define CRIA_IS_LAYOUT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_LAYOUT))
#define CRIA_LAYOUT_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_LAYOUT, CriaLayoutClass))

struct _CriaLayout
{
	GObject			  base_instance;
	gchar			* name;
	gchar			* description;
	GdkPixbuf		* background;

	CriaLayoutPrivate	* priv;
};

struct _CriaLayoutClass
{
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaLayout	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* LAYOUT_H */
