/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef DEBUG_H
#define DEBUG_H

#include <glib/gmessages.h>

G_BEGIN_DECLS

#ifdef G_HAVE_ISO_VARARGS
#define	g_debug(...)	g_log  (G_LOG_DOMAIN,		\
					G_LOG_LEVEL_DEBUG,	\
					__VA_ARGS__)
#elif defined(G_HAVE_GNUC_VARARGS)
#warning defined(G_HAVE_GNUC_VARARGS)
#define g_debug(format...)	g_log  (G_LOG_DOMAIN,		\
					G_LOG_LEVEL_DEBUG,	\
					format)
#else
#error "We don't know cria_debug now..."
#endif /* G_HAVE_ISO_VARGS */

G_END_DECLS

#endif /* DEBUG_H */
