/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef SLIDE_VIEW_H
#define SLIDE_VIEW_H

#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnomecanvas/libgnomecanvas.h>

#include "slide.h"

G_BEGIN_DECLS

typedef struct _CriaSlideView CriaSlideView;
typedef struct _CriaSlideViewClass CriaSlideViewClass;
typedef struct _CriaSlideViewPriv CriaSlideViewPriv;

GType		  cria_slide_view_get_type     (void);
GtkWidget	* cria_slide_view_new	       (void);
CriaSlide	* cria_slide_view_get_slide    (CriaSlideView	* self);
gdouble		  cria_slide_view_get_zoom     (CriaSlideView	* self);
void		  cria_slide_view_set_slide    (CriaSlideView	* self,
						CriaSlide	* slide);
void		  cria_slide_view_set_zoom     (CriaSlideView   * self,
						gdouble		  zoom);
void		  cria_slide_view_set_zoom_auto(CriaSlideView	* self,
						gboolean	  zoom_auto);

#define CRIA_TYPE_SLIDE_VIEW			(cria_slide_view_get_type ())
#define CRIA_SLIDE_VIEW(object)			(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE_VIEW, CriaSlideView))
#define CRIA_SLIDE_VIEW_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE_VIEW, CriaSlideViewClass))
#define CRIA_IS_SLIDE_VIEW(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE_VIEW))
#define CRIA_IS_SLIDE_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE_VIEW))
#define CRIA_SLIDE_VIEW_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE_VIEW, CriaSlideViewClass))

struct _CriaSlideView {
	GtkScrolledWindow	  base_instance;
	CriaSlideViewPriv	* priv;
};

struct _CriaSlideViewClass {
	GtkScrolledWindowClass	  base_class;

	/* signals */
	void (*slide_changed)  (CriaSlideView	* self,
				gpointer	  data);
	void (*zoom_changed)   (CriaSlideView	* self,
				gpointer	  data);
};

G_END_DECLS

#endif /* SLIDE_VIEW_H */

