/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* This file is part of criawips, a GNOME presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>

#ifndef IPRESENTATION_VIEW_H
#define IPRESENTATION_VIEW_H

#define CRIA_IPRESENTATION_VIEW_TYPE		(cria_ipresentation_view_get_type())
#define CRIA_IPRESENTATION(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), CRIA_IPRESENTATION_VIEW_TYPE, CriaIPresentationView))
#define CRIA_IPRESENTATION_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), CRIA_IPRESENTATION_VIEW_TYPE, CriaIPresentatioViewClass))
#define CRIA_IS_IPRESENTATION_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), CRIA_IPRESENTATION_VIEW_TYPE))
#define CRIA_IS_IPRESENTATION_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_IPRESENTATION_VIEW_TYPE))
#define CRIA_IPRESENTATION_VIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_INTERFACE((inst), CRIA_IPRESENTATION_VIEW_TYPE, CriaIPresentatioViewClass))

typedef struct _CriaIPresentationView CriaIPresentationView;
typedef struct _CriaIPresentationViewClass CriaIPresentationViewClass;

struct _CriaIPresentationViewClass {
	GTypeInterface	  parent;

	void (* presentation_changed)  (CriaIPresentationView	* self);
};

GType	cria_ipresentation_view_get_type	       (void);
void	cria_ipresentation_view_presentation_changed   (CriaIPresentationView	* self);

#endif /* !IPRESENTATION_VIEW_H */
