/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CANVAS_RECT_H
#define CANVAS_RECT_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _CriaCanvasRect CriaCanvasRect;
typedef struct _CriaCanvasRectClass CriaCanvasRectClass;

GType		cc_canvas_rect_get_type	       (void);
const gchar*	cc_canvas_rect_get_attribute       (CriaCanvasRect	* self);
void		cc_canvas_rect_set_attribute       (CriaCanvasRect	* self,
						const char	* attribute);

#define CC_TYPE_CANVAS_RECT			(cc_canvas_rect_get_type ())
#define CC_CANVAS_RECT(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CC_TYPE_CANVAS_RECT, CriaCanvasRect))
#define CC_CANVAS_RECT_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CC_TYPE_CANVAS_RECT, CriaCanvasRectClass))
#define CC_IS_CANVAS_RECT(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CC_TYPE_CANVAS_RECT))
#define CC_IS_CANVAS_RECT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CC_TYPE_CANVAS_RECT))
#define CC_CANVAS_RECT_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CC_TYPE_CANVAS_RECT, CriaCanvasRectClass))

struct _CriaCanvasRect {
	GObject		  base_instance;
	gchar		* attribute;
};

struct _CriaCanvasRectClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaCanvasRect	* self,
				const	gchar	* string);
};

G_END_DECLS

#endif /* CANVAS_RECT_H */

