/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CANVAS_ITEM_H
#define CANVAS_ITEM_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _CCCanvasItem CCCanvasItem;
typedef struct _CCCanvasItemClass CCCanvasItemClass;

typedef struct _CCCanvasGroup CCCanvasGroup;
typedef struct _CCCanvasGroupClass CCCanvasGroupClass;
typedef struct _CCCanvasGroupPriv CCCanvasGroupPriv;

/* CCCanvasItem */

CCCanvasItem	* cc_canvas_item_new		       (CCCanvasGroup	* parent,
							GType		  type,
							...);
GType		  cc_canvas_item_get_type	       (void);
const gchar*	  cc_canvas_item_get_attribute       (CCCanvasItem	* self);
void		  cc_canvas_item_set_attribute       (CCCanvasItem	* self,
						const char	* attribute);

#define CC_TYPE_CANVAS_ITEM			(cc_canvas_item_get_type ())
#define CC_CANVAS_ITEM(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CC_TYPE_CANVAS_ITEM, CCCanvasItem))
#define CC_CANVAS_ITEM_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CC_TYPE_CANVAS_ITEM, CCCanvasItemClass))
#define CC_IS_CANVAS_ITEM(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CC_TYPE_CANVAS_ITEM))
#define CC_IS_CANVAS_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CC_TYPE_CANVAS_ITEM))
#define CC_CANVAS_ITEM_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CC_TYPE_CANVAS_ITEM, CCCanvasItemClass))

struct _CCCanvasItem {
	GObject		  base_instance;
	gchar		* attribute;
};

struct _CCCanvasItemClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CCCanvasItem	* self,
				const	gchar	* string);
};

/* CCCanvasGroup */

GType		cc_canvas_group_get_type       (void);

#define CC_TYPE_CANVAS_GROUP			(cc_canvas_group_get_type ())
#define CC_CANVAS_GROUP(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CC_TYPE_CANVAS_GROUP, CCCanvasGroup))
#define CC_CANVAS_GROUP_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CC_TYPE_CANVAS_GROUP, CCCanvasGroupClass))
#define CC_IS_CANVAS_GROUP(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CC_TYPE_CANVAS_GROUP))
#define CC_IS_CANVAS_GROUP_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CC_TYPE_CANVAS_GROUP))
#define CC_CANVAS_GROUP_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CC_TYPE_CANVAS_GROUP, CCCanvasGroupClass))

struct _CCCanvasGroup {
	CCCanvasItem	   base_instance;
	gchar		 * attribute;
	CCCanvasGroupPriv* priv;
};

struct _CCCanvasGroupClass {
	CCCanvasItemClass  base_class;
};

G_END_DECLS

#endif /* CANVAS_ITEM_H */

