/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <glib.h>

#include "cc-canvas-group.h"

enum {
	PROP_0,
	PROP_ATTRIBUTE
};

enum {
	SIGNAL,
	N_SIGNALS
};

static	void	cc_canvas_group_get_property	       (GObject		* object,
						guint		  prop_id,
						GValue		* value,
						GParamSpec	* param_spec);
static	void	cc_canvas_group_set_property        (GObject		* object,
						guint		  prop_id,
						const	GValue	* value,
						GParamSpec	* param_spec);
#if 0
/* enable these to add support for signals */
static	guint	cc_canvas_group_signals[N_SIGNALS] = { 0 };

static	void	cc_canvas_group_signal	       (CCCanvasGroup	* self,
						const	gchar	* string);
#endif

static void
cc_canvas_group_class_init (CCCanvasGroupClass	* cc_canvas_group_class) {
	GObjectClass	* g_object_class;

	g_object_class = G_OBJECT_CLASS(cc_canvas_group_class);
#if 0
	/* setting up signal system */
	cc_canvas_group_class->signal = cc_canvas_group_signal;

	cc_canvas_group_signals[SIGNAL] = g_signal_new (
			"signal",
			CC_TYPE_CANVAS_GROUP,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CCCanvasGroupClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cc_canvas_group_set_property;
	g_object_class->get_property = cc_canvas_group_get_property;

	g_object_class_install_property (
			g_object_class,
			PROP_ATTRIBUTE,
			g_param_spec_string (
				"attribute",
				"Attribute",
				"A simple unneccessary attribute that does nothing special except "
				"being a demonstration for the correct implementation of a GObject "
				"property",
				"default_value",
				G_PARAM_READWRITE | G_PARAM_CONSTRUCT)
			);
}

const char*
cc_canvas_group_get_attribute (CCCanvasGroup* self) {
	g_return_val_if_fail (CC_IS_CANVAS_GROUP(self), NULL);
	
	return self->attribute;
}

static void
cc_canvas_group_get_property (
		GObject		* object,
		guint		  prop_id,
		GValue		* value,
		GParamSpec	* param_spec) {
	CCCanvasGroup	* self;

	self = CC_CANVAS_GROUP (object);

	switch (prop_id)
	{
	case PROP_ATTRIBUTE:
		g_value_set_string (
				value,
				self->attribute);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

GType
cc_canvas_group_get_type (void) {
	static GType	type = 0;

	if (!type)
	{
		const GTypeInfo info = {
			sizeof (CCCanvasGroupClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cc_canvas_group_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof (CCCanvasGroup),
			0,
			NULL,
			0
		};

		type = g_type_register_static (
				G_TYPE_OBJECT,
				"CCCanvasGroup",
				&info,
				0);
	}

	return type;
}

void
cc_canvas_group_set_attribute (
		CCCanvasGroup	* self,
		const gchar	* attribute) {
	g_return_if_fail (CC_IS_CANVAS_GROUP(self));

	if (self->attribute != NULL)
		g_free (self->attribute);

	self->attribute = g_strdup (attribute);

	g_object_notify (G_OBJECT (self), "attribute");
}

static void
cc_canvas_group_set_property (
		GObject		* object,
		guint		  prop_id,
		const	GValue	* value,
		GParamSpec	* param_spec) {
	CCCanvasGroup	* self;
	
	self = CC_CANVAS_GROUP (object);
	
	switch (prop_id)
	{
	case PROP_ATTRIBUTE:
		cc_canvas_group_set_attribute (
				self,
				g_value_get_string (value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

