/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gtk/gtk.h>

#include "cc-canvas.h"
#include "cc-canvas-item.h"
#include "cc-canvas-rect.h"
#include "cc-canvas-view.h"

int
main (int argc, char**argv) {
	GtkWidget	* main_window,
			* canvas_view;
	CCCanvas	* canvas;
	CCCanvasItem	* c_item;
	
	gtk_init(&argc, &argv);

	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(main_window),
			 "delete-event",
			 G_CALLBACK(gtk_main_quit),
			 NULL);

	canvas = cc_canvas_new();
	c_item = cc_canvas_item_new(cc_canvas_get_root(canvas),
			          CC_TYPE_CANVAS_RECT,
				  "x", 0.0,
				  "y", 0.0,
				  "fill-color", "blue",
				  NULL);
	
	canvas_view = cc_canvas_view_new();
	cc_canvas_view_set_canvas(CC_CANVAS_VIEW(canvas_view),
				  canvas);
	gtk_widget_show(canvas_view);
	
	gtk_container_add(GTK_CONTAINER(main_window),
			  canvas_view);
	gtk_widget_show(main_window);

	gtk_main();
	
	return 0;
}
