/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include "main-window.h"

#ifndef APPLICATION_H
#define APPLICATION_H

G_BEGIN_DECLS

typedef struct _CriaApplication CriaApplication;
typedef struct _CriaApplicationClass CriaApplicationClass;
typedef struct _CriaApplicationPriv CriaApplicationPriv;

void		  criawips_init			       (int		* argc,
							char	       ***argv);
void		  criawips_quit			       (void);
CriaApplication	* cria_application_get_instance	       (void);
GType		  cria_application_get_type	       (void);
void		  cria_application_register_window     (CriaMainWindow	* window);
void		  cria_application_show_error_dialog   (GtkWindow	* parent,
							gchar const	* title,
							gchar const	* message);

#define CRIA_TYPE_APPLICATION			(cria_application_get_type ())
#define CRIA_APPLICATION(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_APPLICATION, CriaApplication))
#define CRIA_APPLICATION_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_APPLICATION, CriaApplicationClass))
#define CRIA_IS_APPLICATION(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_APPLICATION))
#define CRIA_IS_APPLICATION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_APPLICATION))
#define CRIA_APPLICATION_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_APPLICATION, CriaApplicationClass))

struct _CriaApplication {
	GObject			  base_instance;
	CriaApplicationPriv	* priv;
};

struct _CriaApplicationClass {
	GObjectClass		  base_class;
#if 0
	/* signals */
	void (*signal)	       (CriaApplication	* template,
				const	gchar	* string);
#endif
};

G_END_DECLS

#endif /* APPLICATION_H */

