/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <glib/gtypes.h>
#include <gtk/gtkmain.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-init.h>
#include <libgnome/gnome-program.h>

#include "debug.h"
#include "slide-show.h"

//int x = -1, y, w = -1, h = -1, d = 0;
//char *debug_modules = NULL;
static const struct poptOption options[] =
{
//	{NULL, 'x', POPT_ARG_INT, &x, 0, N_("X position of window"), N_("X")},
//	{NULL, 'y', POPT_ARG_INT, &y, 0, N_("Y position of window"), N_("Y")},
//	{NULL, 'w', POPT_ARG_INT, &w, 0, N_("width of window"), N_("WIDTH")},
//	{NULL, 'h', POPT_ARG_INT, &h, 0, N_("height of window"), N_("WIDTH")},
//	{"debug", '\0', POPT_ARG_NONE, &d, 0, N_("Enable debugging"), NULL},
/*	{"debug-modules", '\0', POPT_ARG_STRING, &debug_modules, 0,
		N_("Modules to enable debugging in"), N_("MODULES")},
*/	{NULL, '\0', 0, NULL, 0}
};

static void
cria_main_quit (void)
{
	gtk_main_quit ();
}

gint
main (
		gint	  argc,
		gchar	**argv)
{
	CriaPresentation* p = NULL;
	CriaSlideShow	* ss;
	const gchar	**filenames;
	const gchar	**iterator;
	GnomeProgram	* gnome_program;
	GValue		* value;
	poptContext	  popt_context;

	g_set_prgname (PACKAGE);

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	/* initializing libraries */
	gtk_init (&argc, &argv);

	gnome_program = gnome_program_init (
			PACKAGE, PACKAGE_VERSION,
			LIBGNOME_MODULE, // module info
			argc, argv,
			GNOME_PARAM_POPT_TABLE, options,
			GNOME_PARAM_POPT_FLAGS, 0,
			NULL);

	value = g_new0 (GValue, 1);
	g_value_init (
			value,
			G_TYPE_POINTER);
	g_object_get_property(
			G_OBJECT (gnome_program),
			GNOME_PARAM_POPT_CONTEXT,
			value);

	popt_context = (poptContext) g_value_get_pointer (value);
	filenames = poptGetArgs(popt_context);

	if (!filenames)
	{
		/* opening a file selection */
		g_message ("No filename given, please start with '%s file.criawips'\nquitting", argv[0]);
		return 1;
	}
	else
	{
		for (iterator = filenames; *iterator; iterator++)
		{
			g_debug ("main(%s:%i): got filename \"%s\"", __FILE__, __LINE__, *iterator);
			// TODO handle each filename here
		}
		
		p = cria_presentation_new_from_file (*filenames);
	}

	ss = g_object_new (
			CRIA_TYPE_SLIDE_SHOW,
			"presentation", p,
			NULL);
		
	g_signal_connect (
			G_OBJECT (ss),
			"destroy",
			G_CALLBACK (cria_main_quit),
			NULL);
	
	gtk_main ();

	return 0;
}
