/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "title-bar.h"

#include <glib.h>
#include <glib/gi18n.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include <cdebug.h>

#include "slide-view.h"

enum {
	PROP_0,
#if 0
	PROP_MARKUP,
	PROP_TEXT,
#endif
};

enum {
	SIGNAL,
	N_SIGNALS
};

struct _CriaTitleBarPrivate {
	GtkWidget	* hbox,
			* button,
			* label,
			* combo;
	CriaSlide	* slide;
};

static GObjectClass* parent_class = NULL;
static	void	cria_title_bar_get_property	       (GObject		* object,
							guint		  prop_id,
							GValue		* value,
							GParamSpec	* param_spec);
static void	cria_title_bar_init		       (CriaTitleBar	* self);
static	void	cria_title_bar_set_property	       (GObject		* object,
							guint		  prop_id,
							const	GValue	* value,
							GParamSpec	* param_spec);
static void	cria_title_bar_update_title	       (CriaTitleBar	* self);
#if 0
/* enable these to add support for signals */
static	guint	cria_title_bar_signals[N_SIGNALS] = { 0 };

static	void	cria_title_bar_signal	       (CriaTitleBar	* self,
						const	gchar	* string);
#endif

static void
ctb_finalize(GObject* object) {
	CriaTitleBar* self = CRIA_TITLE_BAR(object);
	if(self->priv->slide) {
		g_object_unref(self->priv->slide);
		self->priv->slide = NULL;
	}
	
	parent_class->finalize(object);
}

static void
cria_title_bar_class_init(CriaTitleBarClass* cria_title_bar_class) {
	GObjectClass* g_object_class;

	parent_class = g_type_class_peek_parent(cria_title_bar_class);

	/* setting up the object class */
	g_object_class = G_OBJECT_CLASS(cria_title_bar_class);
	g_object_class->finalize = ctb_finalize;
#if 0
	/* setting up signal system */
	cria_title_bar_class->signal = cria_title_bar_signal;

	cria_title_bar_signals[SIGNAL] = g_signal_new (
			"signal",
			CRIA_TYPE_TITLE_BAR,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CriaTitleBarClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cria_title_bar_set_property;
	g_object_class->get_property = cria_title_bar_get_property;
#if 0
	g_object_class_install_property(g_object_class,
					PROP_MARKUP,
					g_param_spec_string("text",
							    "Text",
							    "A simple unneccessary attribute that does nothing special except "
							    "being a demonstration for the correct implementation of a GObject "
							    "property",
							    "default_value",
							    G_PARAM_READWRITE | G_PARAM_CONSTRUCT));
	g_object_class_install_property(g_object_class,
					PROP_TEXT,
					g_param_spec_string("text",
							    "Text",
							    "A simple unneccessary attribute that does nothing special except "
							    "being a demonstration for the correct implementation of a GObject "
							    "property",
							    "default_value",
							    G_PARAM_READWRITE | G_PARAM_CONSTRUCT));
#endif
	_cria_slide_view_install_properties(g_object_class);
}

static void
cria_title_bar_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* param_spec) {
	CriaTitleBar	* self;

	self = CRIA_TITLE_BAR(object);

	switch (prop_id) {
	case CRIA_SLIDE_VIEW_PROP_SLIDE:
		g_value_set_object(value, cria_title_bar_get_slide(self));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(
				object,
				prop_id,
				param_spec);
		break;
	}
}

CriaSlide*
cria_title_bar_get_slide(CriaTitleBar* self) {
	g_assert(self != NULL && CRIA_IS_TITLE_BAR(self));
	g_assert(self->priv != NULL);
	g_assert(self->priv->slide != NULL && CRIA_IS_SLIDE(self->priv->slide));
	
	return self->priv->slide;
}

GType
cria_title_bar_get_type (void) {
	static GType	type = 0;

	if(!type) {
		static const GTypeInfo info = {
			sizeof (CriaTitleBarClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cria_title_bar_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof (CriaTitleBar),
			0,
			(GInstanceInitFunc)cria_title_bar_init,
			0
		};

		static const GInterfaceInfo slide_view_info = {
			NULL, /* iface init */
			NULL, /* iface finalize */
			NULL  /* iface data */
		};

		type = g_type_register_static(CRIA_TYPE_TEXT_PANE,
					      "CriaTitleBar",
					      &info,
					      0);
		g_type_add_interface_static(type,
					    CRIA_TYPE_SLIDE_VIEW,
					    &slide_view_info);
	}

	return type;
}

static void
cria_title_bar_init(CriaTitleBar* self) {
	g_return_if_fail(CRIA_IS_TITLE_BAR(self));

	/* initialize the private data */
	self->priv = g_new0(CriaTitleBarPrivate,1);

	/* initialize the content of this widget * /
	 * add an hbox and pack these three in there:
	 *  1. a button to select between (SlideEditor;OutlineView;ThumbnailView;...)
	 *  2. a label to display a title [done]
	 *  3. a ComboBoxEntry to select the zoom level
	 */

/*	self->priv->button;
		set relief to none
		add an hbox as content (FALSE, 6)
			add a label ("Slide View"); FALSE, FALSE, 0
			add an arrow (down); FALSE, FALSE, 0
	connect signal
	pack start; FALSE, FALSE, 0 */

/*	self->priv->combo;
		request width (90)
	pack start; FALSE, FALSE, 0 */
}

GtkWidget*
cria_title_bar_new(CriaSlide* slide) {
	GtkWidget* retval;
	
	g_return_val_if_fail(slide == NULL || CRIA_IS_SLIDE(slide), NULL);

	retval = GTK_WIDGET(g_object_new(CRIA_TYPE_TITLE_BAR, NULL));

	if(slide) {
		cria_title_bar_set_slide(CRIA_TITLE_BAR(retval), slide);
	}

	return retval;
}

static void
cria_title_bar_set_property (
		GObject		* object,
		guint		  prop_id,
		const	GValue	* value,
		GParamSpec	* param_spec) {
	CriaTitleBar	* self;
	
	self = CRIA_TITLE_BAR (object);
	
	switch (prop_id) {
	case CRIA_SLIDE_VIEW_PROP_SLIDE:
		cria_title_bar_set_slide(self, g_value_get_object(value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object,
						  prop_id,
						  param_spec);
		break;
	}
}

static void
cb_slide_notify_title(CriaTitleBar* self) {
	g_assert(self != NULL && CRIA_IS_TITLE_BAR(self));

	cria_title_bar_update_title(self);
}

void
cria_title_bar_set_slide(CriaTitleBar* self, CriaSlide* slide) {
	g_return_if_fail(CRIA_IS_TITLE_BAR(self));
	g_return_if_fail(CRIA_IS_SLIDE(slide));

	if(self->priv->slide != NULL) {
		g_signal_handlers_disconnect_by_func(self->priv->slide, cb_slide_notify_title, self);
		g_object_unref(self->priv->slide);
	}

	self->priv->slide = g_object_ref(slide);
	g_signal_connect_swapped(self->priv->slide, "notify::title",
				 G_CALLBACK(cb_slide_notify_title), self);
	cria_title_bar_update_title(self);
	g_object_notify(G_OBJECT(self), "slide");
}

static void
cria_title_bar_update_title(CriaTitleBar* self) {
	gchar	* message;

#warning "TitleBar::updateTitle(): FIXME: add some 'slide give me your presentation' stuff and then fix the display in here"
	message = g_strdup_printf(/* "<span weight=\"bold\">%s %d/%d \"%s\"</span>", */
			
				  /* translators: this is "Slide \"slide-title\"" */
				  _("Slide \"%s\""),
				  /* cria_presentation_get_slide_index(self->priv->presentation, cria_slide_editor_get_slide(slide_editor)) + 1, */
				  /* cria_presentation_n_slides(self->priv->presentation), */
				  cria_slide_get_title(self->priv->slide));
	cria_text_pane_set_text(CRIA_TEXT_PANE(self), message);
	
	g_free(message);
}

