/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "slide-properties-dialog.h"

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "slide-view.h"

enum {
	PROP_0,
};

enum {
	SIGNAL,
	N_SIGNALS
};

struct _CriaSlidePropertiesDialogPrivate {
	GladeXML	* xml;
	CriaSlide	* slide;
};

static	void	cria_slide_properties_dialog_get_property      (GObject		* object,
								guint		  prop_id,
								GValue		* value,
								GParamSpec	* param_spec);
static	void	cria_slide_properties_dialog_init	       (CriaSlidePropertiesDialog* self);
static	void	cria_slide_properties_dialog_set_property      (GObject		* object,
								guint		  prop_id,
								const	GValue	* value,
								GParamSpec	* param_spec);
#if 0
/* enable these to add support for signals */
static	guint	cria_slide_properties_dialog_signals[N_SIGNALS] = { 0 };

static	void	cria_slide_properties_dialog_signal	       (CriaSlidePropertiesDialog	* self,
						const	gchar	* string);
#endif

static void
cria_slide_properties_dialog_class_init (CriaSlidePropertiesDialogClass	* cria_slide_properties_dialog_class) {
	GObjectClass	* g_object_class;

	g_object_class = G_OBJECT_CLASS(cria_slide_properties_dialog_class);
#if 0
	/* setting up signal system */
	cria_slide_properties_dialog_class->signal = cria_slide_properties_dialog_signal;

	cria_slide_properties_dialog_signals[SIGNAL] = g_signal_new (
			"signal",
			CRIA_TYPE_SLIDE_PROPERTIES_DIALOG,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CriaSlidePropertiesDialogClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cria_slide_properties_dialog_set_property;
	g_object_class->get_property = cria_slide_properties_dialog_get_property;

	/* setting up the slide view interface */
	_cria_slide_view_install_properties(g_object_class);
}

static void
cria_slide_properties_dialog_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* param_spec) {
	CriaSlidePropertiesDialog	* self;

	self = CRIA_SLIDE_PROPERTIES_DIALOG(object);

	switch(prop_id) {
	case CRIA_SLIDE_VIEW_PROP_SLIDE:
		g_value_set_object(value, cria_slide_properties_dialog_get_slide(self));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object,
						  prop_id,
						  param_spec);
		break;
	}
}

/**
 * cria_slide_properties_dialog_get_slide:
 * @self: a #CriaSlidePropertiesDialog
 *
 * Get the slide displayed by @self.
 *
 * Returns the slide displayed by @self.
 */
CriaSlide*
cria_slide_properties_dialog_get_slide(CriaSlidePropertiesDialog* self) {
	g_assert(CRIA_IS_SLIDE_PROPERTIES_DIALOG(self));
	g_assert(self->priv != NULL);
	
	return self->priv->slide;
}

GType
cria_slide_properties_dialog_get_type(void) {
	static GType	type = 0;

	if(!type) {
		static const GTypeInfo info = {
			sizeof(CriaSlidePropertiesDialogClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cria_slide_properties_dialog_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof(CriaSlidePropertiesDialog),
			0,
			(GInstanceInitFunc)cria_slide_properties_dialog_init,
			0
		};

		static const GInterfaceInfo slide_view_info = {
			NULL, /* iface init */
			NULL, /* iface finalize */
			NULL  /* iface data */
		};

		type = g_type_register_static(GTK_TYPE_DIALOG,
					      "CriaSlidePropertiesDialog",
					      &info,
					      0);
		g_type_add_interface_static(type,
					    CRIA_TYPE_SLIDE_VIEW,
					    &slide_view_info);
	}

	return type;
}

static void
cria_slide_properties_dialog_init(CriaSlidePropertiesDialog* self) {
	g_assert(CRIA_IS_SLIDE_PROPERTIES_DIALOG(self));

	/* setting up private data */
	self->priv = g_new0(CriaSlidePropertiesDialogPrivate,1);

	/* setting up the dialog's content */
	self->priv->xml = glade_xml_new(PACKAGE_DATA_DIR "/" PACKAGE "/data/criawips.glade", "slide_properties_notebook", NULL);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(self)->vbox), glade_xml_get_widget(self->priv->xml, "slide_properties_notebook"));

	/* setting up the gtk dialog */
	gtk_dialog_set_has_separator(GTK_DIALOG(self), FALSE);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(self)->vbox), 5);
        gtk_dialog_add_buttons(GTK_DIALOG(self),
#warning "SlidePropertiesDialog::init(): add help button"
                               GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
                               NULL);
	g_signal_connect(self, "close",
			 G_CALLBACK(gtk_object_destroy), NULL);
	g_signal_connect(self, "response",
			 G_CALLBACK(gtk_object_destroy), NULL);

	/* setting up the gtk container */
	gtk_container_set_border_width(GTK_CONTAINER(self), 5);
}

/**
 * cria_slide_properties_dialog_new:
 * @slide: a #CriaSlide
 *
 * Creates a new slide property dialog connected to @slide.
 *
 * Returns a new slide property dialog.
 */
GtkWidget*
cria_slide_properties_dialog_new(CriaSlide* slide) {
	g_assert(CRIA_IS_SLIDE(slide));

	return g_object_new(CRIA_TYPE_SLIDE_PROPERTIES_DIALOG, "slide", slide, NULL);
}

static void
cria_slide_properties_dialog_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* param_spec) {
	CriaSlidePropertiesDialog	* self;
	
	self = CRIA_SLIDE_PROPERTIES_DIALOG (object);
	
	switch(prop_id) {
	case CRIA_SLIDE_VIEW_PROP_SLIDE:
		cria_slide_properties_dialog_set_slide(self, g_value_get_object(value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object,
						  prop_id,
						  param_spec);
		break;
	}
}

/**
 * cria_slide_properties_dialog_set_slide:
 * @self: a #CriaSlidePropertiesDialog
 * @slide: a #CriaSlide
 *
 * Set the slide to be displayed in this properties dialog.
 */
void
cria_slide_properties_dialog_set_slide(CriaSlidePropertiesDialog* self, CriaSlide* slide) {
	g_assert(CRIA_IS_SLIDE_PROPERTIES_DIALOG(self));
	g_assert(self->priv != NULL);
	g_assert(CRIA_IS_SLIDE(slide));

	if(self->priv->slide) {
		g_object_unref(self->priv->slide);
	}

	self->priv->slide = g_object_ref(slide);

	g_object_notify(G_OBJECT(self), "slide");
}

