/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004,2005 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <goffice/utils/goffice-utils.h>
#include <utils/cria-lepton.h>

#include "alignment.h"

#ifndef BLOCK_H
#define BLOCK_H

G_BEGIN_DECLS

typedef struct _CriaBlock CriaBlock;
typedef struct _CriaBlockClass CriaBlockClass;

#include <dom/cria-slide.h>

CriaAlignment	cria_block_get_alignment       (CriaBlock	* self);
GOColor		cria_block_get_color	       (CriaBlock	* self);
CriaLepton      cria_block_get_format          (CriaBlock       * self);
const gchar*	cria_block_get_markup	       (CriaBlock	* self);
GType		cria_block_get_type	       (void);
const gchar*	cria_block_get_name	       (CriaBlock	* self);
GoRect*		cria_block_get_position	       (CriaBlock	* self);
CriaBlock*      cria_block_get_template        (CriaBlock       * self);
CriaVAlignment	cria_block_get_valignment      (CriaBlock	* self);
CriaBlock*	cria_block_new		       (CriaSlide	* slide,
						const gchar	* name);
void		cria_block_set_alignment       (CriaBlock	* self,
						CriaAlignment	  alignment);
void		cria_block_set_color	       (CriaBlock	* self,
						GOColor		  color);
void		cria_block_set_font_family     (CriaBlock	* self,
						const gchar	* family);
void		cria_block_set_font_size       (CriaBlock	* self,
						const gchar	* size);
void		cria_block_set_font_size_int   (CriaBlock	* self,
						gint		  size);
void	        cria_block_set_font_style      (CriaBlock	* self,
						const gchar	* style);
void            cria_block_set_font_weight     (CriaBlock       * self,
						const gchar     * weight);
void		cria_block_set_name	       (CriaBlock	* self,
						const gchar	* name);
void		cria_block_set_text	       (CriaBlock	* self,
						const gchar	* text);
void		cria_block_set_valignment      (CriaBlock	* self,
						CriaVAlignment	  valignment);

#define CRIA_TYPE_BLOCK			(cria_block_get_type ())
#define CRIA_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_BLOCK, CriaBlock))
#define CRIA_BLOCK_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), CRIA_TYPE_BLOCK, CriaBlockClass))
#define CRIA_IS_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_BLOCK))
#define CRIA_IS_BLOCK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_BLOCK))
#define CRIA_BLOCK_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_BLOCK, CriaBlockClass))

G_END_DECLS

#endif /* !BLOCK_H */

