/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib.h>
#include <glib-object.h>

#ifndef CDEBUG_H
#define CDEBUG_H

G_BEGIN_DECLS

#ifndef CDEBUG_DISABLED
void cdebug(const gchar* nspace, const gchar* format, ...);
void cdebugc(gconstpointer klass, const gchar* func, const gchar* format, ...);
void cdebugo(gconstpointer inst, const gchar* func, const gchar* format, ...);
void cdebugt(GType type, const gchar* func, const gchar* format, ...);
#else
#define cdebug(nspace, message, ...)		G_STMT_START{ (void)0; }G_STMT_END
#define cdebugc(klass, func, message, ...)	G_STMT_START{ (void)0; }G_STMT_END
#define cdebugo(inst, func, message, ...)	G_STMT_START{ (void)0; }G_STMT_END
#define cdebugt(type, func, message, ...)	G_STMT_START{ (void)0; }G_STMT_END
#endif

G_END_DECLS

#endif /* CDEBUG_H */
