/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include <glib-object.h>
#include <glib.h>
#include <gsf/gsf-libxml.h>

#include "debug.h"
#include "presentation-parser.h"

typedef struct
{
	void	* pointer;
}
Sax001Data;

// this structure includes everyting that we need to parse a 0.0.1 document (most recent)
static xmlSAXHandler    doc_0_0_1_handler;

CriaPresentation *
cria_presentation_parser_get_new_presentation (GsfInput *input)
{
	CriaPresentation* presentation = NULL;
	xmlParserCtxt	* context;

	g_debug ("cria_presentation_parser_get_new_presentation(%i): start", __LINE__);

	context = gsf_xml_parser_context (input);
	// TODO detect the document type version
	context->sax = &doc_0_0_1_handler;
	context->userData = g_new0 (Sax001Data, 1);

	// TODO add dtd check and dtd validation
	xmlParseDocument (context);

	if (context->wellFormed)
	{
		g_debug ("cria_presentation_parser_get_new_presentation(%i): well formed document", __LINE__);
		presentation = g_object_new (
				CRIA_TYPE_PRESENTATION,
				NULL);
	}
	else
	{
		g_debug ("cria_presentation_parser_get_new_presentation(%i): that document is waste", __LINE__);
	}

	g_debug ("cria_presentation_parser_get_new_presentation(%i): end", __LINE__);
	return presentation;
}

static struct
{
	const char	       * tagname;
	void (*start_element)  (GHashTable	* attributes,
				Sax001Data	* data);
	void (*end_element)    (Sax001Data	* data);
}
tag_0_0_1_parsing[] =
{
	{NULL, NULL, NULL}
};

static void
doc_0_0_1_start_element (
		gpointer	  user_data,
		xmlChar const	* name,
		xmlChar const	**attributes)
{
	int		  i = 0;
	GHashTable	* hash_table;
	char		* key = NULL;
	
	g_debug ("doc_0_0_1_start_element(%i): start", __LINE__);

	hash_table = g_hash_table_new_full (
			g_str_hash,
			g_str_equal,
			g_free,
			g_free);

	g_debug ("doc_0_0_1_start_element(%i): checking attributes...", __LINE__);
	for (i = 0; attributes && attributes[i]; i++)
	{
		if (!key)
		{
			key = g_strdup (attributes[i]);
		}
		else
		{
			g_hash_table_insert (
					hash_table,
					key,
					g_strdup (attributes[i]));
		}
	}
	
	g_debug ("doc_0_0_1_start_element(%i): looking for tag parsing data...", __LINE__);
	for (i = 0; tag_0_0_1_parsing[i].tagname; i++)
	{
		if (strcmp (tag_0_0_1_parsing[i].tagname, name) == 0)
			break;
	}

	g_debug ("doc_0_0_1_start_element(%i): parsing tag", __LINE__);
	if (tag_0_0_1_parsing[i].start_element)
		tag_0_0_1_parsing[i].start_element (hash_table, (Sax001Data*)user_data);

	g_hash_table_destroy (hash_table);

	g_debug ("doc_0_0_1_start_element(%i): end", __LINE__);
}

static void
doc_0_0_1_end_element (
		gpointer	  user_data,
		xmlChar	const	* name)
{
	int		  i = 0;

	g_debug ("doc_0_0_1_end_element(%i): start", __LINE__);

	for (i = 0; tag_0_0_1_parsing[i].tagname; i++)
	{
		if (strcmp (tag_0_0_1_parsing[i].tagname, name) == 0)
			break;
	}

	if (tag_0_0_1_parsing[i].end_element)
		tag_0_0_1_parsing[i].end_element ((Sax001Data*)user_data);
	
	g_debug ("doc_0_0_1_end_element(%i): end", __LINE__);
}

static xmlSAXHandler	doc_0_0_1_handler = {
	NULL,	//internalSubsetSAXFunc internalSubset;
	NULL,	//isStandaloneSAXFunc isStandalone;
	NULL,	//hasInternalSubsetSAXFunc hasInternalSubset;
	NULL,	//hasExternalSubsetSAXFunc hasExternalSubset;
	NULL,	//resolveEntitySAXFunc resolveEntity;
	NULL,	//getEntitySAXFunc getEntity;
	NULL,	//entityDeclSAXFunc entityDecl;
	NULL,	//notationDeclSAXFunc notationDecl;
	NULL,	//attributeDeclSAXFunc attributeDecl;
	NULL,	//lementDeclSAXFunc elementDecl;
	NULL,	//unparsedEntityDeclSAXFunc unparsedEntityDecl;
	NULL,	//setDocumentLocatorSAXFunc setDocumentLocator;
	NULL,	//startDocumentSAXFunc startDocument;
	NULL,	//endDocumentSAXFunc endDocument;
	doc_0_0_1_start_element,	//startElementSAXFunc startElement;
	doc_0_0_1_end_element,	//endElementSAXFunc endElement;
	NULL,	//referenceSAXFunc reference;
	NULL,	//charactersSAXFunc characters;
	NULL,	//ignorableWhitespaceSAXFunc ignorableWhitespace;
	NULL,	//processingInstructionSAXFunc processingInstruction;
	NULL,	//commentSAXFunc comment;
	NULL,	//warningSAXFunc warning;
	NULL,	//errorSAXFunc error;
	NULL	//fatalErrorSAXFunc fatalError;
};

