/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef LAYOUT_BLOCK_H
#define LAYOUT_BLOCK_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _CriaLayoutBlock CriaLayoutBlock;
typedef struct _CriaLayoutBlockClass CriaLayoutBlockClass;

typedef enum
{
	CRIA_UNIT_PIXEL,
	CRIA_UNIT_PERCENT
} CriaUnit;

typedef enum
{
	CRIA_ALIGNMENT_LEFT,
	CRIA_ALIGNMENT_CENTER,
	CRIA_ALIGNMENT_RIGHT
} CriaAlignment;
	//TODO implement CRIA_ALIGNMENT_JUSTIFY

typedef enum
{
	CRIA_ALIGNMENT_TOP,
	CRIA_ALIGNMENT_MIDDLE,
	CRIA_ALIGNMENT_BOTTOM
} CriaVAlignment;

CriaAlignment	cria_layout_block_get_alignment	       (CriaLayoutBlock	* self);
const char *	cria_layout_block_get_default_text     (CriaLayoutBlock	* self);
const char *	cria_layout_block_get_font_family      (CriaLayoutBlock	* self);
gdouble		cria_layout_block_get_font_size	       (CriaLayoutBlock	* self);
gdouble		cria_layout_block_get_height	       (CriaLayoutBlock	* self);
gdouble		cria_layout_block_get_pos_x	       (CriaLayoutBlock	* self);
gdouble		cria_layout_block_get_pos_y	       (CriaLayoutBlock	* self);
const gchar*	cria_layout_block_get_title	       (CriaLayoutBlock	* self);
GType		cria_layout_block_get_type	       (void);
gdouble		cria_layout_block_get_width	       (CriaLayoutBlock	* self);
void		cria_layout_block_set_alignment	       (CriaLayoutBlock	* self,
							CriaAlignment	  alignment);
void		cria_layout_block_set_default_text     (CriaLayoutBlock	* self,
							char const	* default_text);
void		cria_layout_block_set_font_family      (CriaLayoutBlock	* self,
							char const	* font_family);
void		cria_layout_block_set_font_size	       (CriaLayoutBlock	* self,
							gdouble		  font_size);
void		cria_layout_block_set_height	       (CriaLayoutBlock	* self,
							gdouble		  height);
void		cria_layout_block_set_height_unit      (CriaLayoutBlock	* self,
							CriaUnit	  unit);
void		cria_layout_block_set_pos_x	       (CriaLayoutBlock	* self,
							gdouble		  pos_x);
void		cria_layout_block_set_pos_x_unit       (CriaLayoutBlock	* self,
							CriaUnit	  unit);
void		cria_layout_block_set_pos_y	       (CriaLayoutBlock	* self,
							gdouble		  pos_y);
void		cria_layout_block_set_pos_y_unit       (CriaLayoutBlock	* self,
							CriaUnit	  unit);
void		cria_layout_block_set_width	       (CriaLayoutBlock	* self,
							gdouble		  width);
void		cria_layout_block_set_width_unit       (CriaLayoutBlock	* self,
							CriaUnit	  unit);
void		cria_layout_block_set_title	       (CriaLayoutBlock	* self,
							const char	* attribute);
void		cria_layout_block_set_valignment       (CriaLayoutBlock	* self,
							CriaVAlignment	  valignment);

CriaAlignment	cria_alignment_from_string	       (char	const	* stirng);
gdouble		cria_unit_val_from_string	       (char	const	* string);
CriaUnit	cria_unit_unit_from_string	       (char    const   * string);
CriaVAlignment	cria_valignment_from_string	       (char	const	* string);

#define CRIA_TYPE_LAYOUT_BLOCK			(cria_layout_block_get_type ())
#define CRIA_LAYOUT_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_LAYOUT_BLOCK, CriaLayoutBlock))
#define CRIA_LAYOUT_BLOCK_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_LAYOUT_BLOCK, CriaLayoutBlockClass))
#define CRIA_IS_LAYOUT_BLOCK(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_LAYOUT_BLOCK))
#define CRIA_IS_LAYOUT_BLOCK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_LAYOUT_BLOCK))
#define CRIA_LAYOUT_BLOCK_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_LAYOUT_BLOCK, CriaLayoutBlockClass))

struct _CriaLayoutBlock
{
	GObject		  base_instance;
	gchar		* title;
	gdouble		  pos_x, pos_y;
	CriaUnit	  pos_x_unit, pos_y_unit;
	gdouble		  width, height;
	CriaUnit	  width_unit, height_unit;
	CriaAlignment	  alignment;
	CriaVAlignment	  valignment;
	gchar		* font_family;
	gdouble		  font_size;
	gchar		* default_text;
};

struct _CriaLayoutBlockClass
{
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaLayoutBlock	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* LAYOUT_BLOCK_H */
