/*
	cooldhlt.c - coold kernel module
	
	HLT instuction loop.
*/

/*
	Copyright (C) 2004 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Comment this out to compile */
#error "Be sure to read the README and understand the risks of using this module"

#define __KERNEL__
#define MODULE

#include <linux/modversions.h> 
#include <linux/module.h>  

#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h>

static int cooldhlt_input(struct file *file,
													const char *buffer,
													unsigned long count, 
													void *data)
{
	char cool_state;
	cool_state = 0;

	MOD_INC_USE_COUNT; /* Do not allow module to be removed */

	/* Read the /proc file */
	if(copy_from_user(&cool_state, buffer, 1)) {
		MOD_DEC_USE_COUNT;
		return -EFAULT;
	}

	if(cool_state)
	{
		/* Check if HLTing works okay */
		if(current_cpu_data.hlt_works_ok)
		{
			struct timeval tv, endtv;
			do_gettimeofday(&endtv);
			endtv.tv_sec += 5; /* FIXME: 5 seconds hardcoded */

			/* Run the HLT loop for a short duration */
			while(1)
			{
				__cli();
				safe_halt();
				do_gettimeofday(&tv);
				if(tv.tv_sec > endtv.tv_sec)
					break;
				else if((tv.tv_sec == endtv.tv_sec) && (tv.tv_usec >= endtv.tv_usec))
					break;
			}
		}
	}

	MOD_DEC_USE_COUNT;

	return 1;
}

int init_module()
{
	struct proc_dir_entry *cooldhlt_proc_dir_entry;

	cooldhlt_proc_dir_entry = create_proc_entry("cooldhlt", 0200, NULL);
	if(cooldhlt_proc_dir_entry == NULL) {
		return -ENOMEM;
	}

	cooldhlt_proc_dir_entry->write_proc = cooldhlt_input;
	cooldhlt_proc_dir_entry->owner = THIS_MODULE;

	return 0;
}

void cleanup_module()
{
	remove_proc_entry("cooldhlt", NULL);
}

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Brian Gunlogson");
MODULE_DESCRIPTION("/proc interface for hlt loop");
