#include "confuse.h"

int main(void)
{
	cfgopt_t bookmark_opts[] = {
		CFG_STR("machine", 0, 0),
		CFG_INT("port", 0, 0),
		CFG_STR("login", 0, 0),
		CFG_STR("password", 0, 0),
		CFG_STR("directory", 0, 0),
		CFG_BOOL("passive-mode", cfg_false, 0),
		CFG_END()
	};
	cfgopt_t proxy_opts[] = {
		CFG_INT("type", 0, 0),
		CFG_STR("host", 0, 0),
		CFG_STR("exclude", "localhost", CFGF_LIST),
		CFG_INT("port", 0, 0),
		CFG_END()
	};

	cfgopt_t opts[] = {
		CFG_INT("backlog", 42, 0),
		CFG_STR("probe-device", "eth2", 0),
		CFG_SEC("bookmark", bookmark_opts, CFGF_MULTI | CFGF_TITLE),
		CFG_SEC("proxy", proxy_opts, 0),
		CFG_FLOAT("delays", 7326.79221534e-6, CFGF_LIST),
		CFG_END()
	};
	int i;
	cfg_t *cfg;
	cfg_t *sec;
	unsigned n;
	int ret;

	printf("Using %s\n\n", confuse_copyright);

	cfg = cfg_init(opts, 0);
	ret = cfg_parse(cfg, "test.conf");
	if(ret == -1) {
		perror("./test.conf");
		return 1;
	} else if(ret == 1)
		return 2;

	printf("backlog == %ld\n", cfg_getint(cfg, "backlog"));
	printf("probe device is %s\n", cfg_getstr(cfg, "probe-device"));

	sec = cfg_getsec(cfg, "proxy");
	printf("proxy host is %s\n", cfg_getstr(sec, "host"));

	n = cfg_size(cfg, "bookmark");
	printf("%d configured bookmarks:\n", n);
	for(i = 0; i < n; i++) {
		sec = cfg_getnsec(cfg, "bookmark", i);
		printf("  bookmark #%u (%s):\n", i+1, cfg_title(sec));
		printf("    machine == %s\n", cfg_getstr(sec, "machine"));
		printf("    port == %d\n", (int)cfg_getint(sec, "port"));
		printf("    login == %s\n", cfg_getstr(sec, "login"));
		printf("    passive-mode == %s\n",
			   cfg_getbool(sec, "passive-mode") ? "true" : "false");
		printf("    directory == %s\n", cfg_getstr(sec, "directory"));
		printf("    password == %s\n", cfg_getstr(sec, "password"));
	}

	sec = cfg_getsec(cfg, "proxy");
	printf("proxy type is %ld\n", cfg_getint(sec, "type"));

	n = cfg_size(sec, "exclude");
	for(i = 0; i < n; i++) {
		printf(" exclude %s\n", cfg_getnstr(sec, "exclude", i));
	}

	printf("delays are:\n");
	for(i = 0; i < cfg_size(cfg, "delays"); i++)
		printf(" %G\n", cfg_getnfloat(cfg, "delays", i));

	cfg_free(cfg);
	return 0;
}
