/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <gtkmm/window.h>

#include <conexusgtk/conexusgtk.h>

class MainWindow : public Gtk::Window
{

public:
  MainWindow();
  virtual ~MainWindow();

protected:
  conexusgtk::IP::DottedDecimalEntry m_ddentry;
  conexusgtk::IP::HostEntry m_hostentry;
  conexusgtk::IP::PortEntry m_portentry;
  conexusgtk::IP::HostPortEntry m_hostportentry;
  conexus::IP::Address m_addr;
  conexusgtk::SerialComboBox m_serialbox;
  Gtk::Button m_serial_transmit;
  conexus::TTY m_serial;
  Gtk::Label m_addr_host, m_addr_port, m_serialdevice;
  conexus::IP::UDP m_udp;
  sigc::connection m_timer;
  conexusgtk::IOBlockButton m_blocker;

  void on_host_changed(bool);
  void on_port_changed();
  void on_serial_changed();

  bool send();
  void start_stop(bool, bool);

  void on_serial_transmit();

  conexus::IP::UDP udp1;

};

#endif // MAINWINDOW_H
