/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>

#include <iostream>

using namespace conexus;

/**
 * This client sends a simple UDP data stream to a given host (defaults to
 * localhost) on a given port (defaults to 1500)
 */

int main(int argc, char* argv[]) {
  // declare the local UDP connection point
  IP::UDP udp;

  // declare the address object that will be used to specify the destination
  IP::Address addr;

  // The data to send
  char data[] = "0123456789";

  // Some default values for host and port
  char defaulthost[] = "255.255.255.255";
  char* host = defaulthost;
  int port = 1500;

  // Check to see if user provided command line arguments and change
  // host and port variables if necessary
  if (argc > 1)
    host = argv[1];

  if (argc > 2)
    port = atoi(argv[2]);

  // Set the address object to the destination hostname and port
  addr.set_hostname(host);
  addr.set_port(port);

  // Example of the sendto method which requires a destination address,
  // but doesn't require a connected port
//   udp.sendto(addr, data, 11);

  // Example of using the connect and send method. The send method doesn't
  // require an address, but instead requires a connected UDP object and
  // just sends to the connected destination.
  udp.set_remote_address(addr);
  udp.set_write_without_connect(true);
  udp.write(data, 11);
  std::cout << "1 transmitted" << std::endl;
  Data d(data, 11);
  udp << d;
  std::cout << "2 transmitted" << std::endl;

  return 0;
}
