/***************************************************************************
*   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
*   rvinyard@cs.nmsu.edu                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License as        *
*   published by the Free Software Foundation version 2.1.                *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU Lesser General Public      *
*   License along with this library; if not, write to the                 *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
***************************************************************************/
#include <conexus/conexus.h>

#include <iostream>

/**
 * This client sends a simple data stream on ttyS0
 */

int main(int argc, char* argv[]) {
  // declare the local UDP connection point
  conexus::TTY tty;

  conexus::init();

  // The data to send
  char data[] = "0123456789\n";
  char default_serial[] = "/dev/ttyS0";
  char* serial = default_serial;

  // Check to see if user provided command line arguments and change
  // variables if necessary
  if (argc > 1)
    serial = argv[1];

//   tty.open(serial);
  tty.set_device(serial);
//   tty.open();
  tty.write(data, 12);
  std::cout << "1 transmitted" << std::endl;
  conexus::Data d(data, 12);
  tty << d;
  std::cout << "2 transmitted" << std::endl;

  return 0;
}
